//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OtBbNXfoCXwb_
 * @author Junpee
 */

#ifndef GRAPHICS_DEVICE_H_
#define GRAPHICS_DEVICE_H_

namespace Lamp{

class GraphicsDeviceSettings;

//------------------------------------------------------------------------------
/**
 * OtBbNXfoCX
 */
class GraphicsDevice{
friend class LampGraphics;
public:
	//--------------------------------------------------------------------------
	/**
	 * CX^X擾
	 * @return CX^X
	 */
	static GraphicsDevice* getInstance(){
		Assert(instance_ != NULL);
		return instance_;
	}

	//--------------------------------------------------------------------------
	// foCX\zIvV
	//--------------------------------------------------------------------------
	/**
	 * J[\Nbv̐ݒ
	 * @param clipFlag trueȂJ[\Nbv
	 */
	void setClipCursor(bool clipFlag){ clipCursor_ = clipFlag; }

	/**
	 * J[\Nbv̎擾
	 * @return trueȂJ[\Nbv
	 */
	bool getClipCursor(){ return clipCursor_; }

	//--------------------------------------------------------------------------
	// foCX
	//--------------------------------------------------------------------------
	/**
	 * NA
	 * @param color NAJ[
	 * @param zValue ZNAl
	 * @param stencilValue XeVNAl
	 */
	void clear(Color4c color = Color4c(0, 0, 0, 0),
		float zValue = 1.0f, u_int stencilValue = 0);

	/**
	 * v[e[V
	 * @return foCXXgĂtrueԂ
	 */
	bool presentation();

	/**
	 * tXN[[hƃEBhE[h؂ւ
	 */
	void toggleFullscreen();

	/**
	 * IɃEBhE[hɂ
	 */
	void forceWindowed();

	/**
	 * foCXč\z܂
	 * @return trueԂ
	 */
	bool rebuild();

protected:
	//--------------------------------------------------------------------------
	// AfoCXǗ
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	GraphicsDevice();

	/**
	 * fXgN^
	 */
	virtual ~GraphicsDevice();

	/**
	 * EBhEnh̏
	 * @param windowHandle EBhEnh
	 */
	void initializeWindowHandle(HWND windowHandle);

	/**
	 * 
	 * @return trueԂ
	 */
	bool initialize();

	/**
	 * Zbg
	 * @return trueԂ
	 */
	bool reset();

	/**
	 * J[\̃Nbv
	 */
	void clipCursor();

	/**
	 * n
	 */
	void cleanup();

	/**
	 * Direct3DfoCX̎擾
	 * @return Direct3DfoCX
	 */
	Direct3DDevice* getDirect3DDevice(){ return direct3DDevice_; }

	//--------------------------------------------------------------------------
	// EBhE֌W
	//--------------------------------------------------------------------------
	/**
	 * EBhEvV[W
	 * @param windowHandle EBhEnh
	 * @param message bZ[W
	 * @param wParam wbZ[Wp[^
	 * @param lParam lbZ[Wp[^
	 */
	LRESULT windowProcedure(
		HWND windowHandle, u_int message, WPARAM wParam, LPARAM lParam);

	/**
	 * EBhE̒
	 */
	void adjustWindowForChange();

	/**
	 * EBhETCYύX
	 */
	void handlePossibleSizeChange();

	//--------------------------------------------------------------------------
private:
	// Rs[RXgN^̉B
	GraphicsDevice(const GraphicsDevice& copy);

	// Rs[̉B
	void operator =(const GraphicsDevice& copy);

	// Direct3DfoCX
	Direct3DDevice* direct3DDevice_;
	// v[e[Vp[^
	D3DPRESENT_PARAMETERS presentationParameter_;
	// OtBbNXfoCXݒ
	GraphicsDeviceSettings* settings_;
	// EBhEnh
	HWND windowHandle_;
	// EBhEX^C
	u_int windowStyle_;
	// EBhEoEYTCY
	RECT windowBoundsSize_;
	// EBhENCAgTCY
	RECT windowClientSize_;
	// j[nh
	HMENU menuHandle_;

	// foCXXgĂȂ
	bool deviceLost_;
	// J[\Nbv邩
	bool clipCursor_;
	// ő剻Ă邩ǂ
	bool windowMaximized_;
	// ŏĂ邩ǂ
	bool windowMinimized_;
	// TCYύX𖳎
	bool ignoreSizeChange_;

	// CX^X
	static GraphicsDevice* instance_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of GRAPHICS_DEVICE_H_
//------------------------------------------------------------------------------

