//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * VF[_}l[Wwb_
 * @author Junpee
 */

#ifndef SHADER_MANAGER_H_
#define SHADER_MANAGER_H_

namespace Lamp{

class BasicShaderFixed;

//------------------------------------------------------------------------------
/**
 * VF[_}l[W
 */
class ShaderManager{
friend class LampGraphics;
public:
	//--------------------------------------------------------------------------
	/**
	 * CX^X擾
	 * @return CX^X
	 */
	static ShaderManager* getInstance(){
		Assert(instance_ != NULL);
		return instance_;
	}

	//--------------------------------------------------------------------------
	/**
	 * {VF[_ŒpCvC̎擾
	 * @return {VF[_ŒpCvC
	 */
	BasicShaderFixed* getBasicShaderFixed() const{ return basicShaderFixed_; }

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 */
	ShaderManager();

	/**
	 * fXgN^
	 */
	~ShaderManager();

	/// {VF[_ŒpCvC
	BasicShaderFixed* basicShaderFixed_;

	//--------------------------------------------------------------------------
private:
	// Rs[RXgN^̉B
	ShaderManager(const ShaderManager& copy);

	// Rs[̉B
	void operator =(const ShaderManager& copy);

	// CX^X
	static ShaderManager* instance_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SHADER_MANAGER_H_
//------------------------------------------------------------------------------
