//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * VF[_wb_
 * @author Junpee
 */

#ifndef SHADER_H_
#define SHADER_H_

namespace Lamp{

class RenderingDevice;
class DrawRequest;
class Material;
class Texture;

//------------------------------------------------------------------------------
/**
 * VF[_
 */
class Shader{
friend class ShaderManager;
public:
	/// őANeBuCg
	static const int maxActiveLightCount_;

protected:
	/**
	 * RXgN^
	 */
	Shader();

	/**
	 * fXgN^
	 */
	virtual ~Shader();

	/**
	 * }eAJn̍\z
	 * @param material }eA
	 */
	virtual void buildMaterialStart(Material* material);

	/**
	 * }eAI̍\z
	 * @param material }eA
	 */
//	virtual void buildMaterialEnd(Material* material);

	//--------------------------------------------------------------------------
	// `R[
	//--------------------------------------------------------------------------
	/**
	 * `R[
	 * @param request `惊NGXg
	 */
	virtual void drawCall(DrawRequest* request);

	//--------------------------------------------------------------------------
	/// _OfoCX
	RenderingDevice* device_;

private:
	// Rs[RXgN^̉B
	Shader(const Shader& copy);

	// Rs[̉B
	void operator =(const Shader& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SHADER_H_
//------------------------------------------------------------------------------
