//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ŒpCvCVF[_wb_
 * @author Junpee
 */

#ifndef FIXED_SHADER_H_
#define FIXED_SHADER_H_

#include <Graphics/Shader/Shader.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * ŒpCvCVF[_
 */
class FixedShader : public Shader{
friend class ShaderManager;
public:

protected:
	/**
	 * RXgN^
	 */
	FixedShader();

	/**
	 * fXgN^
	 */
	virtual ~FixedShader();

	//--------------------------------------------------------------------------
	// Xe[gubN
	//--------------------------------------------------------------------------
	/**
	 * }eAJn̍\z
	 * @param material }eA
	 */
	virtual void buildMaterialStart(Material* material);

	/**
	 * }eAI̍\z
	 * @param material }eA
	 */
	//virtual void buildMaterialEnd(Material* material);

	//--------------------------------------------------------------------------
	// eNX`
	//--------------------------------------------------------------------------
	/**
	 * Œ@\eNX`ݒ
	 * @param textureStage eNX`Xe[W
	 * @param texture eNX`
	 */
	virtual void setFixedTexture(int textureStage, Texture* texture);


	/**
	 * Œ@\x[XeNX`̐ݒ
	 * @param colorStage J[Xe[W
	 * @param baseTexture x[XeNX`
	 * @param baseUVIndex x[XUVCfbNX
	 * @return J[Xe[W
	 */
	virtual int setFixedBaseTexture(
		int colorStage, Texture* baseTexture, int baseUVIndex);

	//--------------------------------------------------------------------------
	/**
	 * Œ@\CgeNX`̐ݒ
	 * @param colorStage J[Xe[W
	 * @param lightTexture CgeNX`
	 * @param lightUVIndex CgUVCfbNX
	 * @return J[Xe[W
	 */
	virtual int setFixedLightTexture(
		int colorStage, Texture* lightTexture, int lightUVIndex);

	//--------------------------------------------------------------------------
	/**
	 * Œ@\eNX`̐ݒ
	 * @param colorStage J[Xe[W
	 * @param stainTexture eNX`
	 * @param stainUVIndex UVCfbNX
	 * @return J[Xe[W
	 */
	virtual int setFixedStainTexture(
		int colorStage, Texture* stainTexture, int stainUVIndex);

	//--------------------------------------------------------------------------
	// `̏
	//--------------------------------------------------------------------------
	/**
	 * Œ@\`̃ZbgAbv
	 * @param request `惊NGXg
	 */
	virtual void setupFixedDraw(DrawRequest* request);

	//--------------------------------------------------------------------------
	/**
	 * Œ@\s̐ݒ
	 * @param request `惊NGXg
	 */
	virtual void setMatrixFixed(DrawRequest* request);

	/**
	 * Œ@\tHOIvV̐ݒ
	 * @param request `惊NGXg
	 */
	virtual void setFogOptionFixed(DrawRequest* request);

	/**
	 * Œ@\Cg̃ZbgAbv
	 * @param request `惊NGXg
	 */
	virtual void setupFixedLight(DrawRequest* request);

	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * Œ@\`
	 * @param request `惊NGXg
	 */
	virtual void drawFixed(DrawRequest* request);

	//--------------------------------------------------------------------------
	// `̌n
	//--------------------------------------------------------------------------
	/**
	 * Œ@\`̃Zbg
	 * @param request `惊NGXg
	 */
	virtual void resetFixedDraw(DrawRequest* request);

	/**
	 * Œ@\tHOIvṼZbg
	 * @param request `惊NGXg
	 */
	virtual void resetFogOptionFixed(DrawRequest* request);

	//--------------------------------------------------------------------------
private:

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of FIXED_SHADER_H_
//------------------------------------------------------------------------------
