//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * {VF[_ŒpCvCwb_
 * @author Junpee
 */

#ifndef BASIC_SHADER_FIXED_H_
#define BASIC_SHADER_FIXED_H_

#include <Graphics/Shader/FixedShader.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * {VF[_ŒpCvC
 */
class BasicShaderFixed : public FixedShader{
friend class ShaderManager;
public:
	/**
	 * Xe[gubN̍\z
	 * @param startBlock [out]JnXe[gubN
	 * @param endBlock [out]IXe[gubN
	 * @param material }eA
	 * @param baseTexture x[XeNX`
	 * @param baseUVIndex x[XUVCfbNX
	 * @param lightTexture CgeNX`
	 * @param lightUVIndex CgUVCfbNX
	 * @param stainTexture eNX`
	 * @param stainUVIndex UVCfbNX
	 * @param diffuseColor fBt[YJ[
	 * @param specularColor XyLJ[
	 * @param ambientColor ArGgJ[
	 * @param emissiveColor G~bVuJ[
	 * @param specularPower XyLp[
	 */
	virtual void buildStateBlock(
		Direct3DStateBlock** startBlock, Direct3DStateBlock** endBlock,
		Material* material, Texture* baseTexture, int baseUVIndex,
		Texture* lightTexture, int lightUVIndex, Texture* stainTexture,
		int stainUVIndex, const Color3f& diffuseColor,
		const Color3f& specularColor, const Color3f& ambientColor,
		const Color3f& emissiveColor, float specularPower);

	/**
	 * `
	 * @param request `惊NGXg
	 */
	virtual void draw(DrawRequest* request);

protected:
	/**
	 * RXgN^
	 */
	BasicShaderFixed();

	/**
	 * fXgN^
	 */
	virtual ~BasicShaderFixed();

private:

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of BASIC_SHADER_FIXED_H_
//------------------------------------------------------------------------------

