//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[m[h}l[Wwb_
 * @author Junpee
 */

#ifndef SCENE_NODE_MANAGER_H_
#define SCENE_NODE_MANAGER_H_

#include <Graphics/Scene/SceneObjectManagerTemplate.h>
#include <Graphics/SceneNode/SceneNode.h>
#include <Graphics/SceneNode/LODSceneNode.h>
#include <Graphics/SceneNode/SceneLeaf.h>

namespace Lamp{
//------------------------------------------------------------------------------
/**
 * V[m[h}l[W
 */
class SceneNodeManager : public SceneObjectManagerTemplate<SceneNode>{
friend class Scene;
public:
	/**
	 * V[m[h̍쐬
	 *
	 * łɓV[m[h̃V[m[h݂ƃG[ɂȂ܂B
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param sceneNodeName V[m[h
	 * @return 쐬ꂽV[m[h
	 */
	virtual SceneNode* createSceneNode(const String& sceneNodeName);

	/**
	 * xIufBeB[V[m[h̍쐬
	 *
	 * łɓÕV[m[h݂ƃG[ɂȂ܂B
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param sceneNodeName xIufBeB[V[m[h
	 * @return 쐬ꂽxIufBeB[V[m[h
	 */
	virtual LODSceneNode* createLODSceneNode(const String& sceneNodeName);

	/**
	 * NA
	 * @return 폜IuWFNg
	 */
	virtual int clear();

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param scene V[
	 */
	SceneNodeManager(Scene* scene);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SCENE_NODE_MANAGER_H_
//------------------------------------------------------------------------------
