//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[m[hwb_
 * @author Junpee
 */

#ifndef SCENE_NODE_H_
#define SCENE_NODE_H_

#include <Graphics/Scene/SceneObject.h>
#include <Core/Primitive/Axis3.h>
#include <Core/Container/ArrayList.h>
#include <Graphics/Primitive/Visibility.h>

namespace Lamp{

class LODSceneNode;

//------------------------------------------------------------------------------
/**
 * V[m[h
 */
class SceneNode : public SceneObject{
friend class SceneObjectManagerTemplate<SceneNode>;
friend class SceneNodeManager;
friend class LODSceneNode;
public:
	/**
	 * t@XJEg̎擾
	 * @return t@XJEg
	 */
	virtual int getReferenceCount() const{
		if(parent_ != NULL){ return 1; }
		return 0;
	}

	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽV[m[h
	 */
	virtual SceneNode* copy(u_int copyMask = 0) const;

	/**
	 * ċAIj
	 * @param sceneNode jV[m[h
	 * @return jIuWFNg
	 */
	static int recursiveDestroy(SceneNode* sceneNode);

	/**
	 * q̍ċAIj
	 * @param sceneNode qjV[m[h
	 * @return jIuWFNg
	 */
	static int recursiveDestroyChildren(SceneNode* sceneNode);

	//--------------------------------------------------------------------------
	/**
	 * e̎擾
	 * @return e
	 */
	virtual SceneNode* getParent() const{ return parent_; }

	//--------------------------------------------------------------------------
	/**
	 * 
	 */
	virtual void traverse();

	//--------------------------------------------------------------------------
	/**
	 * [hs̎擾
	 * @return [hs
	 */
	const Matrix34& getWorldMatrix() const{ return worldMatrix_; }

	/**
	 * [Js̎擾
	 * @return [Js
	 */
	const Matrix34& getLocalMatrix() const{ return axis_.getMatrix(); }

	//--------------------------------------------------------------------------
	/**
	 * XP[̐ݒ
	 * @param scale XP[
	 */
	virtual void setScale(const Vector3& scale){ axis_.setScale(scale); }

	/**
	 * XP[̎擾
	 * @return XP[
	 */
	virtual const Vector3& getScale() const{ return axis_.getScale(); }

	/**
	 * XP[gpĂ邩
	 * @return XP[gpĂȂtrue
	 */
	virtual bool isScaled() const{ return axis_.isScaled(); }

	/**
	 * O[oŃXP[gpĂ邩
	 * @return O[oŃXP[gpĂȂtrue
	 */
	virtual bool isGlobalScaled() const{ return globalScaled_; }

	//--------------------------------------------------------------------------
	/**
	 * XYZ]̐ݒ
	 * @param rotation XYZ]
	 */
	virtual void setRotationXYZ(const Vector3& rotation){
		axis_.setRotationXYZ(rotation);
	}

	/**
	 * XYZ]̎擾
	 * @return XYZ]
	 */
	virtual const Vector3& getRotationXYZ(){
		return axis_.getRotationXYZ();
	}

	//--------------------------------------------------------------------------
	/**
	 * l]̐ݒ
	 * @param rotation l]
	 */
	virtual void setRotationQuaternion(const Quaternion& rotation){
		axis_.setRotationQuaternion(rotation);
	}

	/**
	 * l]̎擾
	 * @return l]
	 */
	virtual const Quaternion& getRotationQuaternion(){
		return axis_.getRotationQuaternion();
	}

	//--------------------------------------------------------------------------
	/**
	 * ړ̐ݒ
	 * @param translation ړ
	 */
	virtual void setTranslation(const Vector3& translation){
		axis_.setTranslation(translation);
	}

	/**
	 * ړ̎擾
	 * @return ړ
	 */
	virtual const Vector3& getTranslation() const{
		return axis_.getTranslation();
	}

	//--------------------------------------------------------------------------
	/**
	 * ύXtO̎擾
	 * @return ύXĂtrue
	 */
	virtual bool isChanged() const{ return axis_.isChanged(); }

	/**
	 * O[oł̕ύXtO̎擾
	 * @return O[oŕύXĂtrue
	 */
	virtual bool isGlobalChanged() const{ return globalChanged_; }

	//--------------------------------------------------------------------------
	/**
	 * LA̐ݒ
	 * @param enabled trueȂLAfalseȂ疳
	 */
	virtual void setEnabled(bool enabled){ enabled_ = enabled; }

	/**
	 * LA̎擾
	 * @return trueȂLAfalseȂ疳
	 */
	virtual bool isEnabled() const{ return enabled_; }

	/**
	 * O[oł̗LA̎擾
	 * @return trueȂLAfalseȂ疳
	 */
	virtual bool isGlobalEnabled() const{ return globalEnabled_; }

	//--------------------------------------------------------------------------
	// V[m[hC^[tF[X
	//--------------------------------------------------------------------------
	/**
	 * V[m[h̒ǉ
	 * @param sceneNode ǉV[m[h
	 */
	virtual void addSceneNode(SceneNode* sceneNode){
		sceneNode->setParent(this);
		sceneNodes_.add(sceneNode);
	}

	/**
	 * V[m[h̍폜
	 * @param sceneNode 폜V[m[h
	 */
	virtual void removeSceneNode(SceneNode* sceneNode){
		sceneNode->removeParent(this);
		sceneNodes_.removeByValue(sceneNode);
	}

	/**
	 * V[m[h̎擾
	 * @return V[m[h
	 */
	virtual int getSceneNodeCount() const{ return sceneNodes_.getCount(); }

	/**
	 * V[m[h̎擾
	 * @param index CfbNX
	 * @return V[m[h
	 */
	virtual SceneNode* getSceneNode(int index) const{
		Assert(index >= 0);
		Assert(index < getSceneNodeCount());
		return sceneNodes_.get(index);
	}

	//--------------------------------------------------------------------------
	// V[[tC^[tF[X
	//--------------------------------------------------------------------------
	/**
	 * V[[t̒ǉ
	 * @param sceneLeaf ǉV[[t
	 */
	virtual void addSceneLeaf(SceneLeaf* sceneLeaf);

	/**
	 * V[[t̍폜
	 * @param sceneLeaf 폜V[[t
	 */
	virtual void removeSceneLeaf(SceneLeaf* sceneLeaf);

	/**
	 * V[[t̎擾
	 * @return V[[t
	 */
	virtual int getSceneLeafCount() const{ return sceneLeafs_.getCount(); }

	/**
	 * V[[t̎擾
	 * @param index CfbNX
	 * @return V[[t
	 */
	virtual SceneLeaf* getSceneLeaf(int index) const{
		Assert(index >= 0);
		Assert(index < getSceneLeafCount());
		return sceneLeafs_.get(index);
	}

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * V[m[hǂ
	 * @return V[m[hȂtrue
	 */
	virtual bool isSceneNode() const{ return true; }

	//--------------------------------------------------------------------------
	/**
	 * xIufBeB[V[m[hǂ
	 * @return xIufBeB[V[m[hȂtrue
	 */
	virtual bool isLODSceneNode() const{ return false; }

	/**
	 * xIufBeB[V[m[hւ̃LXg
	 * @return xIufBeB[V[m[hB^ႦNULLԂB
	 */
	virtual LODSceneNode* castLODSceneNode() const{
		if(isLODSceneNode()){ return (LODSceneNode*)this; }
		return NULL;
	}

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	SceneNode(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~SceneNode();

	/**
	 * V[m[h̒lRs[
	 * @param destination Rs[V[m[h
	 * @param copyMask Rs[}XN
	 */
	virtual void copySceneNodeValue(
		SceneNode* destination, u_int copyMask) const;

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param parentMatrix es
	 * @param cameraPosition Jʒu
	 * @param parentEnabled eL
	 * @param parentScaled eXP[gpĂ邩
	 * @param parentChanged eɕύX
	 */
	virtual void traverse(const Matrix34& parentMatrix,
		const Vector3& cameraPosition, bool parentEnabled, bool parentScaled,
		bool parentChanged);

	/**
	 * švZ
	 * @param parentMatrix es
	 * @param parentChanged eɕύX
	 * @return ύXtrue
	 */
	virtual bool calcMatrix(const Matrix34& parentMatrix, bool parentChanged);

	/**
	 * O[oł̗LA̐ݒ
	 * @param globalEnabled trueȂLAfalseȂ疳
	 */
	virtual void setGlobalEnabled(bool globalEnabled){
		globalEnabled_ = globalEnabled;
	}

	/**
	 * O[oŃXP[gpĂ邩̐ݒ
	 * @param globalScaled O[oŃXP[gpĂȂtrue
	 */
	virtual void setGlobalScaled(bool globalScaled){
		globalScaled_ = globalScaled;
	}

	/**
	 * O[oł̕ύXtO̐ݒ
	 * @param globalChanged trueȂLAfalseȂ疳
	 */
	virtual void setGlobalChanged(bool globalChanged){
		globalChanged_ = globalChanged;
	}

	//--------------------------------------------------------------------------
	/**
	 * e̐ݒ
	 * @param parent ݒ肷e
	 */
	virtual void setParent(SceneNode* parent){
		Assert(parent != NULL);
		Assert(parent_ == NULL);
		parent_ = parent;
		setGlobalEnabled(true);
	}

	/**
	 * e̍폜
	 * @param parent 폜e
	 */
	virtual void removeParent(SceneNode* parent){
		Assert(parent_ != NULL);
		Assert(parent_ == parent);
		parent_ = NULL;
		setGlobalEnabled(true);
	}

private:
	//--------------------------------------------------------------------------
	// 
	Axis3 axis_;
	// [hs
	Matrix34 worldMatrix_;
	// V[m[hz
	ArrayList<SceneNode*> sceneNodes_;
	// V[[tz
	ArrayList<SceneLeaf*> sceneLeafs_;
	// e
	SceneNode* parent_;
	// LAtO
	bool enabled_;
	// O[oł̗LtO
	bool globalEnabled_;
	// O[oł̃XP[tO
	bool globalScaled_;
	// O[oł̕ύXtO
	bool globalChanged_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SCENE_NODE_H_
//------------------------------------------------------------------------------
