//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[[twb_
 * @author Junpee
 */

#ifndef SCENE_LEAF_H_
#define SCENE_LEAF_H_

#include <Graphics/Scene/SceneObject.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * V[[t
 */
class SceneLeaf : public SceneObject{
friend class SceneNode;
friend class LODSceneNode;
public:
	//--------------------------------------------------------------------------
	/**
	 * e̎擾
	 * @return e
	 */
	virtual SceneNode* getParent() const{ return parent_; }

	/**
	 * t@XJEg̎擾
	 * @return t@XJEg
	 */
	virtual int getReferenceCount() const{
		if(parent_ != NULL){ return 1; }
		return 0;
	}

	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽV[[t
	 */
	virtual SceneLeaf* copy(u_int copyMask = 0) const = 0;

	/**
	 * ċAIj
	 * @param leaf jV[[t
	 * @return jIuWFNg
	 */
	static int recursiveDestroy(SceneLeaf* leaf);

	//--------------------------------------------------------------------------
	// LA
	//--------------------------------------------------------------------------
	/**
	 * LA̐ݒ
	 * @param enabled trueȂLAfalseȂ疳
	 */
	virtual void setEnabled(bool enabled){ enabled_ = enabled; }

	/**
	 * LA̎擾
	 * @return trueȂLAfalseȂ疳
	 */
	virtual bool isEnabled() const{ return enabled_; }

	/**
	 * O[oł̗LA̎擾
	 * @return trueȂLAfalseȂ疳
	 */
	virtual bool isGlobalEnabled() const{ return globalEnabled_; }

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * V[[tǂ
	 * @return V[[tȂtrue
	 */
	virtual bool isSceneLeaf() const{ return true; }

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	SceneLeaf(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~SceneLeaf();

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param parentMatrix es
	 * @param parentEnabled eL
	 * @param parentScaled eXP[gpĂ邩
	 * @param parentChanged eɕύX
	 */
	virtual void traverse(const Matrix34& parentMatrix, bool parentEnabled,
		bool parentScaled, bool parentChanged);

	//--------------------------------------------------------------------------
	/**
	 * e̐ݒ
	 * @param parent ݒ肷e
	 */
	virtual void setParent(SceneNode* parent){
		Assert(parent != NULL);
		Assert(parent_ == NULL);
		parent_ = parent;
		globalEnabled_ = false;
	}

	/**
	 * e̍폜
	 * @param parent 폜e
	 */
	virtual void removeParent(SceneNode* parent){
		Assert(parent_ != NULL);
		Assert(parent_ == parent);
		parent_ = NULL;
		globalEnabled_ = false;
	}

	/**
	 * V[[t̒lRs[
	 * @param destination Rs[V[[t
	 */
	virtual void copySceneLeafValue(SceneLeaf* destination) const;

private:
	//--------------------------------------------------------------------------
	// e
	SceneNode* parent_;
	// LAtO
	bool enabled_;
	// O[oł̗LtO
	bool globalEnabled_;


};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SCENE_LEAF_H_
//------------------------------------------------------------------------------
