//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * xIufBeB[V[m[hwb_
 * @author Junpee
 */

#ifndef LOD_SCENE_NODE_H_
#define LOD_SCENE_NODE_H_

#include <Graphics/SceneNode/SceneNode.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * xIufBeB[V[m[h
 */
class LODSceneNode : public SceneNode{
friend class SceneObjectManagerTemplate<SceneNode>;
friend class SceneNodeManager;
public:
	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽV[m[h
	 */
	virtual SceneNode* copy(u_int copyMask = 0) const{
		return copyLODSceneNode(copyMask);
	}

	//--------------------------------------------------------------------------
	/**
	 * xIufBeB[V[m[hRs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽxIufBeB[V[m[h
	 */
	virtual LODSceneNode* copyLODSceneNode(u_int copyMask = 0) const;

	//--------------------------------------------------------------------------
	// LOD
	//--------------------------------------------------------------------------
	/**
	 * LOD̐ݒ
	 * @param lodThresholdCount LOD
	 */
	virtual void setLODThresholdCount(int lodThresholdCount){
		Assert(lodThresholdCount >= 0);
		lodThresholdCount_ = lodThresholdCount;
		SafeArrayDelete(lodThreshold_);
		if(lodThresholdCount_ > 0){
			lodThreshold_ = new float[lodThresholdCount_];
			for(int i = 0; i < lodThresholdCount_; i++){
				lodThreshold_[i] = 0.f;
			}
		}
	}

	/**
	 * LOD̎擾
	 * @return LOD
	 */
	virtual int getLODThresholdCount() const{ return lodThresholdCount_; }

	//--------------------------------------------------------------------------
	/**
	 * LODl̐ݒ
	 * @param index CfbNX
	 * @param lodThreshold LODl
	 */
	virtual void setLODThreshold(int index, float lodThreshold){
		Assert(index >= 0);
		Assert(index < lodThresholdCount_);
		lodThreshold_[index] = lodThreshold;
	}

	/**
	 * LODl̎擾
	 * @param index CfbNX
	 * @return LODl
	 */
	virtual float getLODThreshold(int index) const{
		Assert(index >= 0);
		Assert(index < lodThresholdCount_);
		return lodThreshold_[index];
	}

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * xIufBeB[V[m[hǂ
	 * @return xIufBeB[V[m[hȂtrue
	 */
	virtual bool isLODSceneNode() const{ return true; }

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	LODSceneNode(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~LODSceneNode();

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param parentMatrix es
	 * @param cameraPosition Jʒu
	 * @param parentEnabled eL
	 * @param parentScaled eXP[gpĂ邩
	 * @param parentChanged eɕύX
	 */
	virtual void traverse(const Matrix34& parentMatrix,
		const Vector3& cameraPosition, bool parentEnabled, bool parentScaled,
		bool parentChanged);

private:
	//--------------------------------------------------------------------------
	// LOD
	int lodThresholdCount_;
	// LODl
	float* lodThreshold_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of LOD_SCENE_NODE_H_
//------------------------------------------------------------------------------
