//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[_`FbNtB^wb_
 * @author Junpee
 */

#ifndef SCENE_LOGIC_CHECK_FILTER_H_
#define SCENE_LOGIC_CHECK_FILTER_H_

#include <Graphics/SceneFilter/SceneFilterInterface.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * V[_`FbNtB^
 *
 * "SceneLogicCheck"<br>
 * V[Ɉُ킪Ȃ`FbNB
 */
class SceneLogicCheckFilter : public SceneFilterInterface{
friend class SceneFilter;
protected:
	/**
	 * RXgN^
	 * @param scene tB^V[
	 */
	SceneLogicCheckFilter(Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~SceneLogicCheckFilter();

	/**
	 * tB^
	 * @param command R}h
	 * @return true
	 */
	virtual bool filter(const String& command);

	/// V[̃tB^
	virtual bool filterScene();

	/// V[m[h̃tB^
	virtual bool filterSceneNode();

	/// f̃tB^
	virtual bool filterModel();

	/// bṼtB^
	virtual bool filterMesh();

	/// bVf[^̃tB^
	virtual bool filterMeshData();

	/// }eÃtB^
	virtual bool filterMaterial();

	/// eNX`̃tB^
	virtual bool filterTexture();

	/// sN`̃tB^
	virtual bool filterPicture();

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SCENE_LOGIC_CHECK_FILTER_H_
//------------------------------------------------------------------------------
