//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[tB^wb_
 * @author Junpee
 */

#ifndef SCENE_FILTER_H_
#define SCENE_FILTER_H_

namespace Lamp{

class Scene;
class TextReader;

//------------------------------------------------------------------------------
/**
 * V[tB^
 *
 * V[_`FbNtB^<br>
 * "SceneLogicCheck"<br>
 * V[Ɉُ킪Ȃ`FbNB<br>
 * <br>
 * sN`pXύXtB^<br>
 * "ChangePicturePath newPath"<br>
 * newPathɐݒ肵sN`΃pX͂B<br>
 */
class SceneFilter{
public:
	/**
	 * RXgN^
	 */
	SceneFilter(Scene* scene = NULL);

	/**
	 * fXgN^
	 */
	virtual ~SceneFilter();

	/**
	 * tB^
	 * @param command tB^
	 * @return true
	 */
	virtual bool filter(const String& command);

	/**
	 * tB^
	 * @param reader eLXg[_
	 * @return true
	 */
	virtual bool filter(TextReader* reader);

	/**
	 * V[̐ݒ
	 */
	virtual void setScene(Scene* scene){ scene_ = scene; }

private:
	// Rs[RXgN^̉B
	SceneFilter(const SceneFilter& copy);

	// Rs[̉B
	void operator =(const SceneFilter& copy);

	// V[
	Scene* scene_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SCENE_FILTER_H_
//------------------------------------------------------------------------------
