//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * oEfBOXtBAvZtB^wb_
 * @author Junpee
 */

#ifndef CALCULATE_BOUNDING_SPHERE_FILTER_H_
#define CALCULATE_BOUNDING_SPHERE_FILTER_H_

#include <Graphics/SceneFilter/SceneFilterInterface.h>

namespace Lamp{

class Mesh;

//------------------------------------------------------------------------------
/**
 * oEfBOXtBAvZtB^
 *
 * "CalculateBoundingSphere"<br>
 * oEfBOXtBAvZB<br>
 * LN^XP[IvV<br>
 * characterScale (float)
 */
// Kvł΃LN^ItZbgɑΉ
class CalculateBoundingSphereFilter : public SceneFilterInterface{
friend class SceneFilter;
protected:
	/**
	 * RXgN^
	 * @param scene tB^V[
	 */
	CalculateBoundingSphereFilter(Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~CalculateBoundingSphereFilter();

	/**
	 * tB^
	 * @param command R}h
	 * @return true
	 */
	virtual bool filter(const String& command);

	/// V[̃tB^
	virtual bool filterScene();

	/// bṼtB^
	virtual bool filterMesh();

	/// bṼtB^
	virtual bool filterMesh(Mesh* mesh);

	/// LN^XP[
	float characterScale_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of CALCULATE_BOUNDING_SPHERE_FILTER_H_
//------------------------------------------------------------------------------
