//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * CfbNXgCAO\ztB^wb_
 * @author Junpee
 */

#ifndef BUILD_INDEXED_TRIANGLE_FILTER_H_
#define BUILD_INDEXED_TRIANGLE_FILTER_H_

#include <Graphics/SceneFilter/SceneFilterInterface.h>

namespace Lamp{

class MeshData;

//------------------------------------------------------------------------------
/**
 * CfbNXgCAO\ztB^
 *
 * "BuildIndexedTriangle"<br>
 * CfbNXgCAO\zB<br>
 */
class BuildIndexedTriangleFilter : public SceneFilterInterface{
friend class SceneFilter;
public:
	/// őCfbNX
	static const int maxIndex = 65536;

protected:
	/**
	 * RXgN^
	 * @param scene tB^V[
	 */
	BuildIndexedTriangleFilter(Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~BuildIndexedTriangleFilter();

	/**
	 * tB^
	 * @param command R}h
	 * @return true
	 */
	virtual bool filter(const String& command);

	/// V[̃tB^
	virtual bool filterScene();

	/// bVf[^̃tB^
	virtual bool filterMeshData();


	/// bVf[^̃tB^
	virtual bool filterMeshData(MeshData* meshData);

	//--------------------------------------------------------------------------
	/// NA
	virtual void clear();

	/// CfbNXgCAO̍\z
	virtual bool buildIndexedTriangle();

	/// łɒ_T
	virtual int findIndex(int source);

	/// obt@̃AP[g
	virtual void allocateBuffer();

	/// obt@̉
	virtual void freeBuffer();

	//--------------------------------------------------------------------------
	/// _f[^
	int sourceVertexCount_;
	/// ʒuf[^
	const Vector3* sourcePosition_;
	/// @f[^
	const Vector3* sourceNormal_;
	/// _J[f[^
	const Color4c* sourceColor_;
	/// eNX`Wf[^
	const float* const* sourceTexCoord_;
	/// {[CfbNXf[^
	const u_char* sourceBoneIndex_;
	/// EFCgf[^
	const float* sourceWeight_;
	/// _
	int vertexCount_;
	/// eNX`WZbg
	int texCoordSetCount_;
	/// eNX`W^Cvz
	const TexCoord::Type* texCoordTypeArray_;
	/// _{[
	int bonesPerVertex_;
	/// _EFCg
	int weightsPerVertex_;
	/// ʒu
	Vector3* positions_;
	/// @
	Vector3* normals_;
	/// F
	Color4c* colors_;
	/// eNX`W
	float* texCoords_[TexCoord::maxSetCount];
	/// {[CfbNX
	u_char* boneIndices_;
	/// EFCg
	float* weights_;
	/// CfbNX
	u_short* indices_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of BUILD_INDEXED_TRIANGLE_FILTER_H_
//------------------------------------------------------------------------------
