//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[IuWFNg}l[Wev[gwb_
 * @author Junpee
 */

#ifndef SCENE_OBJECT_MANAGER_TEMPLATE_H_
#define SCENE_OBJECT_MANAGER_TEMPLATE_H_

#include <Graphics/Scene/Scene.h>
#include <Core/Renamer/Renamer.h>
#include <Core/Container/HashMap.h>
#include <Core/Container/ArrayList.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * V[IuWFNg}l[Wev[g
 */
template <typename Type>
class SceneObjectManagerTemplate : public Renamer::Database{
friend class Scene;
public:
	/**
	 * IuWFNg̔j
	 * @param object jIuWFNg
	 * @return jIuWFNg̃t@XJE^B0ȂjĂ
	 */
	virtual int destroy(Type* object){
		// QƂcĂ΍폜Ȃ
		int referenceCount = object->getReferenceCount();
		Assert(referenceCount >= 0);
		if(referenceCount != 0){ return referenceCount; }
		// f[^x[X猟č폜
		if(array_.removeByValue(object) == -1){
			ErrorOut("SceneObjectManagerTemplate::destroy() "
				"Not found object in array");
		}
		if(database_.remove(object->getName()) == NULL){
			ErrorOut("SceneObjectManagerTemplate::destroy() "
				"Not found object in hashmap");
		}
		delete object;
		return 0;
	}

	//--------------------------------------------------------------------------
	/**
	 * V[̎擾
	 * @return V[
	 */
	virtual Scene* getScene() const{ return scene_; }

	//--------------------------------------------------------------------------
	/**
	 * IuWFNg̎擾
	 * @return IuWFNg
	 */
	virtual int getCount(){ return array_.getCount(); }

	/**
	 * IuWFNg̎擾
	 * @param index IuWFNg̃CfNX
	 * @return IuWFNg
	 */
	virtual Type* get(int index){ return array_.get(index); }

	/**
	 * IuWFNǧ
	 * @param name IuWFNg
	 * @return IuWFNg
	 */
	virtual Type* search(const String& name){ return database_.get(name); }

	//--------------------------------------------------------------------------
	// l[֌W
	//--------------------------------------------------------------------------
	/**
	 * O݂邩ǂ
	 * @param name ݂邩ǂׂ閼O
	 * @return O݂true
	 */
	virtual bool existName(const String& name){ return (search(name) != NULL); }

	/**
	 * l[
	 * @param sourceName ƂȂ閼O
	 * @return dĂȂO
	 */
	virtual String rename(const String& sourceName){
		return scene_->getRenamer()->rename(this, sourceName);
	}

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param scene V[
	 */
	SceneObjectManagerTemplate(Scene* scene) :
		 database_(256, 0.75f), array_(256), scene_(scene){
	}

	/**
	 * fXgN^
	 */
	virtual ~SceneObjectManagerTemplate(){
		Assert(database_.getCount() == 0);
		Assert(array_.getCount() == 0);
		if(getCount() != 0){ clear(); }
	}

	/**
	 * Õ`FbN
	 * @param name `FbN閼O
	 * @return ȖOȂtrueԂ
	 */
	bool checkName(String name){
		// O̒`FbN
		if(name.getSize() == 0){
			ErrorOut("SceneObjectManager::checkName() name.getSize() == 0");
			return false;
		}
		// Ȍd`FbN
		if(existName(name)){
			ErrorOut("SceneObjectManager::checkName() repetition name %s",
				name.getBytes());
			return false;
		}
		return true;
	}

	/**
	 * f[^x[Xւ̒ǉ
	 * @param name O
	 * @param object IuWFNg
	 */
	virtual void addDatabase(const String& name, Type* object){
		database_.put(name, object);
		array_.add(object);
	}

	/**
	 * NA
	 * @return 폜IuWFNg
	 */
	virtual int clear(){
		int result = getCount();
		// vf̍폜
		for(int i = 0; i < result; i++){ delete array_.get(i); }
		array_.clear();
		database_.clear();
		return result;
	}

	//--------------------------------------------------------------------------
	/// f[^x[X
	HashMap<String, Type*> database_;
	/// z
	ArrayList<Type*> array_;
	/// V[
	Scene* scene_;

	//--------------------------------------------------------------------------
private:
	// Rs[RXgN^̉B
	SceneObjectManagerTemplate(const SceneObjectManagerTemplate& copy);

	// Rs[̉B
	void operator =(const SceneObjectManagerTemplate& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SCENE_OBJECT_MANAGER_TEMPLATE_H_
//------------------------------------------------------------------------------
