//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[IuWFNgwb_
 * @author Junpee
 */

#ifndef SCENE_OBJECT_H_
#define SCENE_OBJECT_H_

#include <Graphics/Scene/SceneObjectManagerTemplate.h>

namespace Lamp{

class Scene;
class Camera;
class SceneNode;
class SceneLeaf;
class Light;
class Model;
class Mesh;
class MeshData;
class Material;
class Texture;
class Picture;

//------------------------------------------------------------------------------
/**
 * V[IuWFNg
 */
class SceneObject{
public:
	//--------------------------------------------------------------------------
	/**
	 * t@XJEg̎擾
	 * @return t@XJEg
	 */
	virtual int getReferenceCount() const = 0;

	//--------------------------------------------------------------------------
	/**
	 * O̎擾
	 * @return O
	 */
	virtual const String& getName() const{ return name_; }

	//--------------------------------------------------------------------------
	/**
	 * V[̎擾
	 * @return V[
	 */
	virtual Scene* getScene() const{ return scene_; }

	//--------------------------------------------------------------------------
	/// Rs[}XN
	enum CopyMask{
		/// bVf[^Rs[
		copyMeshData	= 0x1 << 0,
		/// }eARs[
		copyMaterial	= 0x1 << 1,
		/// eNX`Rs[
		copyTexture		= 0x1 << 2,
		/// sN`Rs[
		copyPicture		= 0x1 << 3,
	};

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * Jǂ
	 * @return JȂtrue
	 */
	virtual bool isCamera() const{ return false; }

	/**
	 * Jւ̃LXg
	 * @return JB^ႦNULLԂB
	 */
	virtual Camera* castCamera() const{
		if(isCamera()){ return (Camera*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * V[m[hǂ
	 * @return V[m[hȂtrue
	 */
	virtual bool isSceneNode() const{ return false; }

	/**
	 * V[m[hւ̃LXg
	 * @return V[m[hB^ႦNULLԂB
	 */
	virtual SceneNode* castSceneNode() const{
		if(isSceneNode()){ return (SceneNode*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * V[[tǂ
	 * @return V[[tȂtrue
	 */
	virtual bool isSceneLeaf() const{ return false; }

	/**
	 * V[[tւ̃LXg
	 * @return V[[tB^ႦNULLԂB
	 */
	virtual SceneLeaf* castSceneLeaf() const{
		if(isSceneLeaf()){ return (SceneLeaf*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * Cgǂ
	 * @return CgȂtrue
	 */
	virtual bool isLight() const{ return false; }

	/**
	 * Cgւ̃LXg
	 * @return CgB^ႦNULLԂB
	 */
	virtual Light* castLight() const{
		if(isLight()){ return (Light*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * fǂ
	 * @return fȂtrue
	 */
	virtual bool isModel() const{ return false; }

	/**
	 * fւ̃LXg
	 * @return fB^ႦNULLԂB
	 */
	virtual Model* castModel() const{
		if(isModel()){ return (Model*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * bVǂ
	 * @return bVȂtrue
	 */
	virtual bool isMesh() const{ return false; }

	/**
	 * bVւ̃LXg
	 * @return bVB^ႦNULLԂB
	 */
	virtual Mesh* castMesh() const{
		if(isMesh()){ return (Mesh*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * bVf[^ǂ
	 * @return bVf[^Ȃtrue
	 */
	virtual bool isMeshData() const{ return false; }

	/**
	 * bVf[^ւ̃LXg
	 * @return bVf[^B^ႦNULLԂB
	 */
	virtual MeshData* castMeshData() const{
		if(isMeshData()){ return (MeshData*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * }eAǂ
	 * @return }eAȂtrue
	 */
	virtual bool isMaterial() const{ return false; }

	/**
	 * VF[_ւ̃LXg
	 * @return VF[_B^ႦNULLԂB
	 */
	virtual Material* castMaterial() const{
		if(isMaterial()){ return (Material*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * eNX`ǂ
	 * @return eNX`Ȃtrue
	 */
	virtual bool isTexture() const{ return false; }

	/**
	 * eNX`ւ̃LXg
	 * @return eNX`B^ႦNULLԂB
	 */
	virtual Texture* castTexture() const{
		if(isTexture()){ return (Texture*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * sN`ǂ
	 * @return sN`Ȃtrue
	 */
	virtual bool isPicture() const{ return false; }

	/**
	 * sN`ւ̃LXg
	 * @return sN`B^ႦNULLԂB
	 */
	virtual Picture* castPicture() const{
		if(isPicture()){ return (Picture*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	SceneObject(const String& name, Scene* scene) :
		 name_(name), scene_(scene){}

	/**
	 * fXgN^
	 */
	virtual ~SceneObject(){}

	/// O
	String name_;
	/// V[
	Scene* scene_;

private:
	// Rs[RXgN^̉B
	SceneObject(const SceneObject& copy);

	// Rs[̉B
	void operator =(const SceneObject& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SCENE_OBJECT_H_
//------------------------------------------------------------------------------

