//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[wb_
 * @author Junpee
 */

#ifndef SCENE_H_
#define SCENE_H_

#include <Graphics/System/GraphicsDeviceObjectHolder.h>
#include <Core/Container/ArrayList.h>

namespace Lamp{

class Renamer;
class DrawRequest;
class SceneNode;
class Camera;
class Fog;
class Mesh;

class CameraManager;
class SceneNodeManager;
class LightManager;
class ModelManager;
class MeshManager;
class MeshDataManager;
class MaterialManager;
class TextureManager;
class PictureManager;

//------------------------------------------------------------------------------
/**
 * V[
 */
class Scene : public GraphicsDeviceObjectHolder{
friend class LampGraphics;
public:
	/**
	 * NA
	 *
	 * IɃV[̑SIuWFNgj܂
	 * @return 폜IuWFNg
	 */
	virtual int clear();

	//--------------------------------------------------------------------------
	/**
	 * 
	 */
	virtual void traverse();

	//--------------------------------------------------------------------------
	/**
	 * bVXg̎擾
	 * @param meshList bVXg
	 * @param camera 荞ރJ
	 */
	virtual void getMeshList(ArrayList<Mesh*>* meshList, Camera* camera);

	/**
	 * [JCgXg̎擾
	 * @param mesh bV
	 * @param drawRequest `惊NGXg
	 */
	virtual void getLocalLightList(Mesh* mesh, DrawRequest* drawRequest);

	//--------------------------------------------------------------------------
	/**
	 * O̎擾
	 * @return O
	 */
	virtual const String& getName() const{ return name_; }

	//--------------------------------------------------------------------------
	/**
	 * [gm[h̎擾
	 * @return [gm[h
	 */
	virtual SceneNode* getRootNode(){ return rootNode_; }

	//--------------------------------------------------------------------------
	/**
	 * JgJ̐ݒ
	 * @param currentCamera JgJ
	 */
	virtual void setCurrentCamera(Camera* currentCamera){
		currentCamera_ = currentCamera;
	}

	/**
	 * JgJ̎擾
	 * @return JgJ
	 */
	virtual Camera* getCurrentCamera(){ return currentCamera_; }

	//--------------------------------------------------------------------------
	/**
	 * tHO̎擾
	 * @return tHO
	 */
	virtual Fog* getFog(){ return fog_; }

	//--------------------------------------------------------------------------
	/**
	 * `bN̐ݒ
	 * @param tick `bN
	 */
	virtual void setTick(int tick){ tick_ = tick; }

	/**
	 * `bN̎擾
	 * @return `bN
	 */
	virtual int getTick() const{ return tick_; }

	//--------------------------------------------------------------------------
	// l[֌W
	//--------------------------------------------------------------------------
	/**
	 * l[}̐ݒ
	 * @param renamer ݒ肷郊l[}
	 */
	virtual void setRenamer(Renamer* renamer);

	/**
	 * l[}̎擾
	 * @return l[}
	 */
	virtual Renamer* getRenamer() const{ return renamer_; }

	//--------------------------------------------------------------------------
	/**
	 * foCXIuWFNg̏
	 * @return trueԂ
	 */
	virtual bool initializeGraphicsDeviceObjects();

	/**
	 * foCXIuWFNg̍폜
	 */
	virtual void deleteGraphicsDeviceObjects();

	/**
	 * foCXIuWFNg̃XgA
	 * @return trueԂ
	 */
	virtual bool restoreGraphicsDeviceObjects();

	/**
	 * foCXIuWFNg̖
	 */
	virtual void invalidateGraphicsDeviceObjects();

	//--------------------------------------------------------------------------
	/**
	 * J}l[W̎擾
	 * @return J}l[W
	 */
	virtual CameraManager* getCameraManager(){ return cameraManager_; }

	/**
	 * V[m[h}l[W̎擾
	 * @return V[m[h}l[W
	 */
	virtual SceneNodeManager* getSceneNodeManager(){
		return	sceneNodeManager_;
	}

	/**
	 * Cg}l[W̎擾
	 * @return Cg}l[W
	 */
	virtual LightManager* getLightManager(){ return lightManager_; }

	/**
	 * f}l[W̎擾
	 * @return f}l[W
	 */
	virtual ModelManager* getModelManager(){ return modelManager_; }

	/**
	 * bV}l[W̎擾
	 * @return bV}l[W
	 */
	virtual MeshManager* getMeshManager(){ return meshManager_; }

	/**
	 * bVf[^}l[W̎擾
	 * @return bVf[^}l[W
	 */
	virtual MeshDataManager* getMeshDataManager(){ return meshDataManager_; }

	/**
	 * }eA}l[W̎擾
	 * @return }eA}l[W
	 */
	virtual MaterialManager* getMaterialManager(){ return materialManager_; }

	/**
	 * eNX`}l[W̎擾
	 * @return eNX`}l[W
	 */
	virtual TextureManager* getTextureManager(){ return textureManager_; }

	/**
	 * sN`}l[W̎擾
	 * @return sN`}l[W
	 */
	virtual PictureManager* getPictureManager(){ return pictureManager_; }

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 */
	Scene(const String& name);

	/**
	 * fXgN^
	 */
	virtual ~Scene();

	//--------------------------------------------------------------------------
private:
	// Rs[RXgN^̉B
	Scene(const Scene& copy);

	// Rs[̉B
	void operator =(const Scene& copy);

	// O
	String name_;
	// l[}
	Renamer* renamer_;
	// [gm[h
	SceneNode* rootNode_;
	// JgJ
	Camera* currentCamera_;
	// tHO
	Fog* fog_;
	// J}l[W
	CameraManager* cameraManager_;
	// V[m[h}l[W
	SceneNodeManager* sceneNodeManager_;
	// Cg}l[W
	LightManager* lightManager_;
	// f}l[W
	ModelManager* modelManager_;
	// bV}l[W
	MeshManager* meshManager_;
	// bVf[^}l[W
	MeshDataManager* meshDataManager_;
	// }eA}l[W
	MaterialManager* materialManager_;
	// eNX`}l[W
	TextureManager* textureManager_;
	// sN`}l[W
	PictureManager* pictureManager_;
	// `bN
	int tick_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SCENE_H_
//------------------------------------------------------------------------------
