//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * _OfoCXwb_
 * @author Junpee
 */

#ifndef RENDERING_DEVICE_H_
#define RENDERING_DEVICE_H_

namespace Lamp{

class GraphicsDeviceCapacity;
class Fog;
class DirectionalLight;
class PointLight;
class Texture;

//------------------------------------------------------------------------------
/**
 * _OfoCX
 */
class RenderingDevice{
friend class LampGraphics;
public:
	/// őANeBuCg
	static const int maxActiveLightCount_;

	//--------------------------------------------------------------------------
	/**
	 * CX^X擾
	 * @return CX^X
	 */
	static RenderingDevice* getInstance(){
		Assert(instance_ != NULL);
		return instance_;
	}

	//--------------------------------------------------------------------------
	// Xe[gݒ
	//--------------------------------------------------------------------------
	/**
	 * _[Xe[g̐ݒ
	 * @param type _[Xe[g^Cv
	 * @param state _[Xe[g
	 */
	virtual void setRenderState(D3DRENDERSTATETYPE type, u_int state);

	/**
	 * eNX`Xe[g̐ݒ
	 * @param stage Xe[W
	 * @param type eNX`Xe[g^Cv
	 * @param state eNX`Xe[g
	 */
	virtual void setTextureState(
		u_int stage, D3DTEXTURESTAGESTATETYPE type, u_int state);

	/**
	 * TvXe[g̐ݒ
	 * @param stage Xe[W
	 * @param type TvXe[g^Cv
	 * @param state TvXe[g
	 */
	virtual void setSamplerState(
		u_int stage, D3DSAMPLERSTATETYPE type, u_int state);

	//--------------------------------------------------------------------------
	// Xe[gubN֘A
	//--------------------------------------------------------------------------
	/**
	 * Xe[gubN̊Jn
	 */
	virtual void beginStateBlock();

	/**
	 * Xe[gubN̏I
	 * @return Xe[gubN
	 */
	virtual Direct3DStateBlock* endStateBlock();

	/**
	 * Xe[gubN̓Kp
	 * @param stateBlock Xe[gubN
	 */
	virtual void applyStateBlock(Direct3DStateBlock* stateBlock);

	/**
	 * ftHgXe[gubN̓Kp
	 */
	virtual void applyDefaultStateBlock(){
		applyStateBlock(defaultStateBlock_);
	}

	//--------------------------------------------------------------------------
	// _[^[Qbg
	//--------------------------------------------------------------------------
	/**
	 * _[^[QbgTCY̎擾
	 * @return _[^[QbgTCY
	 */
	virtual DimensionI getRenderTargetSize();

	//--------------------------------------------------------------------------
	// V[֘A
	//--------------------------------------------------------------------------
	/**
	 * V[̊Jn
	 * @return trueԂ
	 */
	virtual bool beginScene();

	/**
	 * V[̏I
	 */
	virtual void endScene();

	//--------------------------------------------------------------------------
	// s֘A
	//--------------------------------------------------------------------------
	/**
	 * es̐ݒ
	 * @param projectionMatrix es
	 */
	virtual void setProjectionMatrix(const Matrix44& projectionMatrix);

	/**
	 * r[s̐ݒ
	 * @param viewMatrix r[s
	 */
	virtual void setViewMatrix(const Matrix44& viewMatrix);

	/**
	 * [hs̐ݒ
	 * @param worldMatrix [hs
	 */
	virtual void setWorldMatrix(const Matrix34& worldMatrix);

	/**
	 * eNX`gXtH[ݒ
	 * @param stage eNX`Xe[W
	 * @param repeat s[g
	 * @param offset ItZbg
	 */
	virtual void setTextureTransform2(u_int stage,
		const TexCoord2& repeat, const TexCoord2& offset);

	//--------------------------------------------------------------------------
	// r[|[g
	//--------------------------------------------------------------------------
	/**
	 * r[|[g̐ݒ
	 * @param rectangle `
	 */
	virtual void setViewport(const RectangleI& rectangle);

	/**
	 * r[|[g̃Zbg
	 */
	virtual void resetViewport();

	//--------------------------------------------------------------------------
	// CeBO֘A
	//--------------------------------------------------------------------------
	/**
	 * CeBO̐ݒ
	 * @param lighting CeBOsȂtrue
	 */
	virtual void setLighting(bool lighting);

	/**
	 * ArGgJ[̐ݒ
	 * @param ambientColor ArGgJ[
	 */
	virtual void setAmbientColor(const Color3f& ambientColor);

	/**
	 * fBNViCgLɂ
	 * @param lightIndex CgCfbNX
	 * @param directionalLight fBNViCg
	 */
	virtual void enableDirectionalLight(
		int lightIndex, DirectionalLight* directionalLight);

	/**
	 * |CgCgLɂ
	 * @param lightIndex CgCfbNX
	 * @param pointLight |CgCg
	 */
	virtual void enablePointLight(int lightIndex, PointLight* pointLight);

	/**
	 * Cg
	 * @param lightIndex CgCfbNX
	 */
	virtual void closeLight(int lightIndex);

	//--------------------------------------------------------------------------
	// }eA֘A
	//--------------------------------------------------------------------------
	/**
	 * }eA̐ݒ
	 * @param diffuseColor fBt[YJ[
	 * @param specularColor XyLJ[
	 * @param ambientColor ArGgJ[
	 * @param emissiveColor G~bVuJ[
	 * @param specularPower XyLp[
	 * @param alpha At@
	 */
	virtual void setMaterial(
		const Color3f& diffuseColor, const Color3f& specularColor,
		const Color3f& ambientColor, const Color3f& emissiveColor,
		float specularPower, float alpha);

	//--------------------------------------------------------------------------
	/**
	 * ufBO̐ݒ
	 * @param blendingFlag ufBOtO
	 */
	virtual void setBlending(bool blendingFlag);

	/**
	 * uh[h̐ݒ
	 * @param mode uh[h
	 * @param source uh\[X
	 * @param destination uhfXeBl[V
	 */
	virtual void setBlendMode(int mode, int source, int destination);

	//--------------------------------------------------------------------------
	// eNX`֘A
	//--------------------------------------------------------------------------
	/**
	 * eNX`̐ݒ
	 * @param textureStage eNX`Xe[W
	 * @param texture eNX`
	 */
	virtual void setTexture(int textureStage, Texture* texture);

	/**
	 * eNX`̐ݒ
	 * @param textureStage eNX`Xe[W
	 * @param texture Direct3DeNX`
	 */
	virtual void setTexture(int textureStage, Direct3DTexture* texture);

	/**
	 * eNX`AhX[h̐ݒ
	 * @param textureStage eNX`Xe[W
	 * @param addressModeU AhX[hU
	 * @param addressModeV AhX[hV
	 */
	virtual void setTextureAddressMode2(int textureStage,
		int addressModeU, int addressModeV);

	/**
	 * eNX`̍쐬
	 * @param format tH[}bg
	 * @param width 
	 * @param height 
	 * @return eNX`
	 */
	virtual Direct3DTexture* createTexture(
		D3DFORMAT format, int width, int height);

	/**
	 * eNX`̃bN
	 * @param texture eNX`
	 * @param mipmapLevel ~bv}bvx
	 * @return bNꂽ`
	 */
	virtual D3DLOCKED_RECT lockTexture(
		Direct3DTexture* texture, int mipmapLevel);

	/**
	 * eNX`̃AbN
	 * @param texture eNX`
	 * @param mipmapLevel ~bv}bvx
	 */
	virtual void unlockTexture(Direct3DTexture* texture, int mipmapLevel);

	//--------------------------------------------------------------------------
	// eNX`Xe[W֘A
	//--------------------------------------------------------------------------
	/**
	 * J[eNX`Xe[Wݒ
	 * @param colorStage J[Xe[W
	 * @param operation Xe[W̑
	 * @param arg1 
	 * @param arg2 
	 * @param uvIndex UVCfbNX
	 */
	virtual void setColorTextureStage(int colorStage,
		D3DTEXTUREOP operation, u_int arg1, u_int arg2, int uvIndex);

	/**
	 * J[eNX`Xe[W
	 * @param colorStage J[Xe[W
	 */
	virtual void closeColorTextureStage(int colorStage);

	/**
	 * At@eNX`Xe[Wݒ
	 * @param alphaTextureStage At@eNX`Xe[W
	 */
	virtual void setAlphaTextureStage(int alphaTextureStage);

	//--------------------------------------------------------------------------
	// tHO
	//--------------------------------------------------------------------------
	/**
	 * tHO̐ݒ
	 * @param fog tHO
	 */
	virtual void setFog(Fog* fog);

	//--------------------------------------------------------------------------
	// ZeXg
	//--------------------------------------------------------------------------
	/**
	 * ZeXg̐ݒ
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void setZTest(bool zTest);

	//--------------------------------------------------------------------------
	// CfbNXobt@
	//--------------------------------------------------------------------------
	/**
	 * ÓICfbNXobt@̍\z
	 * @param bufferSize obt@TCY
	 * @return ÓICfbNXobt@
	 */
	virtual Direct3DIndexBuffer* createStaticIndexBuffer(int bufferSize);

	/**
	 * ÓICfbNXobt@̃bN
	 * @param indexBuffer CfbNXobt@
	 * @param offset ItZbg
	 * @param size TCY
	 * @return ݃AhX
	 */
	virtual u_char* lockStaticIndexBuffer(
		Direct3DIndexBuffer* indexBuffer, int offset, int size);

	/**
	 * ÓICfbNXobt@̃AbN
	 * @param indexBuffer CfbNXobt@
	 */
	virtual void unlockStaticIndexBuffer(Direct3DIndexBuffer* indexBuffer);

	/**
	 * ÓICfbNXobt@̏
	 * @param indexBuffer CfbNXobt@
	 * @param data f[^
	 * @param dataSize f[^TCY
	 */
	virtual void writeStaticIndexBuffer(
		Direct3DIndexBuffer* indexBuffer, const void* data, int dataSize);

	/**
	 * ICfbNXobt@̍\z
	 * @param bufferSize obt@TCY
	 * @return ICfbNXobt@
	 */
	virtual Direct3DIndexBuffer* createDynamicIndexBuffer(int bufferSize);

	/**
	 * ICfbNXobt@̏
	 * @param indexBuffer CfbNXobt@
	 * @param data f[^
	 * @param dataSize f[^TCY
	 */
	virtual void writeDynamicIndexBuffer(
		Direct3DIndexBuffer* indexBuffer, const void* data, int dataSize);

	/**
	 * CfbNXobt@̐ݒ
	 * @param indexBuffer CfbNXobt@
	 */
	virtual void setIndexBuffer(Direct3DIndexBuffer* indexBuffer);

	//--------------------------------------------------------------------------
	// _Lq
	//--------------------------------------------------------------------------
	/**
	 * _Lq̍\z
	 * @param vertexDeclaration [out] _Lq
	 * @param hasPosition ʒu
	 * @param weightsPerVertex _EFCg
	 * @param bonesPerVertex _{[
	 * @param hasNormal @
	 * @param hasColor _J[
	 * @param texCoordSetCount eNX`WZbg
	 * @param texCoordTypeArray eNX`W^Cvz
	 * @return _TCY
	 */
	virtual int createVertexDeclaration(
		Direct3DVertexDeclaration** vertexDeclaration, bool hasPosition,
		int weightsPerVertex, int bonesPerVertex, bool hasNormal,
		bool hasColor, int texCoordSetCount,
		const TexCoord::Type* texCoordTypeArray);

	/**
	 * _Lq̐ݒ
	 * @param vertexDeclaration _Lq
	 */
	virtual void setVertexDeclaration(
		Direct3DVertexDeclaration* vertexDeclaration);

	//--------------------------------------------------------------------------
	// _obt@
	//--------------------------------------------------------------------------
	/**
	 * ÓI_obt@̍\z
	 * @param bufferSize obt@TCY
	 * @return ÓI_obt@
	 */
	virtual Direct3DVertexBuffer* createStaticVertexBuffer(int bufferSize);

	/**
	 * ÓI_obt@̏
	 * @param vertexBuffer ÓI_obt@
	 * @param bufferSize obt@TCY
	 * @param vertexCount _
	 * @param positions ʒuz
	 * @param weightsPerVertex _EFCg
	 * @param weights EFCgz
	 * @param bonesBerVertex _{[
	 * @param boneIndices {[CfbNXz
	 * @param normals @z
	 * @param colors _J[z
	 * @param texCoordSetCount eNX`WZbg
	 * @param texCoordTypeArray eNX`W^Cvz
	 * @param texCoords eNX`Wz
	 */
	virtual void writeStaticVertexBuffer(
		Direct3DVertexBuffer* vertexBuffer, int bufferSize, int vertexCount,
		const Vector3* positions, int weightsPerVertex, const float* weights,
		int bonesBerVertex, const u_char* boneIndices, const Vector3* normals,
		const Color4c* colors, int texCoordSetCount,
		const TexCoord::Type* texCoordTypeArray, const float* const* texCoords);

	/**
	 * I_obt@̍\z
	 * @param bufferSize obt@TCY
	 * @return I_obt@
	 */
	virtual Direct3DVertexBuffer* createDynamicVertexBuffer(int bufferSize);

	/**
	 * I_obt@̃bN
	 * @param vertexBuffer I_obt@
	 * @param offset ItZbg
	 * @param size TCY
	 * @return ݃AhX
	 */
	virtual u_char* lockDynamicVertexBuffer(
		Direct3DVertexBuffer* vertexBuffer, int offset, int size);

	/**
	 * I_obt@̃AbN
	 * @param vertexBuffer I_obt@
	 */
	virtual void unlockDynamicVertexBuffer(Direct3DVertexBuffer* vertexBuffer);

	/**
	 * I_obt@̏
	 * @param vertexBuffer I_obt@
	 * @param bufferSize obt@TCY
	 * @param vertexCount _
	 * @param positions ʒuz
	 * @param weightsPerVertex _EFCg
	 * @param weights EFCgz
	 * @param bonesBerVertex _{[
	 * @param boneIndices {[CfbNXz
	 * @param normals @z
	 * @param colors _J[z
	 * @param texCoordSetCount eNX`WZbg
	 * @param texCoordTypeArray eNX`W^Cvz
	 * @param texCoords eNX`Wz
	 */
	virtual void writeDynamicVertexBuffer(
		Direct3DVertexBuffer* vertexBuffer, int bufferSize, int vertexCount,
		const Vector3* positions, int weightsPerVertex, const float* weights,
		int bonesBerVertex, const u_char* boneIndices, const Vector3* normals,
		const Color4c* colors, int texCoordSetCount,
		const TexCoord::Type* texCoordTypeArray, const float* const* texCoords);

	/**
	 * _obt@̐ݒ
	 * @param vertexBuffer _obt@
	 * @param vertexSize _TCY
	 */
	virtual void setVertexBuffer(
		Direct3DVertexBuffer* vertexBuffer, int vertexSize);

	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * OpXg`
	 * @param primitiveCount v~eBu
	 */
	virtual void drawTriangleList(int primitiveCount);

	/**
	 * CfbNXOpXg`
	 * @param vertexCount _
	 * @param primitiveCount v~eBu
	 */
	virtual void drawIndexedTriangleList(int vertexCount, int primitiveCount);

	/**
	 * CfbNXOpXg`
	 * @param baseVertexIndex _CfbNXItZbg
	 * @param minIndex ŏCfbNX
	 * @param vertexCount _
	 * @param startIndex JnCfbNX
	 * @param primitiveCount v~eBu
	 */
	virtual void drawIndexedTriangleList(int baseVertexIndex,
		int minIndex, int vertexCount, int startIndex, int primitiveCount);

	//--------------------------------------------------------------------------
	/**
	 * CXg`
	 * @param primitiveCount v~eBu
	 */
	virtual void drawLineList(int primitiveCount);

	/**
	 * CfbNXCXg`
	 * @param vertexCount _
	 * @param primitiveCount v~eBu
	 */
	virtual void drawIndexedLineList(int vertexCount, int primitiveCount);

	//--------------------------------------------------------------------------
	// JE^֘A
	//--------------------------------------------------------------------------
	/**
	 * JE^̃Zbg
	 */
	virtual void resetCounter(){
		drawPrimitiveCount_ = 0;
		drawPolygonCount_ = 0;
		drawVertexCount_ = 0;
	}

	/**
	 * _JEg̒ǉ
	 * @param drawPolygonCount `|SJEg
	 * @param drawVertexCount `撸_JEg
	 */
	virtual void addVertexCount(int drawPolygonCount, int drawVertexCount){
		drawPrimitiveCount_++;
		drawPolygonCount_ += drawPolygonCount;
		drawVertexCount_ += drawVertexCount;
	}

	/**
	 * DrawPrimitiveJEg̎擾
	 * @return DrawPrimitiveJEg
	 */
	virtual int getDrawPrimitiveCount(){ return drawPrimitiveCount_; }

	/**
	 * `|SJEg̎擾
	 * @return `|SJEg
	 */
	virtual int getDrawPolygonCount(){ return drawPolygonCount_; }

	/**
	 * `撸_JEg
	 * @return `撸_JEg
	 */
	virtual int getDrawVertexCount(){ return drawVertexCount_; }

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param capacity foCX\
	 */
	RenderingDevice(GraphicsDeviceCapacity* capacity);

	/**
	 * fXgN^
	 */
	virtual ~RenderingDevice();

	//--------------------------------------------------------------------------
	// [eBeB
	//--------------------------------------------------------------------------
	/**
	 * _f[^̏
	 * @param buffer ݃obt@
	 * @param bufferSize obt@TCY
	 * @param vertexCount _
	 * @param positions ʒuz
	 * @param weightsPerVertex _EFCg
	 * @param weights EFCgz
	 * @param bonesBerVertex _{[
	 * @param boneIndices {[CfbNXz
	 * @param normals @z
	 * @param colors _J[z
	 * @param texCoordSetCount eNX`WZbg
	 * @param texCoordTypeArray eNX`W^Cvz
	 * @param texCoords eNX`Wz
	 */
	virtual void writeVertices(u_char* buffer, int bufferSize, int vertexCount,
		const Vector3* positions, int weightsPerVertex, const float* weights,
		int bonesBerVertex, const u_char* boneIndices, const Vector3* normals,
		const Color4c* colors, int texCoordSetCount,
		const TexCoord::Type* texCoordTypeArray, const float* const* texCoords);

	/**
	 * D3DxNg̐ݒ
	 * @param destination ݒ
	 * @param source ݒ茳
	 */
	virtual void setD3DVector(D3DVECTOR& destination, const Vector3& source);

	/**
	 * D3DJ[̐ݒ
	 * @param destination ݒ
	 * @param source ݒ茳
	 */
	virtual void setD3DColor(D3DCOLORVALUE& destination, const Color4f& source);

	/**
	 * D3DJ[̐ݒ
	 * @param destination ݒ
	 * @param source ݒ茳
	 */
	virtual void setD3DColor(D3DCOLORVALUE& destination, const Color3f& source);

	//--------------------------------------------------------------------------
	// Xe[gubN֘A
	//--------------------------------------------------------------------------
	/**
	 * ftHgXe[gubÑXgA
	 * @param direct3DDevice Direct3DfoCX
	 */
	virtual void restoreDefaultStateBlock(Direct3DDevice* direct3DDevice);

	/**
	 * ftHgXe[gubN̖
	 */
	virtual void invalidateDefaultStateBlock(){
		SafeRelease(defaultStateBlock_);
	}

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	RenderingDevice(const RenderingDevice& copy);

	// Rs[̉B
	void operator =(const RenderingDevice& copy);

	//--------------------------------------------------------------------------
	// VXe
	//--------------------------------------------------------------------------
	// foCX\
	GraphicsDeviceCapacity* capacity_;
	// Direct3DfoCX
	Direct3DDevice* device_;
	// ftHgXe[gubN
	Direct3DStateBlock* defaultStateBlock_;

	//--------------------------------------------------------------------------
	// JE^֘A
	//--------------------------------------------------------------------------
	// DrawPrimitiveJEg
	int drawPrimitiveCount_;
	// `|SJEg
	int drawPolygonCount_;
	// `撸_JEg
	int drawVertexCount_;

	//--------------------------------------------------------------------------
	// CX^X
	static RenderingDevice* instance_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of RENDERING_DEVICE_H_
//------------------------------------------------------------------------------
