//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * _wb_
 * @author Junpee
 */

#ifndef RENDERER_H_
#define RENDERER_H_

#include <Graphics/System/GraphicsDeviceObjectHolder.h>
#include <Core/Container/ArrayList.h>

namespace Lamp{

class DrawRequest;
class Scene;
class Mesh;

//------------------------------------------------------------------------------
/**
 * _
 */
class Renderer : public GraphicsDeviceObjectHolder{
public:
	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// At@eXg臒l
	static const int alphaTestBorder_ = 127;

	/// ufBOAt@eXg臒l
	static const int blendingAlphaTestBorder_ = 4;

	/// bVXgTCYl
	static const int initialMeshListSize = 4096;

	/// őANeBuCg
	static const int maxActiveLightCount_ = 8;

	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	Renderer();

	/**
	 * fXgN^
	 */
	virtual ~Renderer();

	//--------------------------------------------------------------------------
	// _O
	//--------------------------------------------------------------------------
	/**
	 * _Os
	 * @param scene _OsV[
	 */
	virtual void renderingSetup(Scene* scene);

	/**
	 * _Os
	 */
	virtual void rendering();

	//--------------------------------------------------------------------------
	// \[gpR[obN
	//--------------------------------------------------------------------------
	/**
	 * bVXg̃\[g
	 * @param left Ӓl
	 * @param right EӒl
	 * @return ӒlEӒl傫Ƃ1ȏ
	 */
	static int sortMeshList(Mesh* const* left, Mesh* const* right);

	//--------------------------------------------------------------------------
	// foCXIuWFNg
	//--------------------------------------------------------------------------
	/**
	 * foCXIuWFNg̏
	 * @return trueԂ
	 */
	virtual bool initializeGraphicsDeviceObjects(){ return true; }

	/**
	 * foCXIuWFNg̍폜
	 */
	virtual void deleteGraphicsDeviceObjects(){}

	/**
	 * foCXIuWFNg̃XgA
	 * @return trueԂ
	 */
	virtual bool restoreGraphicsDeviceObjects(){
		buildRendererStateBlock();
		return true;
	}

	/**
	 * foCXIuWFNg̖
	 */
	virtual void invalidateGraphicsDeviceObjects(){
		SafeRelease(rendererStateBlock_);
	}

protected:
	//--------------------------------------------------------------------------
	/**
	 * _Xe[gubN̍\z
	 */
	virtual void buildRendererStateBlock();

	/**
	 * bVXg̍\z
	 */
	virtual void buildMeshList();

	/**
	 * `惊NGXg̏
	 */
	virtual void initializeDrawRequest();

	/**
	 * O[oݒ̏
	 */
	virtual void initializeGlobalSettings();

	/// _Xe[gubN
	Direct3DStateBlock* rendererStateBlock_;
	/// `惊NGXg
	DrawRequest* drawRequest_;
	/// V[
	Scene* scene_;
	/// bVXg
	ArrayList<Mesh*> meshList_;

private:
	// Rs[RXgN^̉B
	Renderer(const Renderer& copy);

	// Rs[̉B
	void operator =(const Renderer& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of RENDERER_H_
//------------------------------------------------------------------------------
