//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * CtH[V_wb_
 * @author Junpee
 */

#ifndef INFORMATION_RENDERER_H_
#define INFORMATION_RENDERER_H_

#include <Core/Container/ArrayList.h>

namespace Lamp{

class PrimitiveRenderer;
class Scene;
class Camera;
class Mesh;

//------------------------------------------------------------------------------
/**
 * CtH[V_
 */
class InformationRenderer{
public:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	InformationRenderer();

	/**
	 * fXgN^
	 */
	virtual ~InformationRenderer();

	//--------------------------------------------------------------------------
	// _O
	//--------------------------------------------------------------------------
	/**
	 * _Os
	 * @param scene _OsV[
	 */
	virtual void renderingSetup(Scene* scene);

	/**
	 * _Os
	 */
	virtual void rendering();

	//--------------------------------------------------------------------------
	// `tO
	//--------------------------------------------------------------------------
	/**
	 * Obh̕`tOݒ
	 * @param isDrawnGrid Obh`悷Ȃtrue
	 */
	virtual void setDrawnGrid(bool isDrawnGrid){ isDrawnGrid_ = isDrawnGrid; }

	/**
	 * Obh`悷邩
	 * @return Obh`悷Ȃtrue
	 */
	virtual bool isDrawnGrid() const{ return isDrawnGrid_; }

	//--------------------------------------------------------------------------
	/**
	 * ̕`tOݒ
	 * @param isDrawnAxis `悷Ȃtrue
	 */
	virtual void setDrawnAxis(bool isDrawnAxis){ isDrawnAxis_ = isDrawnAxis; }

	/**
	 * `悷邩
	 * @return `悷Ȃtrue
	 */
	virtual bool isDrawnAxis() const{ return isDrawnAxis_; }

	//--------------------------------------------------------------------------
	/**
	 * bVoEfBO̕`tOݒ
	 * @param isDrawnMeshBounding bVoEfBO`悷Ȃtrue
	 */
	virtual void setDrawnMeshBounding(bool isDrawnMeshBounding){
		isDrawnMeshBounding_ = isDrawnMeshBounding;
	}

	/**
	 * bVoEfBO`悷邩
	 * @return bVoEfBO`悷Ȃtrue
	 */
	virtual bool isDrawnMeshBounding() const{ return isDrawnMeshBounding_; }

	//--------------------------------------------------------------------------
	/**
	 * {[̕`tOݒ
	 * @param isDrawnBone {[`悷Ȃtrue
	 */
	virtual void setDrawnBone(bool isDrawnBone){ isDrawnBone_ = isDrawnBone; }

	/**
	 * {[`悷邩
	 * @return {[`悷Ȃtrue
	 */
	virtual bool isDrawnBone() const{ return isDrawnBone_; }

protected:
	//--------------------------------------------------------------------------
	/**
	 * Obh̃ZbgAbv
	 */
	virtual void setupGrid();

	/**
	 * ̃ZbgAbv
	 */
	virtual void setupAxis();

	/**
	 * bVoEfBÕZbgAbv
	 */
	virtual void setupMeshBounding();

	/**
	 * {[̃ZbgAbv
	 */
	virtual void setupBone();

	//--------------------------------------------------------------------------
	/// v~eBu_
	PrimitiveRenderer* renderer_;
	/// V[
	Scene* scene_;
	/// J
	Camera* camera_;
	/// bVXg
	ArrayList<Mesh*> meshList_;

	/// Obh`悷邩
	bool isDrawnGrid_;
	/// `悷邩
	bool isDrawnAxis_;
	/// bVoEfBO`悷邩
	bool isDrawnMeshBounding_;
	/// {[`悷邩
	bool isDrawnBone_;

	/// bVoEfBOJ[
	static const Color4c meshBoundingColor_;
	/// {[J[
	static const Color4c boneColor_;

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	InformationRenderer(const InformationRenderer& copy);

	// Rs[̉B
	void operator =(const InformationRenderer& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of INFORMATION_RENDERER_H_
//------------------------------------------------------------------------------
