//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * `惊NGXgwb_
 * @author Junpee
 */

#ifndef DRAW_REQUEST_H_
#define DRAW_REQUEST_H_

#include <Core/Container/ArrayList.h>

namespace Lamp{

class Fog;
class Camera;
class SceneNode;
class Model;
class Mesh;
class MeshData;
class Material;
class LocalLight;
class AmbientLight;
class DirectionalLight;

//------------------------------------------------------------------------------
/**
 * `惊NGXg
 */
class DrawRequest{
friend class Renderer;
public:
	//--------------------------------------------------------------------------
	// bV
	//--------------------------------------------------------------------------
	/**
	 * bV̎擾
	 * @return bV
	 */
	virtual Mesh* getMesh() const{ return mesh_; }

	/**
	 * bVɕύX
	 * @return bVɕύXtrue
	 */
	virtual bool isMeshChanged() const{ return (mesh_ != preMesh_); }

	/**
	 * V[m[h̎擾
	 * @return V[m[h
	 */
	virtual SceneNode* getSceneNode() const{ return sceneNode_; }

	/**
	 * V[m[hɕύX
	 * @return V[m[hɕύXtrue
	 */
	virtual bool isSceneNodeChanged() const{
		return (sceneNode_ != preSceneNode_);
	}

	/**
	 * f̎擾
	 * @return f
	 */
	virtual Model* getModel() const{ return model_; }

	/**
	 * fɕύX
	 * @return fɕύXtrue
	 */
	virtual bool isModelChanged() const{ return (model_ != preModel_); }

	/**
	 * bVf[^̎擾
	 * @return bVf[^
	 */
	virtual MeshData* getMeshData() const{ return meshData_; }

	/**
	 * bVf[^ɕύX
	 * @return bVf[^ɕύXtrue
	 */
	virtual bool isMeshDataChanged() const{
		return (meshData_ != preMeshData_);
	}

	/**
	 * }eA̎擾
	 * @return }eA
	 */
	virtual Material* getMaterial() const{ return material_; }

	/**
	 * Õ}eA̎擾
	 * @return Õ}eA
	 */
	virtual Material* getPreMaterial() const{ return preMaterial_; }

	/**
	 * }eAɕύX
	 * @return }eAɕύXtrue
	 */
	virtual bool isMaterialChanged() const{
		return (material_ != preMaterial_);
	}

	/**
	 * KKvƂ邩
	 * @return KKvƂȂtrue
	 */
	virtual bool requireNormalize() const;

	/**
	 * pCvC[hɕύX
	 * @return pCvC[hɕύXtrue
	 */
	virtual bool isPipelineModeChanged() const;

	//--------------------------------------------------------------------------
	// tHO
	//--------------------------------------------------------------------------
	/**
	 * tHO̎擾
	 * @return tHO
	 */
	virtual Fog* getFog() const{ return fog_; }

	//--------------------------------------------------------------------------
	// J
	//--------------------------------------------------------------------------
	/**
	 * J̎擾
	 * @return J
	 */
	virtual Camera* getCamera() const{ return camera_; }

	//--------------------------------------------------------------------------
	// ArGgCg
	//--------------------------------------------------------------------------
	/**
	 * ArGgCg̎擾
	 * @return ArGgCg
	 */
	virtual int getAmbientLightCount() const{
		return ambientLights_.getCount();
	}

	/**
	 * ArGgCg̎擾
	 */
	virtual AmbientLight* getAmbientLight(int index) const{
		return ambientLights_.get(index);
	}

	/**
	 * ArGgF̎擾
	 * @return ArGgF
	 */
	Color3f getAmbientColor() const;

	//--------------------------------------------------------------------------
	// fBNViCg
	//--------------------------------------------------------------------------
	/**
	 * fBNViCg̎擾
	 * @return fBNViCg
	 */
	virtual int getDirectionalLightCount() const{
		return directionalLights_.getCount();
	}

	/**
	 * fBNViCg̎擾
	 */
	virtual DirectionalLight* getDirectionalLight(int index) const{
		return directionalLights_.get(index);
	}

	//--------------------------------------------------------------------------
	// [JCg
	//--------------------------------------------------------------------------
	/**
	 * [JCg̒ǉ
	 * @param localLight ǉ郉Cg
	 */
	virtual void addLocalLight(LocalLight* localLight);

	/**
	 * [JCg̃NA
	 */
	virtual void clearLocalLights(){ localLights_.clear(); }

	/**
	 * [JCg̎擾
	 * @return [JCg
	 */
	virtual int getLocalLightCount() const{ return localLights_.getCount(); }

	/**
	 * [JCg̎擾
	 */
	virtual LocalLight* getLocalLight(int index) const{
		return localLights_.get(index);
	}

	/**
	 * [JCg̃\[g
	 */
	virtual void sortLocalLights(){
		localLights_.sort(sortLocalLightsCallback);
	}

	//--------------------------------------------------------------------------
	/**
	 * [JCg̃\[gpR[obN
	 * @param left Ӓl
	 * @param right EӒl
	 * @return ӒlEӒl傫Ƃ1ȏ
	 */
	static int sortLocalLightsCallback(
		LocalLight* const* left, LocalLight* const* right);

protected:
	//--------------------------------------------------------------------------
	// _gpC^[tF[X
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	DrawRequest();

	/**
	 * fXgN^
	 */
	virtual ~DrawRequest();

	//--------------------------------------------------------------------------
	/**
	 * NA
	 */
	virtual void clear();

	//--------------------------------------------------------------------------
	/**
	 * uhLɂȂ
	 * @return uhLɂȂ̂Ȃtrue
	 */
	virtual bool isBlendEnabled() const;

	//--------------------------------------------------------------------------
	/**
	 * bV̐ݒ
	 * @param mesh bV
	 */
	virtual void setMesh(Mesh* mesh);

	//--------------------------------------------------------------------------
	/**
	 * tHO̐ݒ
	 * @param fog tHO
	 */
	virtual void setFog(Fog* fog){ fog_ = fog; }

	//--------------------------------------------------------------------------
	/**
	 * J̐ݒ
	 * @param camera J
	 */
	virtual void setCamera(Camera* camera){ camera_ = camera; }

	//--------------------------------------------------------------------------
	/**
	 * ArGgCg̒ǉ
	 * @param ambientLight ǉ郉Cg
	 */
	virtual void addAmbientLight(AmbientLight* ambientLight);

	/**
	 * fBNViCg̒ǉ
	 * @param directionalLight ǉ郉Cg
	 */
	virtual void addDirectionalLight(DirectionalLight* directionalLight);

	//--------------------------------------------------------------------------
	/**
	 * [JCg̃\[g
	 */
	virtual int sortLocalLightsImprement(LocalLight* left, LocalLight* right);

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	DrawRequest(const DrawRequest& copy);

	// Rs[̉B
	void operator =(const DrawRequest& copy);

	// CX^X
	static DrawRequest* instance_;
	// ArGgCg
	ArrayList<AmbientLight*> ambientLights_;
	// fBNViCg
	ArrayList<DirectionalLight*> directionalLights_;
	// [JCg
	ArrayList<LocalLight*> localLights_;
	// tHO
	Fog* fog_;
	// J
	Camera* camera_;
	// bV
	Mesh* mesh_;
	// V[m[h
	SceneNode* sceneNode_;
	// f
	Model* model_;
	// bVf[^
	MeshData* meshData_;
	// }eA
	Material* material_;
	// ÕbV
	Mesh* preMesh_;
	// ÕV[m[h
	SceneNode* preSceneNode_;
	// Õf
	Model* preModel_;
	// ÕbVf[^
	MeshData* preMeshData_;
	// Õ}eA
	Material* preMaterial_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of DRAW_REQUEST_H_
//------------------------------------------------------------------------------
