//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * v~eBu_wb_
 * @author Junpee
 */

#ifndef PRIMITIVE_RENDERER_H_
#define PRIMITIVE_RENDERER_H_

#include <Graphics/System/GraphicsDeviceObjectHolder.h>
#include <Core/Container/ArrayList.h>
#include <Graphics/PrimitiveRenderer/PrimitiveDrawRequest.h>

namespace Lamp{

class Camera;

//------------------------------------------------------------------------------
/**
 * v~eBu_
 */
class PrimitiveRenderer : public GraphicsDeviceObjectHolder{
public:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	PrimitiveRenderer();

	/**
	 * fXgN^
	 */
	virtual ~PrimitiveRenderer();

	//--------------------------------------------------------------------------
	// _O
	//--------------------------------------------------------------------------
	/**
	 * _O
	 * @param viewMatrix r[s
	 * @param projectionMatrix es
	 */
	virtual void render(const Matrix44& viewMatrix,
		const Matrix44& projectionMatrix);

	/**
	 * _O
	 * @param camera J
	 */
	virtual void render(Camera* camera);

	//--------------------------------------------------------------------------
	// NGXg
	//--------------------------------------------------------------------------
	/**
	 * NGXg
	 * @param primitive v~eBu
	 * @param matrix s
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void request(const PrimitiveDrawRequest& primitive,
		const Matrix34& matrix, Color4c color = Color4c::white,
		bool zTest = true);

	/**
	 * NGXg
	 * @param primitive v~eBu
	 * @param scale XP[
	 * @param rotationXYZ XYZ]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void request(const PrimitiveDrawRequest& primitive,
		const Vector3& scale, const Vector3& rotationXYZ,
		const Vector3 translation, Color4c color = Color4c::white,
		bool zTest = true){
		Matrix34 matrix;
		matrix.setTransformationXYZ(scale, rotationXYZ, translation);
		request(primitive, matrix, color, zTest);
	}

	/**
	 * NGXg
	 * @param primitive v~eBu
	 * @param scale XP[
	 * @param rotationQuaternion l]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void request(const PrimitiveDrawRequest& primitive,
		const Vector3& scale, const Quaternion& rotationQuaternion,
		const Vector3 translation, Color4c color = Color4c::white,
		bool zTest = true){
		Matrix34 matrix;
		matrix.setTransformationQuaternion(
			scale, rotationQuaternion, translation);
		request(primitive, matrix, color, zTest);
	}

	//--------------------------------------------------------------------------
	/**
	 * ̃NGXg
	 * @param vertexCount _
	 * @param positions ʒuz
	 * @param matrix s
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestLine(int vertexCount, Vector3* positions,
		const Matrix34& matrix, Color4c color = Color4c::white,
		bool zTest = true);

	/**
	 * ̃NGXg
	 * @param vertexCount _
	 * @param positions ʒuz
	 * @param scale XP[
	 * @param rotationXYZ XYZ]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestLine(int vertexCount, Vector3* positions,
		const Vector3& scale, const Vector3& rotationXYZ,
		const Vector3 translation, Color4c color = Color4c::white,
		bool zTest = true){
		Matrix34 matrix;
		matrix.setTransformationXYZ(scale, rotationXYZ, translation);
		requestLine(vertexCount, positions, matrix, color, zTest);
	}

	/**
	 * ̃NGXg
	 * @param vertexCount _
	 * @param positions ʒuz
	 * @param scale XP[
	 * @param rotationQuaternion l]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestLine(int vertexCount, Vector3* positions,
		const Vector3& scale, const Quaternion& rotationQuaternion,
		const Vector3 translation, Color4c color = Color4c::white,
		bool zTest = true){
		Matrix34 matrix;
		matrix.setTransformationQuaternion(
			scale, rotationQuaternion, translation);
		requestLine(vertexCount, positions, matrix, color, zTest);
	}

	//--------------------------------------------------------------------------
	/**
	 * ̃NGXg
	 * @param vertexCount _
	 * @param positions ʒuz
	 * @param colors Fz
	 * @param matrix s
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestLine(int vertexCount, Vector3* positions,
		Color4c* colors, const Matrix34& matrix,
		Color4c color = Color4c::white, bool zTest = true);

	/**
	 * ̃NGXg
	 * @param vertexCount _
	 * @param positions ʒuz
	 * @param colors Fz
	 * @param scale XP[
	 * @param rotationXYZ XYZ]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestLine(int vertexCount, Vector3* positions,
		Color4c* colors, const Vector3& scale, const Vector3& rotationXYZ,
		const Vector3 translation, Color4c color = Color4c::white,
		bool zTest = true){
		Matrix34 matrix;
		matrix.setTransformationXYZ(scale, rotationXYZ, translation);
		requestLine(vertexCount, positions, colors, matrix, color, zTest);
	}

	/**
	 * ̃NGXg
	 * @param vertexCount _
	 * @param positions ʒuz
	 * @param colors Fz
	 * @param scale XP[
	 * @param rotationQuaternion l]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestLine(int vertexCount, Vector3* positions,
		Color4c* colors, const Vector3& scale,
		const Quaternion& rotationQuaternion, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		Matrix34 matrix;
		matrix.setTransformationQuaternion(
			scale, rotationQuaternion, translation);
		requestLine(vertexCount, positions, colors, matrix, color, zTest);
	}

	//--------------------------------------------------------------------------
	// v~eBuNGXg
	//--------------------------------------------------------------------------
	/**
	 * |Cg̃NGXg
	 * @param matrix s
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestPoint(const Matrix34& matrix,
		Color4c color = Color4c::white, bool zTest = true){
		request(point_, matrix, color, zTest);
	}

	/**
	 * |Cg̃NGXg
	 * @param scale XP[
	 * @param rotationXYZ XYZ]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestPoint(const Vector3& scale,
		const Vector3& rotationXYZ, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(point_, scale, rotationXYZ, translation, color, zTest);
	}

	/**
	 * |Cg̃NGXg
	 * @param scale XP[
	 * @param rotationQuaternion l]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestPoint(const Vector3& scale,
		const Quaternion& rotationQuaternion, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(point_, scale, rotationQuaternion, translation, color, zTest);
	}

	//--------------------------------------------------------------------------
	/**
	 * |Cg̃NGXg
	 * @param matrix s
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestAxisPoint(const Matrix34& matrix,
		Color4c color = Color4c::white, bool zTest = true){
		request(axisAxisPoint_, matrix, color, zTest);
	}

	/**
	 * |Cg̃NGXg
	 * @param scale XP[
	 * @param rotationXYZ XYZ]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestAxisPoint(const Vector3& scale,
		const Vector3& rotationXYZ, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(axisAxisPoint_, scale, rotationXYZ, translation, color, zTest);
	}

	/**
	 * |Cg̃NGXg
	 * @param scale XP[
	 * @param rotationQuaternion l]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestAxisPoint(const Vector3& scale,
		const Quaternion& rotationQuaternion, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(axisAxisPoint_, scale, rotationQuaternion, translation, color, zTest);
	}

	//--------------------------------------------------------------------------
	/**
	 * ̃NGXg
	 * @param matrix s
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestAxis(const Matrix34& matrix,
		Color4c color = Color4c::white, bool zTest = true){
		request(axis_, matrix, color, zTest);
	}

	/**
	 * ̃NGXg
	 * @param scale XP[
	 * @param rotationXYZ XYZ]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestAxis(const Vector3& scale,
		const Vector3& rotationXYZ, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(axis_, scale, rotationXYZ, translation, color, zTest);
	}

	/**
	 * ̃NGXg
	 * @param scale XP[
	 * @param rotationQuaternion l]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestAxis(const Vector3& scale,
		const Quaternion& rotationQuaternion, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(axis_, scale, rotationQuaternion, translation, color, zTest);
	}

	//--------------------------------------------------------------------------
	/**
	 * ̃NGXg
	 * @param matrix s
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestArrow(const Matrix34& matrix,
		Color4c color = Color4c::white, bool zTest = true){
		request(arrow_, matrix, color, zTest);
	}

	/**
	 * ̃NGXg
	 * @param scale XP[
	 * @param rotationXYZ XYZ]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestArrow(const Vector3& scale,
		const Vector3& rotationXYZ, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(arrow_, scale, rotationXYZ, translation, color, zTest);
	}

	/**
	 * ̃NGXg
	 * @param scale XP[
	 * @param rotationQuaternion l]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestArrow(const Vector3& scale,
		const Quaternion& rotationQuaternion, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(arrow_, scale, rotationQuaternion, translation, color, zTest);
	}

	//--------------------------------------------------------------------------
	/**
	 * Obh̃NGXg
	 * @param matrix s
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestGrid(const Matrix34& matrix,
		Color4c color = Color4c::white, bool zTest = true){
		request(grid_, matrix, color, zTest);
	}

	/**
	 * Obh̃NGXg
	 * @param scale XP[
	 * @param rotationXYZ XYZ]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestGrid(const Vector3& scale,
		const Vector3& rotationXYZ, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(grid_, scale, rotationXYZ, translation, color, zTest);
	}

	/**
	 * Obh̃NGXg
	 * @param scale XP[
	 * @param rotationQuaternion l]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestGrid(const Vector3& scale,
		const Quaternion& rotationQuaternion, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(grid_, scale, rotationQuaternion, translation, color, zTest);
	}

	//--------------------------------------------------------------------------
	/**
	 * ʂ̃NGXg
	 * @param matrix s
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestPlane(const Matrix34& matrix,
		Color4c color = Color4c::white, bool zTest = true){
		request(plane_, matrix, color, zTest);
	}

	/**
	 * ʂ̃NGXg
	 * @param scale XP[
	 * @param rotationXYZ XYZ]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestPlane(const Vector3& scale,
		const Vector3& rotationXYZ, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(plane_, scale, rotationXYZ, translation, color, zTest);
	}

	/**
	 * ʂ̃NGXg
	 * @param scale XP[
	 * @param rotationQuaternion l]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestPlane(const Vector3& scale,
		const Quaternion& rotationQuaternion, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(plane_, scale, rotationQuaternion, translation, color, zTest);
	}

	//--------------------------------------------------------------------------
	/**
	 * ̃NGXg
	 * @param matrix s
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestSphere(const Matrix34& matrix,
		Color4c color = Color4c::white, bool zTest = true){
		request(sphere_, matrix, color, zTest);
	}

	/**
	 * ̃NGXg
	 * @param scale XP[
	 * @param rotationXYZ XYZ]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestSphere(const Vector3& scale,
		const Vector3& rotationXYZ, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(sphere_, scale, rotationXYZ, translation, color, zTest);
	}

	/**
	 * ̃NGXg
	 * @param scale XP[
	 * @param rotationQuaternion l]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestSphere(const Vector3& scale,
		const Quaternion& rotationQuaternion, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(sphere_, scale, rotationQuaternion, translation, color, zTest);
	}

	//--------------------------------------------------------------------------
	/**
	 * ̃NGXg
	 * @param matrix s
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestBox(const Matrix34& matrix,
		Color4c color = Color4c::white, bool zTest = true){
		request(box_, matrix, color, zTest);
	}

	/**
	 * ̃NGXg
	 * @param scale XP[
	 * @param rotationXYZ XYZ]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestBox(const Vector3& scale,
		const Vector3& rotationXYZ, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(box_, scale, rotationXYZ, translation, color, zTest);
	}

	/**
	 * ̃NGXg
	 * @param scale XP[
	 * @param rotationQuaternion l]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestBox(const Vector3& scale,
		const Quaternion& rotationQuaternion, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(box_, scale, rotationQuaternion, translation, color, zTest);
	}

	//--------------------------------------------------------------------------
	/**
	 * ~̃NGXg
	 * @param matrix s
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestCylinder(const Matrix34& matrix,
		Color4c color = Color4c::white, bool zTest = true){
		request(cylinder_, matrix, color, zTest);
	}

	/**
	 * ~̃NGXg
	 * @param scale XP[
	 * @param rotationXYZ XYZ]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestCylinder(const Vector3& scale,
		const Vector3& rotationXYZ, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(cylinder_, scale, rotationXYZ, translation, color, zTest);
	}

	/**
	 * ~̃NGXg
	 * @param scale XP[
	 * @param rotationQuaternion l]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestCylinder(const Vector3& scale,
		const Quaternion& rotationQuaternion, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(cylinder_, scale, rotationQuaternion, translation,
			color, zTest);
	}

	//--------------------------------------------------------------------------
	/**
	 * R[̃NGXg
	 * @param matrix s
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestCone(const Matrix34& matrix,
		Color4c color = Color4c::white, bool zTest = true){
		request(cone_, matrix, color, zTest);
	}

	/**
	 * R[̃NGXg
	 * @param scale XP[
	 * @param rotationXYZ XYZ]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestCone(const Vector3& scale,
		const Vector3& rotationXYZ, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(cone_, scale, rotationXYZ, translation, color, zTest);
	}

	/**
	 * R[̃NGXg
	 * @param scale XP[
	 * @param rotationQuaternion l]
	 * @param translation ړ
	 * @param color F
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void requestCone(const Vector3& scale,
		const Quaternion& rotationQuaternion, const Vector3 translation,
		Color4c color = Color4c::white, bool zTest = true){
		request(cone_, scale, rotationQuaternion, translation, color, zTest);
	}

	//--------------------------------------------------------------------------
	// foCXIuWFNg
	//--------------------------------------------------------------------------
	/**
	 * foCXIuWFNg̏
	 * @return trueԂ
	 */
	virtual bool initializeGraphicsDeviceObjects(){ return true; }

	/**
	 * foCXIuWFNg̍폜
	 */
	virtual void deleteGraphicsDeviceObjects(){}

	/**
	 * foCXIuWFNg̃XgA
	 * @return trueԂ
	 */
	virtual bool restoreGraphicsDeviceObjects(){ return true; }

	/**
	 * foCXIuWFNg̖
	 */
	virtual void invalidateGraphicsDeviceObjects();

protected:
	//--------------------------------------------------------------------------
	// NGXg
	//--------------------------------------------------------------------------
	/**
	 * NGXg
	 */
	class Request{
	public:
		/**
		 * RXgN^
		 */
		Request() : matrix_(Matrix34::unit), primitive_(),
			color_(Color4c::white), zTest_(true){}

		/**
		 * fXgN^
		 */
		virtual ~Request(){}

		/// s
		Matrix34 matrix_;
		/// v~eBu
		PrimitiveDrawRequest primitive_;
		/// F
		Color4c color_;
		/// ZeXgtO
		bool zTest_;
	};

	/**
	 * NGXg̕`
	 * @param request NGXg
	 */
	virtual void renderRequest(Request& request);

	//--------------------------------------------------------------------------
	// _Lq
	//--------------------------------------------------------------------------
	/**
	 * ʒu̒_Lqݒ
	 * @return ʒu̒_Lq
	 */
	void setPositionVertexDeclaration();

	/**
	 * ʒuƃJ[̒_Lqݒ
	 * @return ʒu̒_Lq
	 */
	void setPositionColorVertexDeclaration();

	/// NGXg
	ArrayList<Request> requests_;
	/// ʒu̒_Lq
	Direct3DVertexDeclaration* positionDeclaration_;
	/// ʒuƃJ[̒_Lq
	Direct3DVertexDeclaration* positionColorDeclaration_;
	/// |Cg
	PrimitiveDrawRequest point_;
	/// |Cg
	PrimitiveDrawRequest axisAxisPoint_;
	/// 
	PrimitiveDrawRequest axis_;
	/// 
	PrimitiveDrawRequest arrow_;
	/// Obh
	PrimitiveDrawRequest grid_;
	/// 
	PrimitiveDrawRequest plane_;
	/// 
	PrimitiveDrawRequest sphere_;
	/// 
	PrimitiveDrawRequest box_;
	/// ~
	PrimitiveDrawRequest cone_;
	/// R[
	PrimitiveDrawRequest cylinder_;

private:
	// Rs[RXgN^̉B
	PrimitiveRenderer(const PrimitiveRenderer& copy);

	// Rs[̉B
	void operator =(const PrimitiveRenderer& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of PRIMITIVE_RENDERER_H_
//------------------------------------------------------------------------------

