//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * v~eBu`惊NGXgr_wb_
 * @author Junpee
 */

#ifndef PRIMITIVE_DRAW_REQUEST_BUILDER_H_
#define PRIMITIVE_DRAW_REQUEST_BUILDER_H_

namespace Lamp{

class PrimitiveDrawRequest;
class CharacterModel;

//------------------------------------------------------------------------------
/**
 * v~eBu`惊NGXgr_
 */
class PrimitiveDrawRequestBuilder{
public:
	/**
	 * |Cg̍\z
	 * @param request `惊NGXg
	 */
	static void buildPoint(PrimitiveDrawRequest* request);

	/**
	 * |Cg̍\z
	 * @param request `惊NGXg
	 */
	static void buildAxisPoint(PrimitiveDrawRequest* request);

	/**
	 * ̍\z
	 * @param request `惊NGXg
	 */
	static void buildAxis(PrimitiveDrawRequest* request);

	/**
	 * ̍\z
	 * @param request `惊NGXg
	 */
	static void buildArrow(PrimitiveDrawRequest* request);

	/**
	 * Obh̍\z
	 * @param request `惊NGXg
	 * @param division 
	 * @param subDivision Tu
	 */
	static void buildGrid(PrimitiveDrawRequest* request,
		int division, int subDivision);

	/**
	 * ʂ̍\z
	 * @param request `惊NGXg
	 */
	static void buildPlane(PrimitiveDrawRequest* request);

	/**
	 * ̍\z
	 * @param request `惊NGXg
	 * @param radius a
	 * @param horizontalDivision 
	 * @param verticalDivision 
	 */
	static void buildSphere(PrimitiveDrawRequest* request,
		float radius, int horizontalDivision, int verticalDivision);

	/**
	 * ̍\z
	 * @param request `惊NGXg
	 * @param width 
	 * @param height 
	 * @param depth s
	 */
	static void buildBox(PrimitiveDrawRequest* request,
		float width, float height, float depth);

	/**
	 * ~̍\z
	 * @param request `惊NGXg
	 * @param radius a
	 * @param height 
	 * @param division 
	 */
	static void buildCylinder(PrimitiveDrawRequest* request,
		float radius, float height, int division);

	/**
	 * R[̍\z
	 * @param request `惊NGXg
	 * @param radius a
	 * @param height 
	 * @param division 
	 */
	static void buildCone(PrimitiveDrawRequest* request,
		float radius, float height, int division);

	/**
	 * {[̍\z
	 * @param request `惊NGXg
	 * @param model LN^f
	 */
	static void buildBone(PrimitiveDrawRequest* request, CharacterModel* model);

private:
	//--------------------------------------------------------------------------
	// RXgN^̉B
	PrimitiveDrawRequestBuilder();

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of PRIMITIVE_DRAW_REQUEST_BUILDER_H_
//------------------------------------------------------------------------------
