//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * v~eBu`惊NGXgwb_
 * @author Junpee
 */

#ifndef PRIMITIVE_DRAW_REQUEST_H_
#define PRIMITIVE_DRAW_REQUEST_H_

#include <Graphics/System/GraphicsDeviceObjectHolder.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * v~eBu`惊NGXg
 */
class PrimitiveDrawRequest{
friend class PrimitiveRenderer;
public:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	PrimitiveDrawRequest();

	/**
	 * Rs[RXgN^
	 * @param copy Rs[
	 */
	PrimitiveDrawRequest(const PrimitiveDrawRequest& copy);

	/**
	 * Rs[
	 * @param copy Rs[
	 */
	PrimitiveDrawRequest& operator =(const PrimitiveDrawRequest& copy);

	/**
	 * fXgN^
	 */
	virtual ~PrimitiveDrawRequest();

	//--------------------------------------------------------------------------
	// _
	//--------------------------------------------------------------------------
	/**
	 * _̐ݒ
	 * @param vertexCount _
	 */
	virtual void setVertexCount(int vertexCount);

	/**
	 * _̎擾
	 * @return _
	 */
	virtual int getVertexCount() const{ return data_->vertexCount_; }

	/**
	 * _TCY̎擾
	 * @return _TCY
	 */
	virtual int getVertexSize() const{
		if(hasColor()){ return sizeof(Vector3) + sizeof(Color4c); }
		else{ return sizeof(Vector3); }
	}

	//--------------------------------------------------------------------------
	// ʒu
	//--------------------------------------------------------------------------
	/**
	 * ʒu̐ݒ
	 * @param index CfbNX
	 * @param position ʒu
	 */
	virtual void setPosition(int index, const Vector3& position){
		Assert((index >= 0) && (index < data_->vertexCount_));
		data_->positions_[index] = position;
		data_->vertexBufferChanged_ = true;
	}

	/**
	 * ʒu̎擾
	 * @param index CfbNX
	 * @return ʒu
	 */
	virtual const Vector3& getPosition(int index) const{
		Assert((index >= 0) && (index < data_->vertexCount_));
		return data_->positions_[index];
	}

	/**
	 * ʒuz̎擾
	 * @return ʒuz
	 */
	virtual const Vector3* getPositionArray() const{ return data_->positions_; }

	//--------------------------------------------------------------------------
	// J[
	//--------------------------------------------------------------------------
	/**
	 * J[Lɂ邩ǂ
	 * @param colorFlag trueȂJ[LɂȂ
	 */
	virtual void enableColor(bool colorFlag);

	/**
	 * J[
	 * @return J[Ȃtrue
	 */
	virtual bool hasColor() const{ return (data_->colors_ != NULL); }

	/**
	 * J[̐ݒ
	 * @param index CfbNX
	 * @param color J[
	 */
	virtual void setColor(int index, const Color4c& color){
		Assert(hasColor());
		Assert((index >= 0) && (index < data_->vertexCount_));
		data_->colors_[index] = color;
		data_->vertexBufferChanged_ = true;
	}

	/**
	 * J[̎擾
	 * @param index CfbNX
	 * @return J[
	 */
	virtual const Color4c& getColor(int index) const{
		Assert(hasColor());
		Assert((index >= 0) && (index < data_->vertexCount_));
		return data_->colors_[index];
	}

	/**
	 * J[z̎擾
	 * @return J[z
	 */
	virtual const Color4c* getColorArray() const{ return data_->colors_; }

	//--------------------------------------------------------------------------
	// CfbNX
	//--------------------------------------------------------------------------
	/**
	 * _CfbNXǂ
	 * @return _CfbNXȂtrue
	 */
	virtual bool hasVertexIndices() const{
		return (data_->vertexIndexCount_ != 0);
	}

	/**
	 * _CfbNX̐ݒ
	 * @param vertexIndexCount _CfbNX
	 */
	virtual void setVertexIndexCount(int vertexIndexCount);

	/**
	 * _CfbNX̎擾
	 * @return _CfbNX
	 */
	virtual int getVertexIndexCount() const{ return data_->vertexIndexCount_; }

	/**
	 * _CfbNX̐ݒ
	 * @param index CfbNX
	 * @param vertexIndex _CfbNX
	 */
	virtual void setVertexIndex(int index, u_short vertexIndex){
		Assert(hasVertexIndices());
		Assert((index >= 0) && (index < getVertexIndexCount()));
		data_->vertexIndices_[index] = vertexIndex;
		data_->indexBufferChanged_ = true;
	}

	/**
	 * _CfbNX̎擾
	 * @param index CfbNX
	 * @return _CfbNX
	 */
	virtual u_short getVertexIndex(int index) const{
		Assert(hasVertexIndices());
		Assert((index >= 0) && (index < getVertexIndexCount()));
		return data_->vertexIndices_[index];
	}

	/**
	 * _CfbNXz̎擾
	 * @return _CfbNXz
	 */
	virtual const u_short* getVertexIndexArray(){
		return data_->vertexIndices_;
	}

private:
	//--------------------------------------------------------------------------
	/**
	 * t@X̍폜
	 * @return t@XJEg
	 */
	virtual int removeReference();

	//--------------------------------------------------------------------------
	/**
	 * _obt@̎擾
	 * @return _obt@
	 */
	Direct3DVertexBuffer* getVertexBuffer();

	/**
	 * CfbNXobt@̎擾
	 * @return CfbNXobt@
	 */
	Direct3DIndexBuffer* getIndexBuffer();

	//--------------------------------------------------------------------------
	/**
	 * f[^
	 */
	class Data : public GraphicsDeviceObjectHolder{
	friend class PrimitiveDrawRequest;
	private:
		//----------------------------------------------------------------------
		/**
		 * RXgN^
		 */
		Data();

		/**
		 * fXgN^
		 */
		virtual ~Data();

		//----------------------------------------------------------------------
		// t@X̒ǉ
		virtual int addReference(){
			referenceCount_++;
			return referenceCount_;
		}

		// t@X̍폜
		virtual int removeReference(){
			referenceCount_--;
			return referenceCount_;
		}

		//----------------------------------------------------------------------
		/**
		 * foCXIuWFNg̏
		 * @return trueԂ
		 */
		virtual bool initializeGraphicsDeviceObjects(){ return true; }

		/**
		 * foCXIuWFNg̍폜
		 */
		virtual void deleteGraphicsDeviceObjects(){}

		/**
		 * foCXIuWFNg̃XgA
		 * @return trueԂ
		 */
		virtual bool restoreGraphicsDeviceObjects(){ return true; }

		/**
		 * foCXIuWFNg̖
		 */
		virtual void invalidateGraphicsDeviceObjects(){
			SafeRelease(indexBuffer_);
			SafeRelease(vertexBuffer_);
		}

		//----------------------------------------------------------------------
		// _
		int vertexCount_;
		// ʒu
		Vector3* positions_;
		// J[
		Color4c* colors_;
		// _CfbNX
		int vertexIndexCount_;
		// _CfbNX
		u_short* vertexIndices_;
		// _obt@
		Direct3DVertexBuffer* vertexBuffer_;
		// CfbNXobt@
		Direct3DIndexBuffer* indexBuffer_;
		// t@XJEg
		int referenceCount_;
		// _obt@ɕύX
		bool vertexBufferChanged_;
		// CfbNXobt@ɕύX
		bool indexBufferChanged_;

	};

	//--------------------------------------------------------------------------
	// oϐ
	//--------------------------------------------------------------------------
	/// f[^
	Data* data_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of PRIMITIVE_DRAW_REQUEST_H_
//------------------------------------------------------------------------------
