//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * tOwb_
 * @author Junpee
 */

#ifndef VISIBILITY_H_
#define VISIBILITY_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * tO
 */
class Visibility{
public:
	//--------------------------------------------------------------------------
	/// Ȃ
	static const Visibility invisible;

	/// Ȃ
	static const Visibility understand;

	/// 
	static const Visibility visible;

	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	Visibility() : flag_(visibleValue){}

	/**
	 * Rs[RXgN^
	 * @param copy Rs[IuWFNg
	 */
	inline Visibility(const Visibility& copy) : flag_(copy.flag_){}

	/**
	 * Rs[
	 * @param copy Rs[IuWFNg
	 */
	inline void operator =(const Visibility& copy){ flag_ = copy.flag_; }

	//--------------------------------------------------------------------------
	/**
	 * ǂ
	 * @param target rΏ
	 * @return lłtrueԂ
	 */
	inline bool operator ==(const Visibility& target) const{
		return (flag_ == target.flag_);
	}

	/**
	 * łȂǂ
	 * @param target rΏ
	 * @return łȂlłtrueԂ
	 */
	inline bool operator !=(const Visibility& target) const{
		return (flag_ != target.flag_);
	}

	//--------------------------------------------------------------------------

private:
	// RXgN^
	Visibility(char flag){ flag_ = flag; }

	// tO
	char flag_;
	// Ȃ̒l
	static const char invisibleValue = 0;
	// Ȃ̒l
	static const char understandValue = 1;
	// ̒l
	static const char visibleValue = 3;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of VISIBILITY_H_
//------------------------------------------------------------------------------
