//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * _vZX^Cvwb_
 * @author Junpee
 */

#ifndef VERTEX_PROCESSING_TYPE_H_
#define VERTEX_PROCESSING_TYPE_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * _vZX^Cv
 */
class VertexProcessingType{
public:
	/// _vZX^Cv
	enum Type{
		/// \tgEFA_vZX
		software,
		/// _vZX
		mixed,
		/// n[hEFA_vZX
		hardware,
		/// sAn[hEFA_vZX
		pureHardware
	};

	/**
	 * RXgN^
	 */
	VertexProcessingType(){ type_ = software; }

	/**
	 * Rs[RXgN^
	 * @param copy Rs[
	 */
	VertexProcessingType(const VertexProcessingType& copy){
		type_ = copy.type_;
	}

	/**
	 * Rs[RXgN^
	 * @param copy Rs[
	 */
	VertexProcessingType(const Type& copy){ type_ = copy; }

	/**
	 * Rs[̉B
	 * @param copy Rs[
	 */
	void operator =(const VertexProcessingType& copy){ type_ = copy.type_; }

	/**
	 * Rs[̉B
	 * @param copy Rs[
	 */
	void operator =(const Type& copy){ type_ = copy; }

	/**
	 * 쐬tO̎擾
	 * @return 쐬tO
	 */
	u_int getCreateFlag(){
		u_int result;
		if(type_ == software){
			result = D3DCREATE_SOFTWARE_VERTEXPROCESSING;
		}else if(type_ == mixed){
			result = D3DCREATE_MIXED_VERTEXPROCESSING;
		}else if(type_ == hardware){
			result = D3DCREATE_HARDWARE_VERTEXPROCESSING;
		}else if(type_ == pureHardware){
			result = D3DCREATE_HARDWARE_VERTEXPROCESSING | D3DCREATE_PUREDEVICE;
		}
		return result;
	}

	/**
	 * ւ̕ϊ
	 * @return _vZX^Cv̕\L
	 */
	String toString(){
		if(type_ == software){ return "\tgEFA"; }
		else if(type_ == mixed){ return ""; 	}
		else if(type_ == hardware){ return "n[hEFA"; }
		else if(type_ == pureHardware){ return "sAn[hEFA"; }
		return "";
	}

	/// _vZX^Cv
	Type type_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of VERTEX_PROCESSING_TYPE_H_
//------------------------------------------------------------------------------
