//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RGB8rbgsN`wb_
 * @author Junpee
 */

#ifndef PICTURE_RGB8_H_
#define PICTURE_RGB8_H_

#include <Graphics/Picture/Picture.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * RGB8rbgsN`
 */
class PictureRGB8 : public Picture{
friend class PictureManager;
public:
	/**
	 * RGB8rbgsN`ǂ
	 * @return RGB8rbgsN`Ȃtrue
	 */
	virtual bool isPictureRGB8() const{ return true; }

	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @return Rs[ꂽsN`
	 */
	virtual Picture* copy() const{ return copyPictureRGB8(); }

	/**
	 * RGB8rbgsN`̃Rs[
	 * @return Rs[ꂽsN`
	 */
	virtual PictureRGB8* copyPictureRGB8() const;

	//--------------------------------------------------------------------------
	/**
	 * foCXIuWFNg̏
	 * @return trueԂ
	 */
	virtual bool initializeGraphicsDeviceObjects(){ return compile(); }

	/**
	 * foCXIuWFNg̍폜
	 */
	virtual void deleteGraphicsDeviceObjects(){ SafeRelease(d3dTexture_); }

	//--------------------------------------------------------------------------
	/**
	 * TCY̐ݒ
	 * @param size TCY
	 */
	virtual void setSize(const DimensionI& size);

	/**
	 * C[Wobt@̎擾
	 * @return C[Wobt@
	 */
	virtual Color3c* getImageBuffer(){ return image_; }

	//--------------------------------------------------------------------------
	/**
	 * C[W̐ݒ
	 * @param image ݒ肷C[W
	 */
	virtual void setImage(const Color3c* image);

	/**
	 * C[W̎擾
	 * @return C[W
	 */
	virtual const Color3c* getImage() const{ return image_; }

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	PictureRGB8(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~PictureRGB8();

	/**
	 * D3DeNX`̎擾
	 * @return D3DeNX`̎擾
	 */
	virtual Direct3DTexture* getD3DTexture();

	/**
	 * RpC
	 * @return trueԂ
	 */
	virtual bool compile();

	/**
	 * C[W̃RpC
	 */
	virtual bool compileImage(
		const Color3c* image, const DimensionI& size, int mipmapLevel);

	/**
	 * ~bv}bṽRpC
	 */
	virtual bool compileMipmap(
		const Color3c* image, const DimensionI& size, int mipmapLevel);

private:
	// Direct3DeNX`
	Direct3DTexture* d3dTexture_;
	// C[W
	Color3c* image_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of PICTURE_RGB8_H_
//------------------------------------------------------------------------------

