//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * sN`}l[Wwb_
 * @author Junpee
 */

#ifndef PICTURE_MANAGER_H_
#define PICTURE_MANAGER_H_

#include <Graphics/Scene/SceneObjectManagerTemplate.h>
#include <Graphics/System/GraphicsDeviceObjectHolder.h>
#include <Graphics/Picture/PictureRGB8.h>
#include <Graphics/Picture/PictureRGBA8.h>

namespace Lamp{
//------------------------------------------------------------------------------
/**
 * sN`}l[W
 */
class PictureManager : public SceneObjectManagerTemplate<Picture>,
	public GraphicsDeviceObjectHolder{
friend class Scene;
public:
	/**
	 * RGB8rbgsN`̍쐬
	 *
	 * łɓsN`̃sN`݂ƃG[ɂȂ܂B
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param pictureName sN`
	 * @return 쐬ꂽsN`
	 */
	virtual PictureRGB8* createPictureRGB8(const String& pictureName);

	/**
	 * RGBA8rbgsN`̍쐬
	 *
	 * łɓsN`̃sN`݂ƃG[ɂȂ܂B
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param pictureName sN`
	 * @return 쐬ꂽsN`
	 */
	virtual PictureRGBA8* createPictureRGBA8(const String& pictureName);

	//--------------------------------------------------------------------------
	/**
	 * foCXIuWFNg̏
	 * @return trueԂ
	 */
	virtual bool initializeGraphicsDeviceObjects();

	/**
	 * foCXIuWFNg̍폜
	 */
	virtual void deleteGraphicsDeviceObjects();

	/**
	 * foCXIuWFNg̃XgA
	 * @return trueԂ
	 */
	virtual bool restoreGraphicsDeviceObjects();

	/**
	 * foCXIuWFNg̖
	 */
	virtual void invalidateGraphicsDeviceObjects();

protected:
	/**
	 * RXgN^
	 * @param scene V[
	 */
	PictureManager(Scene* scene);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of PICTURE_MANAGER_H_
//------------------------------------------------------------------------------
