//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * sN`wb_
 * @author Junpee
 */

#ifndef PICTURE_H_
#define PICTURE_H_

#include <Graphics/Scene/SceneObject.h>
#include <Graphics/System/GraphicsDeviceObjectHolder.h>
#include <Core/Container/ArrayList.h>

namespace Lamp{

class Texture;
class PictureRGB8;
class PictureRGBA8;

//------------------------------------------------------------------------------
/**
 * sN`
 */
class Picture : public SceneObject , public GraphicsDeviceObjectHolder{
friend class SceneObjectManagerTemplate<Picture>;
friend class PictureManager;
friend class Texture;
friend class SurfaceTexture;
public:
	//--------------------------------------------------------------------------
	/**
	 * t@XJEg̎擾
	 * @return t@XJEg
	 */
	virtual int getReferenceCount() const{ return parents_.getCount(); }

	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @return Rs[ꂽsN`
	 */
	virtual Picture* copy() const = 0;

	/**
	 * j
	 * @param picture jsN`
	 * @return jIuWFNg
	 */
	static int destroy(Picture* picture);

	//--------------------------------------------------------------------------
	/**
	 * Xe[gύXtO𗧂Ă
	 */
	virtual void stateChanged();

	//--------------------------------------------------------------------------
	/**
	 * ẽTCY擾
	 * @return ẽTCY
	 */
	virtual int getParentCount() const{ return parents_.getCount(); }

	/**
	 * e̎擾
	 * @param index ẽCfbNX
	 * @return e
	 */
	virtual Texture* getParent(int index) const{
		Assert(index >= 0);
		Assert(index < getParentCount());
		return parents_.get(index);
	}

	//--------------------------------------------------------------------------
	/**
	 * pX̐ݒ
	 * @param path pX
	 */
	virtual void setPath(const String& path){
		path_ = path;
		stateChanged();
	}

	/**
	 * pX̎擾
	 * @return pX
	 */
	virtual const String& getPath() const{ return path_; }

	//--------------------------------------------------------------------------
	/**
	 * TCY̐ݒ
	 * @param size TCY
	 */
	virtual void setSize(const DimensionI& size){
		size_ = size;
		stateChanged();
	}

	/**
	 * TCY̎擾
	 * @return TCY
	 */
	virtual const DimensionI& getSize() const{ return size_; }

	//--------------------------------------------------------------------------
	/**
	 * foCXIuWFNg̏
	 * @return trueԂ
	 */
	virtual bool initializeGraphicsDeviceObjects(){ return true; }

	/**
	 * foCXIuWFNg̍폜
	 */
	virtual void deleteGraphicsDeviceObjects(){}

	/**
	 * foCXIuWFNg̃XgA
	 * @return trueԂ
	 */
	virtual bool restoreGraphicsDeviceObjects(){ return true; }

	/**
	 * foCXIuWFNg̖
	 */
	virtual void invalidateGraphicsDeviceObjects(){}

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * sN`ǂ
	 * @return sN`Ȃtrue
	 */
	virtual bool isPicture() const{ return true; }

	//--------------------------------------------------------------------------
	/**
	 * RGB8rbgsN`ǂ
	 * @return RGB8rbgsN`Ȃtrue
	 */
	virtual bool isPictureRGB8() const{ return false; }

	/**
	 * RGB8rbgsN`ւ̃LXg
	 * @return RGB8rbgsN`B^ႦNULLԂB
	 */
	virtual PictureRGB8* castPictureRGB8() const{
		if(isPictureRGB8()){ return (PictureRGB8*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * RGBA8rbgsN`ǂ
	 * @return RGBA8rbgsN`Ȃtrue
	 */
	virtual bool isPictureRGBA8() const{ return false; }

	/**
	 * RGBA8rbgsN`ւ̃LXg
	 * @return RGBA8rbgsN`B^ႦNULLԂB
	 */
	virtual PictureRGBA8* castPictureRGBA8() const{
		if(isPictureRGBA8()){ return (PictureRGBA8*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	Picture(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~Picture();

	/**
	 * sN`̒lRs[
	 * @param destination Rs[sN`
	 */
	virtual void copyPictureValue(Picture* destination) const;

	/**
	 * QƂ̒ǉ
	 * @param parent e
	 * @return QƃJEg
	 */
	virtual int addReference(Texture* parent){
		parents_.add(parent);
		return getParentCount();
	}

	/**
	 * QƂ̍폜
	 * @param parent e
	 * @return QƃJEg
	 */
	virtual int removeReference(Texture* parent){
		parents_.removeByValue(parent);
		return getParentCount();
	}

	/**
	 * D3DeNX`̎擾
	 * @return D3DeNX`̎擾
	 */
	virtual Direct3DTexture* getD3DTexture() = 0;

	//--------------------------------------------------------------------------
private:
	// ez
	ArrayList<Texture*> parents_;
	// pX
	String path_;
	// TCY
	DimensionI size_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of PICTURE_H_
//------------------------------------------------------------------------------

