//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Wfwb_
 * @author Junpee
 */

#ifndef STANDARD_MODEL_H_
#define STANDARD_MODEL_H_

#include <Graphics/Model/Model.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * Wf
 */
class StandardModel : public Model{
friend class ModelManager;
public:
	/**
	 * Wfǂ
	 * @return WfȂtrue
	 */
	virtual bool isStandardModel() const{ return true; }

	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽV[[t
	 */
	virtual SceneLeaf* copy(u_int copyMask = 0) const{
		return copyStandardModel(copyMask);
	}

	/**
	 * f̃Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽf
	 */
	virtual Model* copyModel(u_int copyMask = 0) const{
		return copyStandardModel(copyMask);
	}

	/**
	 * Wf̃Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽf
	 */
	virtual StandardModel* copyStandardModel(u_int copyMask = 0) const;

	//--------------------------------------------------------------------------
	/**
	 * bV̒ǉ
	 * @param mesh ǉ郁bV
	 */
	virtual void addMesh(Mesh* mesh);

protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	StandardModel(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~StandardModel();

	//--------------------------------------------------------------------------
private:

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of STANDARD_MODEL_H_
//------------------------------------------------------------------------------

