//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * f}l[Wwb_
 * @author Junpee
 */

#ifndef MODEL_MANAGER_H_
#define MODEL_MANAGER_H_

#include <Graphics/Scene/SceneObjectManagerTemplate.h>
#include <Graphics/Model/StandardModel.h>
#include <Graphics/Model/CharacterModel.h>

namespace Lamp{
//------------------------------------------------------------------------------
/**
 * f}l[W
 */
class ModelManager : public SceneObjectManagerTemplate<Model>{
friend class Scene;
public:
	/**
	 * Wf̍쐬
	 *
	 * łɓf̃f݂ƃG[ɂȂ܂B
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param modelName f
	 * @return 쐬ꂽf
	 */
	virtual StandardModel* createStandardModel(const String& modelName);

	/**
	 * LN^f̍쐬
	 *
	 * łɓf̃f݂ƃG[ɂȂ܂B
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param modelName f
	 * @return 쐬ꂽf
	 */
	virtual CharacterModel* createCharacterModel(const String& modelName);

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param scene V[
	 */
	ModelManager(Scene* scene);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of MODEL_MANAGER_H_
//------------------------------------------------------------------------------
