//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * fwb_
 * @author Junpee
 */

#ifndef MODEL_H_
#define MODEL_H_

#include <Graphics/SceneNode/SceneLeaf.h>
#include <Core/Container/ArrayList.h>

namespace Lamp{

class StandardModel;
class CharacterModel;

//------------------------------------------------------------------------------
/**
 * f
 */
class Model : public SceneLeaf{
friend class SceneObjectManagerTemplate<Model>;
friend class ModelManager;
public:
	//--------------------------------------------------------------------------
	/**
	 * f̃Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽf
	 */
	virtual Model* copyModel(u_int copyMask = 0) const = 0;

	/**
	 * ċAIj
	 * @param model j郂f
	 * @return jIuWFNg
	 */
	static int recursiveDestroy(Model* model);

	//--------------------------------------------------------------------------
	// bVC^[tF[X
	//--------------------------------------------------------------------------
	/**
	 * bV̒ǉ
	 * @param mesh ǉ郁bV
	 */
	virtual void addMesh(Mesh* mesh);

	/**
	 * bV̍폜
	 * @param mesh 폜郁bV
	 */
	virtual void removeMesh(Mesh* mesh);

	/**
	 * bV̎擾
	 * @return bV
	 */
	virtual int getMeshCount() const{ return meshes_.getCount(); }

	/**
	 * bV̎擾
	 * @param index CfbNX
	 * @return bV
	 */
	virtual Mesh* getMesh(int index) const{
		Assert(index >= 0);
		Assert(index < getMeshCount());
		return meshes_.get(index);
	}

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * fǂ
	 * @return fȂtrue
	 */
	virtual bool isModel() const{ return true; }

	//--------------------------------------------------------------------------
	/**
	 * Wfǂ
	 * @return WfȂtrue
	 */
	virtual bool isStandardModel() const{ return false; }

	/**
	 * Wfւ̃LXg
	 * @return WfB^ႦNULLԂB
	 */
	virtual StandardModel* castStandardModel() const{
		if(isStandardModel()){ return (StandardModel*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * LN^fǂ
	 * @return LN^fȂtrue
	 */
	virtual bool isCharacterModel() const{ return false; }

	/**
	 * LN^fւ̃LXg
	 * @return LN^fB^ႦNULLԂB
	 */
	virtual CharacterModel* castCharacterModel() const{
		if(isCharacterModel()){ return (CharacterModel*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	Model(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~Model();

	/**
	 * f̒lRs[
	 * @param destination Rs[惂f
	 * @param copyMask Rs[}XN
	 */
	virtual void copyModelValue(Model* destination, u_int copyMask) const;

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param parentMatrix es
	 * @param parentEnabled eL
	 * @param parentScaled eXP[gpĂ邩
	 * @param parentChanged eɕύX
	 */
	virtual void traverse(const Matrix34& parentMatrix, bool parentEnabled,
		bool parentScaled, bool parentChanged);

	//--------------------------------------------------------------------------
private:
	// bVz
	ArrayList<Mesh*> meshes_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of MODEL_H_
//------------------------------------------------------------------------------

