//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * LN^fwb_
 * @author Junpee
 */

#ifndef CHARACTER_MODEL_H_
#define CHARACTER_MODEL_H_

#include <Graphics/Model/Model.h>
#include <Graphics/Model/Bone.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * LN^f
 */
class CharacterModel : public Model{
friend class ModelManager;
public:
	//--------------------------------------------------------------------------
	/// ő{[
	static const int maxBoneCount = 64;

	//--------------------------------------------------------------------------
	/**
	 * LN^fǂ
	 * @return LN^fȂtrue
	 */
	virtual bool isCharacterModel() const{ return true; }

	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽV[[t
	 */
	virtual SceneLeaf* copy(u_int copyMask = 0) const{
		return copyCharacterModel(copyMask);
	}

	/**
	 * f̃Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽf
	 */
	virtual Model* copyModel(u_int copyMask = 0) const{
		return copyCharacterModel(copyMask);
	}

	/**
	 * LN^f̃Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽf
	 */
	virtual CharacterModel* copyCharacterModel(u_int copyMask = 0) const;

	//--------------------------------------------------------------------------
	/**
	 * {[s̍\z
	 * @param forceCalculation IɍČvZ
	 */
	virtual void buildBoneMatrix(bool forceCalculation = false);

	/**
	 * {[ɃXP[܂܂邩
	 * @return {[ɃXP[܂܂Ȃtrue
	 */
	virtual bool isBoneScaled() const{ return boneScaled_; }

	//--------------------------------------------------------------------------
	/**
	 * ʒuό`sz̎擾
	 * @param forceCalculation IɍČvZ
	 * @return ʒuό`sz
	 */
	virtual const Matrix34* getPositionDeformMatrixArray(
		bool forceCalculation = false);

	/**
	 * @ό`sz̎擾
	 * @param forceCalculation IɍČvZ
	 * @return @ό`sz
	 */
	virtual const Matrix33* getNormalDeformMatrixArray(
		bool forceCalculation = false);

	//--------------------------------------------------------------------------
	// {[C^[tF[X
	//--------------------------------------------------------------------------
	/**
	 * {[̍쐬
	 *
	 * {[쐬A{[Xg̍Ōɒǉ܂B
	 * łɓÕ{[݂ƃG[ɂȂ܂B
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param boneName {[
	 * @return 쐬ꂽ{[
	 */
	virtual Bone* createBone(const String& boneName);

	/**
	 * {[̔j
	 * @param bone j{[
	 */
	virtual void destroyBone(Bone* bone);

	/**
	 * {[̃NA
	 * @return 폜{[
	 */
	virtual int clearBone();

	/**
	 * {[̎擾
	 * @return {[
	 */
	virtual int getBoneCount() const{ return boneArray_.getCount(); }

	/**
	 * {[̎擾
	 * @param index {[̃CfNX
	 * @return {[
	 */
	virtual Bone* getBone(int index) const{
		Assert(index >= 0);
		Assert(index < boneArray_.getCount());
		return boneArray_.get(index);
	}

	/**
	 * {[CfbNX̎擾
	 * @param bone {[
	 * @return {[CfbNXBȂ-1
	 */
	virtual int getBoneIndex(Bone* bone) const{
		int boneCount = getBoneCount();
		for(int i = 0; i < boneCount; i++){
			if(getBone(i) == bone){ return i; }
		}
		return -1;
	}

	/**
	 * {[̌
	 * @param boneName {[
	 * @return {[
	 */
	virtual Bone* searchBone(const String& boneName) const{
		return boneHash_.get(boneName);
	}

	//--------------------------------------------------------------------------
	/**
	 * bV̒ǉ
	 * @param mesh ǉ郁bV
	 */
	virtual void addMesh(Mesh* mesh);

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	CharacterModel(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~CharacterModel();

	/**
	 * ό`sz̍\z
	 */
	virtual void buildDeformMatrixArray();

	/// {[nbV
	HashMap<String, Bone*> boneHash_;
	/// {[z
	ArrayList<Bone*> boneArray_;
	/// ʒuό`sz
	Matrix34* positionDeformMatrixArray_;
	/// @ό`sz
	Matrix33* normalDeformMatrixArray_;
	/// ό`szTCY
	int deformMatrixArraySize_;
	/// {[s̍\z`bN
	int buildBoneMatrixTick_;
	/// ό`sz`bN
	int deformMatrixArrayTick_;
	/// {[ɃXP[܂܂邩
	bool boneScaled_;

	//--------------------------------------------------------------------------
private:

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of CHARACTER_MODEL_H_
//------------------------------------------------------------------------------

