//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * {[wb_
 * @author Junpee
 */

#ifndef BONE_H_
#define BONE_H_

#include <Core/Primitive/Axis3.h>
#include <Core/Container/ArrayList.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * {[
 */
class Bone{
friend class CharacterModel;
public:
	//--------------------------------------------------------------------------
	/**
	 * [Js̎擾
	 * @return [Js
	 */
	virtual const Matrix34& getLocalMatrix(){ return axis_.getMatrix(); }

	/**
	 * fs̎擾
	 * @return fs
	 */
	virtual const Matrix34& getModelMatrix(){ return modelMatrix_; }

	/**
	 * ό`s̎擾
	 * @return ό`s
	 */
	virtual const Matrix34& getDeformMatrix(){ return deformMatrix_; }

	//--------------------------------------------------------------------------
	/**
	 * |[Yts̐ݒ
	 * @param inversePoseMatrix |[Yts
	 */
	virtual void setInversePoseMatrix(const Matrix34& inversePoseMatrix){
		inversePoseMatrix_ = inversePoseMatrix;
	}

	/**
	 * |[Yts̎擾
	 * @return |[Yts
	 */
	virtual const Matrix34& getInversePoseMatrix() const{
		return inversePoseMatrix_;
	}

	//--------------------------------------------------------------------------
	/**
	 * XP[̐ݒ
	 * @param scale XP[
	 */
	virtual void setScale(const Vector3& scale){ axis_.setScale(scale); }

	/**
	 * XP[̎擾
	 * @return XP[
	 */
	virtual const Vector3& getScale() const{ return axis_.getScale(); }

	/**
	 * XP[gpĂ邩
	 * @return XP[gpĂȂtrue
	 */
	virtual bool isScaled() const{ return axis_.isScaled(); }

	//--------------------------------------------------------------------------
	/**
	 * XYZ]̐ݒ
	 * @param rotation XYZ]
	 */
	virtual void setRotationXYZ(const Vector3& rotation){
		axis_.setRotationXYZ(rotation);
	}

	/**
	 * XYZ]̎擾
	 * @return XYZ]
	 */
	virtual const Vector3& getRotationXYZ(){
		return axis_.getRotationXYZ();
	}

	//--------------------------------------------------------------------------
	/**
	 * l]̐ݒ
	 * @param rotation l]
	 */
	virtual void setRotationQuaternion(const Quaternion& rotation){
		axis_.setRotationQuaternion(rotation);
	}

	/**
	 * l]̎擾
	 * @return l]
	 */
	virtual const Quaternion& getRotationQuaternion(){
		return axis_.getRotationQuaternion();
	}

	//--------------------------------------------------------------------------
	/**
	 * ړ̐ݒ
	 * @param translation ړ
	 */
	virtual void setTranslation(const Vector3& translation){
		axis_.setTranslation(translation);
	}

	/**
	 * ړ̎擾
	 * @return ړ
	 */
	virtual const Vector3& getTranslation() const{
		return axis_.getTranslation();
	}

	//--------------------------------------------------------------------------
	// {[C^[tF[X
	//--------------------------------------------------------------------------
	/**
	 * {[̒ǉ
	 * @param bone ǉ{[
	 */
	virtual void addBone(Bone* bone){
		bones_.add(bone);
	}

	/**
	 * {[̍폜
	 * @param bone 폜{[
	 */
	virtual void removeBone(Bone* bone){
		bones_.removeByValue(bone);
	}

	/**
	 * {[̎擾
	 * @return {[
	 */
	virtual int getBoneCount() const{ return bones_.getCount(); }

	/**
	 * {[̎擾
	 * @param index CfbNX
	 * @return {[
	 */
	virtual Bone* getBone(int index) const{
		Assert(index >= 0);
		Assert(index < getBoneCount());
		return bones_.get(index);
	}

	//--------------------------------------------------------------------------
	/**
	 * O̎擾
	 * @return O
	 */
	virtual const String& getName() const{ return name_; }

	/**
	 * {[̒lRs[
	 * @param destination Rs[{[
	 */
	virtual void copyBoneValue(Bone* destination) const;

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 */
	Bone(const String& name);

	/**
	 * fXgN^
	 */
	virtual ~Bone();

	//--------------------------------------------------------------------------
	/**
	 * {[s̍\z
	 * @param parentModelMatrix ẽfs
	 * @return XP[܂܂Ătrue
	 */
	virtual bool buildBoneMatrix(const Matrix34& parentModelMatrix);

	//--------------------------------------------------------------------------
	/// 
	Axis3 axis_;
	/// |[Yts
	Matrix34 inversePoseMatrix_;
	/// fs
	Matrix34 modelMatrix_;
	/// ό`s
	Matrix34 deformMatrix_;
	/// {[z
	ArrayList<Bone*> bones_;
	/// O
	String name_;

private:
	// Rs[RXgN^̉B
	Bone(const Bone& copy);

	// Rs[̉B
	void operator =(const Bone& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of BONE_H_
//------------------------------------------------------------------------------
