//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * bVf[^wb_
 * @author Junpee
 */

#ifndef MESH_DATA_H_
#define MESH_DATA_H_

#include <Graphics/Scene/SceneObject.h>
#include <Graphics/System/GraphicsDeviceObjectHolder.h>
#include <Core/Container/ArrayList.h>
#include <Graphics/Mesh/Mesh.h>// PrimitiveType𕪗΂͂

namespace Lamp{

class Mesh;

//------------------------------------------------------------------------------
/**
 * bVf[^
 */
class MeshData : public SceneObject , public GraphicsDeviceObjectHolder{
friend class SceneObjectManagerTemplate<MeshData>;
friend class MeshDataManager;
friend class Mesh;
public:
	/**
	 * t@XJEg̎擾
	 * @return t@XJEg
	 */
	virtual int getReferenceCount() const{ return parents_.getCount(); }

	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 */
	virtual MeshData* copy() const;

	/**
	 * j
	 * @param meshData j郁bVf[^
	 * @return jIuWFNg
	 */
	static int destroy(MeshData* meshData);

	//--------------------------------------------------------------------------
	// e
	//--------------------------------------------------------------------------
	/**
	 * ẽTCY擾
	 * @return ẽTCY
	 */
	virtual int getParentCount() const{ return parents_.getCount(); }

	/**
	 * e̎擾
	 * @param index ẽCfbNX
	 * @return e
	 */
	virtual Mesh* getParent(int index) const{
		Assert((index >= 0) && (index < getParentCount()));
		return parents_.get(index);
	}

	//--------------------------------------------------------------------------
	// oEfBO
	//--------------------------------------------------------------------------
	/**
	 * oEfBOXtBA̐ݒ
	 * @param boundingSphere ݒ肷oEfBOXtBA
	 */
	virtual void setBoundingSphere(const Sphere& boundingSphere){
		boundingSphere_ = boundingSphere;
		boundingChanged_ = true;
	}

	/**
	 * oEfBOXtBA̎擾
	 * @return oEfBOXtBA
	 */
	virtual const Sphere& getBoundingSphere() const{ return boundingSphere_; }

	//--------------------------------------------------------------------------
	/**
	 * oEfBO{bNX̐ݒ
	 * @param boundingBox ݒ肷oEfBO{bNX
	 */
	virtual void setBoundingBox(const AxisAlignedBox& boundingBox){
		boundingBox_ = boundingBox;
		boundingChanged_ = true;
	}

	/**
	 * oEfBO{bNX̎擾
	 * @return oEfBO{bNX
	 */
	virtual const AxisAlignedBox& getBoundingBox() const{ return boundingBox_; }

	//--------------------------------------------------------------------------
	/**
	 * oEfBOύXtO̎擾
	 * @return oEfBOύXtO
	 */
	virtual bool isBoundingChanged() const{ return boundingChanged_; }

	/**
	 * oEfBOύXtÕNA
	 */
	virtual void clearBoundingChanged(){ boundingChanged_ = false; }

	//--------------------------------------------------------------------------
	// v~eBu^Cv
	//--------------------------------------------------------------------------
	/**
	 * v~eBu^Cv̐ݒ
	 * @param primitiveType v~eBu^Cv
	 */
	virtual void setPrimitiveType(Mesh::PrimitiveType primitiveType);

	/**
	 * v~eBu^Cv̎擾
	 * @return v~eBu^Cv
	 */
	virtual Mesh::PrimitiveType getPrimitiveType() const{
		return primitiveType_;
	}

	/**
	 * v~eBuJEg̎擾
	 * @return v~eBuJEg
	 */
	virtual int getPrimitiveCount() const;

	/**
	 * Op̎擾
	 * @param index v~eBuCfbNX
	 * @return Op
	 */
	virtual Triangle getTriangle(int index) const;

	//--------------------------------------------------------------------------
	// CfbNX
	//--------------------------------------------------------------------------
	/**
	 * _CfbNXǂ
	 * @return _CfbNXȂtrue
	 */
	virtual bool hasVertexIndices() const{
		return Mesh::primitiveTypeHasIndex(primitiveType_);
	}

	/**
	 * _CfbNX̐ݒ
	 * @param vertexIndexCount _CfbNX
	 */
	virtual void setVertexIndexCount(int vertexIndexCount);

	/**
	 * _CfbNX̎擾
	 * @return _CfbNX
	 */
	virtual int getVertexIndexCount() const{ return vertexIndexCount_; }

	/**
	 * _CfbNX̐ݒ
	 * @param index CfbNX
	 * @param vertexIndex _CfbNX
	 */
	virtual void setVertexIndex(int index, u_short vertexIndex){
		Assert(hasVertexIndices());
		Assert((index >= 0) && (index < vertexIndexCount_));
		vertexIndexArray_[index] = vertexIndex;
		indexBufferChanged_ = true;
	}

	/**
	 * _CfbNX̎擾
	 * @param index CfbNX
	 * @return _CfbNX
	 */
	virtual u_short getVertexIndex(int index) const{
		Assert(hasVertexIndices());
		Assert((index >= 0) && (index < vertexIndexCount_));
		return vertexIndexArray_[index];
	}

	/**
	 * _CfbNXz̎擾
	 * @return _CfbNXz
	 */
	virtual const u_short* getVertexIndexArray(){ return vertexIndexArray_; }

	//--------------------------------------------------------------------------
	// _
	//--------------------------------------------------------------------------
	/**
	 * _̐ݒ
	 * @param vertexCount _
	 */
	virtual void setVertexCount(int vertexCount);

	/**
	 * _̎擾
	 * @return _
	 */
	virtual int getVertexCount() const{ return vertexCount_; }

	//--------------------------------------------------------------------------
	// ʒu
	//--------------------------------------------------------------------------
	/**
	 * ʒu̐ݒ
	 * @param index CfbNX
	 * @param position ʒu
	 */
	virtual void setPosition(int index, const Vector3& position){
		Assert((index >= 0) && (index < vertexCount_));
		positions_[index] = position;
		vertexBufferChanged_ = true;
	}

	/**
	 * ʒu̎擾
	 * @param index CfbNX
	 * @return ʒu
	 */
	virtual const Vector3& getPosition(int index) const{
		Assert((index >= 0) && (index < vertexCount_));
		return positions_[index];
	}

	/**
	 * ʒuz̎擾
	 * @return ʒuz
	 */
	virtual const Vector3* getPositionArray() const{ return positions_; }

	//--------------------------------------------------------------------------
	// @
	//--------------------------------------------------------------------------
	/**
	 * @Lɂ邩ǂ
	 * @param normalFlag trueȂ@LɂȂ
	 */
	virtual void enableNormal(bool normalFlag);

	/**
	 * @Lǂ
	 * @return @LȂtrue
	 */
	virtual bool hasNormal() const{ return normalFlag_; }

	/**
	 * @̐ݒ
	 * @param index CfbNX
	 * @param normal @
	 */
	virtual void setNormal(int index, const Vector3& normal){
		Assert(hasNormal());
		Assert((index >= 0) && (index < vertexCount_));
		normals_[index] = normal;
		vertexBufferChanged_ = true;
	}

	/**
	 * @̎擾
	 * @param index CfbNX
	 * @return @
	 */
	virtual const Vector3& getNormal(int index) const{
		Assert(hasNormal());
		Assert((index >= 0) && (index < vertexCount_));
		return normals_[index];
	}

	/**
	 * @z̎擾
	 * @return @z
	 */
	virtual const Vector3* getNormalArray() const{ return normals_; }

	//--------------------------------------------------------------------------
	// J[
	//--------------------------------------------------------------------------
	/**
	 * J[Lɂ邩ǂ
	 * @param colorFlag trueȂJ[LɂȂ
	 */
	virtual void enableColor(bool colorFlag);

	/**
	 * J[Lǂ
	 * @return J[LȂtrue
	 */
	virtual bool hasColor() const{ return colorFlag_; }

	/**
	 * J[̐ݒ
	 * @param index CfbNX
	 * @param color J[
	 */
	virtual void setColor(int index, const Color4c& color){
		Assert(hasColor());
		Assert((index >= 0) && (index < vertexCount_));
		colors_[index] = color;
		vertexBufferChanged_ = true;
	}

	/**
	 * J[̎擾
	 * @param index CfbNX
	 * @return J[
	 */
	virtual const Color4c& getColor(int index) const{
		Assert(hasColor());
		Assert((index >= 0) && (index < vertexCount_));
		return colors_[index];
	}

	/**
	 * J[z̎擾
	 * @return J[z
	 */
	virtual const Color4c* getColorArray() const{ return colors_; }

	//--------------------------------------------------------------------------
	// eNX`W
	//--------------------------------------------------------------------------
	/**
	 * eNX`WZbg̐ݒ
	 * @param texCoordSetCount eNX`WZbg
	 */
	virtual void setTexCoordSetCount(int texCoordSetCount);

	/**
	 * eNX`WZbg̐ݒ
	 * @return eNX`WZbg
	 */
	virtual int getTexCoordSetCount() const{ return texCoordSetCount_; }

	//--------------------------------------------------------------------------
	/**
	 * eNX`W^Cv̐ݒ
	 * @param texCoordSet eNX`WZbg
	 * @param texCoordType eNX`W^Cv
	 */
	virtual void setTexCoordType(int texCoordSet, TexCoord::Type texCoordType);

	/**
	 * eNX`W^Cv̎擾
	 * @param texCoordSet eNX`WZbg
	 * @return eNX`W^Cv
	 */
	virtual TexCoord::Type getTexCoordType(int texCoordSet) const{
		Assert((texCoordSet >= 0) && (texCoordSet < texCoordSetCount_));
		return texCoordTypes_[texCoordSet];
	}

	/**
	 * eNX`W^Cvz̎擾
	 * @return eNX`W^Cvz
	 */
	virtual const TexCoord::Type* getTexCoordTypeArray() const{
		return texCoordTypes_;
	}

	//--------------------------------------------------------------------------
	/**
	 * eNX`W̐ݒ
	 * @param index CfbNX
	 * @param texCoordSet eNX`WZbg
	 * @param texCoord eNX`W
	 * @param numTexCoord ̃eNX`W
	 */
	virtual void setTexCoord(
		int index, int texCoordSet, const float* texCoord, int numTexCoord){
		Assert((index >= 0) && (index < vertexCount_));
		Assert((texCoordSet >= 0) && (texCoordSet < texCoordSetCount_));
		Assert(texCoordTypes_[texCoordSet] == numTexCoord);
		float* destination = texCoords_[texCoordSet] + (index * numTexCoord);
		std::memcpy(destination, texCoord, sizeof(float) * numTexCoord);
		vertexBufferChanged_ = true;
	}

	/**
	 * eNX`Wz̎擾
	 * @return eNX`Wz
	 */
	virtual const float* const* getTexCoordArray() const{ return texCoords_; }

	/**
	 * eNX`Wz̎擾
	 * @param texCoordSet eNX`WZbg
	 * @return eNX`Wz
	 */
	virtual const float* getTexCoordArray(int texCoordSet) const{
		Assert((texCoordSet >= 0) && (texCoordSet < texCoordSetCount_));
		return texCoords_[texCoordSet];
	}

	/**
	 * eNX`WzTCY̎擾
	 * @param texCoordSet eNX`WZbg
	 * @return eNX`WzTCY
	 */
	virtual int getTexCoordArraySize(int texCoordSet) const{
		Assert((texCoordSet >= 0) && (texCoordSet < texCoordSetCount_));
		return sizeof(float) * texCoordTypes_[texCoordSet] * vertexCount_;
	}

	//--------------------------------------------------------------------------
	/**
	 * ꎟeNX`W̐ݒ
	 * @param index CfbNX
	 * @param texCoordSet eNX`WZbg
	 * @param texCoord ꎟeNX`W
	 */
	virtual void setTexCoord1(
		int index, int texCoordSet, const TexCoord1& texCoord){
		Assert((index >= 0) && (index < vertexCount_));
		Assert((texCoordSet >= 0) && (texCoordSet < texCoordSetCount_));
		Assert(texCoordTypes_[texCoordSet] == TexCoord::type1);
		((TexCoord1*)texCoords_[texCoordSet])[index] = texCoord;
		vertexBufferChanged_ = true;
	}

	/**
	 * ꎟeNX`W̎擾
	 * @param index CfbNX
	 * @param texCoordSet eNX`WZbg
	 * @return ꎟeNX`W
	 */
	virtual const TexCoord1& getTexCoord1(int index, int texCoordSet) const{
		Assert((index >= 0) && (index < vertexCount_));
		Assert((texCoordSet >= 0) && (texCoordSet < texCoordSetCount_));
		Assert(texCoordTypes_[texCoordSet] == TexCoord::type1);
		return ((TexCoord1*)texCoords_[texCoordSet])[index];
	}

	/**
	 * ꎟeNX`Wz̎擾
	 * @param texCoordSet eNX`WZbg
	 * @return ꎟeNX`Wz
	 */
	virtual const TexCoord1* getTexCoord1Array(int texCoordSet) const{
		Assert((texCoordSet >= 0) && (texCoordSet < texCoordSetCount_));
		Assert(texCoordTypes_[texCoordSet] == TexCoord::type1);
		return (TexCoord1*)texCoords_[texCoordSet];
	}

	//--------------------------------------------------------------------------
	/**
	 * 񎟌eNX`W̐ݒ
	 * @param index CfbNX
	 * @param texCoordSet eNX`WZbg
	 * @param texCoord 񎟌eNX`W
	 */
	virtual void setTexCoord2(
		int index, int texCoordSet, const TexCoord2& texCoord){
		Assert((index >= 0) && (index < vertexCount_));
		Assert((texCoordSet >= 0) && (texCoordSet < texCoordSetCount_));
		Assert(texCoordTypes_[texCoordSet] == TexCoord::type2);
		((TexCoord2*)texCoords_[texCoordSet])[index] = texCoord;
		vertexBufferChanged_ = true;
	}

	/**
	 * 񎟌eNX`W̎擾
	 * @param index CfbNX
	 * @param texCoordSet eNX`WZbg
	 * @return 񎟌eNX`W
	 */
	virtual const TexCoord2& getTexCoord2(int index, int texCoordSet) const{
		Assert((index >= 0) && (index < vertexCount_));
		Assert((texCoordSet >= 0) && (texCoordSet < texCoordSetCount_));
		Assert(texCoordTypes_[texCoordSet] == TexCoord::type2);
		return ((TexCoord2*)texCoords_[texCoordSet])[index];
	}

	/**
	 * 񎟌eNX`Wz̎擾
	 * @param texCoordSet eNX`WZbg
	 * @return 񎟌eNX`Wz
	 */
	virtual const TexCoord2* getTexCoord2Array(int texCoordSet) const{
		Assert((texCoordSet >= 0) && (texCoordSet < texCoordSetCount_));
		Assert(texCoordTypes_[texCoordSet] == TexCoord::type2);
		return (TexCoord2*)texCoords_[texCoordSet];
	}

	//--------------------------------------------------------------------------
	/**
	 * OeNX`W̐ݒ
	 * @param index CfbNX
	 * @param texCoordSet eNX`WZbg
	 * @param texCoord OeNX`W
	 */
	virtual void setTexCoord3(
		int index, int texCoordSet, const TexCoord3& texCoord){
		Assert((index >= 0) && (index < vertexCount_));
		Assert((texCoordSet >= 0) && (texCoordSet < texCoordSetCount_));
		Assert(texCoordTypes_[texCoordSet] == TexCoord::type3);
		((TexCoord3*)texCoords_[texCoordSet])[index] = texCoord;
		vertexBufferChanged_ = true;
	}

	/**
	 * OeNX`W̎擾
	 * @param index CfbNX
	 * @param texCoordSet eNX`WZbg
	 * @return OeNX`W
	 */
	virtual const TexCoord3& getTexCoord3(int index, int texCoordSet) const{
		Assert((index >= 0) && (index < vertexCount_));
		Assert((texCoordSet >= 0) && (texCoordSet < texCoordSetCount_));
		Assert(texCoordTypes_[texCoordSet] == TexCoord::type3);
		return ((TexCoord3*)texCoords_[texCoordSet])[index];
	}

	/**
	 * OeNX`Wz̎擾
	 * @param texCoordSet eNX`WZbg
	 * @return OeNX`Wz
	 */
	virtual const TexCoord3* getTexCoord3Array(int texCoordSet) const{
		Assert((texCoordSet >= 0) && (texCoordSet < texCoordSetCount_));
		Assert(texCoordTypes_[texCoordSet] == TexCoord::type3);
		return (TexCoord3*)texCoords_[texCoordSet];
	}

	//--------------------------------------------------------------------------
	/**
	 * leNX`W̐ݒ
	 * @param index CfbNX
	 * @param texCoordSet eNX`WZbg
	 * @param texCoord leNX`W
	 */
	virtual void setTexCoord4(
		int index, int texCoordSet, const TexCoord4& texCoord){
		Assert((index >= 0) && (index < vertexCount_));
		Assert((texCoordSet >= 0) && (texCoordSet < texCoordSetCount_));
		Assert(texCoordTypes_[texCoordSet] == TexCoord::type4);
		((TexCoord4*)texCoords_[texCoordSet])[index] = texCoord;
		vertexBufferChanged_ = true;
	}

	/**
	 * leNX`W̎擾
	 * @param index CfbNX
	 * @param texCoordSet eNX`WZbg
	 * @return leNX`W
	 */
	virtual const TexCoord4& getTexCoord4(int index, int texCoordSet) const{
		Assert((index >= 0) && (index < vertexCount_));
		Assert((texCoordSet >= 0) && (texCoordSet < texCoordSetCount_));
		Assert(texCoordTypes_[texCoordSet] == TexCoord::type4);
		return ((TexCoord4*)texCoords_[texCoordSet])[index];
	}

	/**
	 * leNX`Wz̎擾
	 * @param texCoordSet eNX`WZbg
	 * @return leNX`Wz
	 */
	virtual const TexCoord4* getTexCoord4Array(int texCoordSet) const{
		Assert((texCoordSet >= 0) && (texCoordSet < texCoordSetCount_));
		Assert(texCoordTypes_[texCoordSet] == TexCoord::type4);
		return (TexCoord4*)texCoords_[texCoordSet];
	}

	//--------------------------------------------------------------------------
	// {[
	//--------------------------------------------------------------------------
	/**
	 * _{[̐ݒ
	 * @param bonesPerVertex _{[
	 */
	virtual void setBonesPerVertex(int bonesPerVertex);

	/**
	 * _{[̎擾
	 * @return _{[
	 */
	virtual int getBonesPerVertex() const{ return bonesPerVertex_; }

	/**
	 * {[CfbNXLǂ
	 * @return {[CfbNXLȂtrue
	 */
	virtual bool hasBoneIndex() const{ return (bonesPerVertex_ > 0); }

	/**
	 * {[CfbNX̐ݒ
	 * @param vertexIndex _CfbNX
	 * @param boneNumber {[ԍ
	 * @param boneIndex {[CfbNX
	 */
	virtual void setBoneIndex(
		int vertexIndex, int boneNumber, u_char boneIndex){
		Assert(hasBoneIndex());
		Assert((vertexIndex >= 0) && (vertexIndex < vertexCount_));
		Assert((boneNumber >= 0) && (boneNumber < bonesPerVertex_));
		boneIndices_[vertexIndex * bonesPerVertex_ + boneNumber] =
			boneIndex;
		vertexBufferChanged_ = true;
	}

	/**
	 * {[CfbNX̐ݒ
	 * @param vertexIndex _CfbNX
	 * @param boneIndex {[CfbNX
	 */
	virtual void setBoneIndex(int vertexIndex, u_char boneIndex){
		Assert(bonesPerVertex_ == 1);
		Assert((vertexIndex >= 0) && (vertexIndex < vertexCount_));
		boneIndices_[vertexIndex] = boneIndex;
		vertexBufferChanged_ = true;
	}

	/**
	 * {[CfbNX̎擾
	 * @param vertexIndex _CfbNX
	 * @param boneNumber {[ԍ
	 * @return {[CfbNX
	 */
	virtual u_char getBoneIndex(int vertexIndex, int boneNumber) const{
		Assert(hasBoneIndex());
		Assert((vertexIndex >= 0) && (vertexIndex < vertexCount_));
		Assert((boneNumber >= 0) && (boneNumber < bonesPerVertex_));
		return boneIndices_[vertexIndex * bonesPerVertex_ + boneNumber];
	}

	/**
	 * {[CfbNX̎擾
	 * @param vertexIndex _CfbNX
	 * @return {[CfbNX
	 */
	virtual u_char getBoneIndex(int vertexIndex) const{
		Assert(bonesPerVertex_ == 1);
		Assert((vertexIndex >= 0) && (vertexIndex < vertexCount_));
		return boneIndices_[vertexIndex];
	}

	/**
	 * {[CfbNXz̎擾
	 * @return {[CfbNXz
	 */
	virtual const u_char* getBoneIndexArray() const{ return boneIndices_; }

	//--------------------------------------------------------------------------
	// EFCg
	//--------------------------------------------------------------------------
	/**
	 * _EFCg̎擾
	 * @return _EFCg
	 */
	virtual int getWeightsPerVertex() const{ return weightsPerVertex_; }

	/**
	 * EFCgLǂ
	 * @return EFCgLȂtrue
	 */
	virtual bool hasWeight() const{ return (weightsPerVertex_ > 0); }

	/**
	 * EFCg̐ݒ
	 * @param vertexIndex _CfbNX
	 * @param boneNumber {[ԍ
	 * @param weight EFCg
	 */
	virtual void setWeight(int vertexIndex, int boneNumber, float weight){
		Assert(hasWeight());
		Assert((vertexIndex >= 0) && (vertexIndex < vertexCount_));
		Assert((boneNumber >= 0) && (boneNumber < bonesPerVertex_));
		weights_[vertexIndex * weightsPerVertex_ + boneNumber] = weight;
		vertexBufferChanged_ = true;
	}

	/**
	 * EFCg̎擾
	 * @param vertexIndex _CfbNX
	 * @param boneNumber {[ԍ
	 * @return EFCg
	 */
	virtual float getWeight(int vertexIndex, int boneNumber) const{
		Assert(hasWeight());
		Assert((vertexIndex >= 0) && (vertexIndex < vertexCount_));
		Assert((boneNumber >= 0) && (boneNumber < bonesPerVertex_));
		return weights_[vertexIndex * weightsPerVertex_ + boneNumber];
	}

	/**
	 * EFCgz̎擾
	 * @return EFCgz
	 */
	virtual const float* getWeightArray() const{ return weights_; }

	//--------------------------------------------------------------------------
	// foCXIuWFNg
	//--------------------------------------------------------------------------
	/**
	 * foCXIuWFNg̏
	 * @return trueԂ
	 */
	virtual bool initializeGraphicsDeviceObjects(){ return true; }

	/**
	 * foCXIuWFNg̍폜
	 */
	virtual void deleteGraphicsDeviceObjects(){}

	/**
	 * foCXIuWFNg̃XgA
	 * @return trueԂ
	 */
	virtual bool restoreGraphicsDeviceObjects(){ return true; }

	/**
	 * foCXIuWFNg̖
	 */
	virtual void invalidateGraphicsDeviceObjects(){
		SafeRelease(indexBuffer_);
		SafeRelease(vertexBuffer_);
		vertexSize_ = 0;
		SafeRelease(vertexDeclaration_);
	}

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * bVf[^ǂ
	 * @return bVf[^Ȃtrue
	 */
	virtual bool isMeshData() const{ return true; }

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	MeshData(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~MeshData();

	/**
	 * bVf[^̒lRs[
	 * @param destination Rs[惁bVf[^
	 */
	virtual void copyMeshDataValue(MeshData* destination) const;

	//--------------------------------------------------------------------------
	// OtBbNXobt@
	//--------------------------------------------------------------------------
	/**
	 * CfbNXobt@̎擾
	 * @return CfbNXobt@
	 */
	virtual Direct3DIndexBuffer* getIndexBuffer();

	/**
	 * _Lq̎擾
	 * @return _Lq
	 */
	virtual Direct3DVertexDeclaration* getVertexDeclaration();

	/**
	 * _TCY̎擾
	 * @return _TCY
	 */
	virtual int getVertexSize();

	/**
	 * _obt@̍\z
	 * @return _obt@
	 */
	virtual Direct3DVertexBuffer* getVertexBuffer();

	//--------------------------------------------------------------------------
	/**
	 * QƂ̒ǉ
	 * @param parent e
	 * @return QƃJEg
	 */
	virtual int addReference(Mesh* parent){
		parents_.add(parent);
		return getParentCount();
	}

	/**
	 * QƂ̍폜
	 * @param parent e
	 * @return QƃJEg
	 */
	virtual int removeReference(Mesh* parent){
		parents_.removeByValue(parent);
		return getParentCount();
	}

	//--------------------------------------------------------------------------
private:
	// ez
	ArrayList<Mesh*> parents_;
	// oEfBOXtBA
	Sphere boundingSphere_;
	// oEfBO{bNX
	AxisAlignedBox boundingBox_;

	// CfbNXobt@
	Direct3DIndexBuffer* indexBuffer_;
	// _Lq
	Direct3DVertexDeclaration* vertexDeclaration_;
	// _TCY
	int vertexSize_;
	// _obt@
	Direct3DVertexBuffer* vertexBuffer_;

	// v~eBu^Cv
	Mesh::PrimitiveType primitiveType_;
	// _CfbNX
	int vertexIndexCount_;
	// _CfbNXz
	u_short* vertexIndexArray_;
	// _
	int vertexCount_;
	// ʒu
	Vector3* positions_;
	// @
	Vector3* normals_;
	// F
	Color4c* colors_;
	// eNX`WZbg
	int texCoordSetCount_;
	// eNX`W^Cv
	TexCoord::Type texCoordTypes_[TexCoord::maxSetCount];
	// eNX`W
	float* texCoords_[TexCoord::maxSetCount];
	// _{[
	int bonesPerVertex_;
	// {[CfbNX
	u_char* boneIndices_;
	// _EFCg
	int weightsPerVertex_;
	// EFCg
	float* weights_;
	// @tO
	bool normalFlag_;
	// FtO
	bool colorFlag_;
	// UVtO
	bool uvFlag_;

	// _obt@ύXtO
	bool vertexBufferChanged_;
	// CfbNXobt@ύXtO
	bool indexBufferChanged_;
	// oEfBOύXtO
	bool boundingChanged_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of MESH_DATA_H_
//------------------------------------------------------------------------------
