//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ̃bVwb_
 * @author Junpee
 */

#ifndef RIGID_MESH_H_
#define RIGID_MESH_H_

#include <Graphics/Mesh/Mesh.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * ̃bV
 */
class RigidMesh : public Mesh{
friend class MeshManager;
public:
	/**
	 * ̃bVǂ
	 * @return ̃bVȂtrue
	 */
	virtual bool isRigidMesh() const{ return true; }

	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽbV
	 */
	virtual Mesh* copy(u_int copyMask = 0) const{
		return copyRigidMesh(copyMask);
	}

	/**
	 * ̃bṼRs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽbV
	 */
	virtual RigidMesh* copyRigidMesh(u_int copyMask = 0) const;

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	RigidMesh(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~RigidMesh();

	//--------------------------------------------------------------------------
private:

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of RIGID_MESH_H_
//------------------------------------------------------------------------------

