//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * bVwb_
 * @author Junpee
 */

#ifndef MESH_H_
#define MESH_H_

#include <Graphics/Scene/SceneObject.h>
#include <Graphics/System/GraphicsDeviceObjectHolder.h>
#include <Core/Container/ArrayList.h>

namespace Lamp{

class Model;
class MeshData;
class Material;
class RigidMesh;
class CharacterMesh;

//------------------------------------------------------------------------------
/**
 * bV
 */
class Mesh : public SceneObject , public GraphicsDeviceObjectHolder{
friend class SceneObjectManagerTemplate<Mesh>;
friend class Renderer;
friend class MeshManager;
friend class Model;
friend class Shader;
friend class FixedShader;
public:
	/**
	 * t@XJEg̎擾
	 * @return t@XJEg
	 */
	virtual int getReferenceCount() const{
		if(parent_ != NULL){ return 1; }
		return 0;
	}

	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽbV
	 */
	virtual Mesh* copy(u_int copyMask = 0) const = 0;

	/**
	 * ċAIj
	 * @param mesh j郁bV
	 * @return jIuWFNg
	 */
	static int recursiveDestroy(Mesh* mesh);

	//--------------------------------------------------------------------------
	/**
	 * e̎擾
	 * @return e
	 */
	virtual Model* getParent() const{ return parent_; }

	//--------------------------------------------------------------------------
	/**
	 * O[oŃXP[gpĂ邩
	 * @return O[oŃXP[gpĂȂtrue
	 */
	virtual bool isGlobalScaled() const{ return globalScaled_; }

	/**
	 * @̐KKvƂ邩
	 * @return @̐KKvƂȂtrue
	 */
	virtual bool requireNormalize() const{ return false; }

	//--------------------------------------------------------------------------
	// oEfBOXtBA
	//--------------------------------------------------------------------------
	/**
	 * oEfBOXtBA̐ݒ
	 * @param boundingSphere ݒ肷oEfBOXtBA
	 */
	virtual void setBoundingSphere(const Sphere& boundingSphere);

	/**
	 * oEfBOXtBA̎擾
	 * @return oEfBOXtBA
	 */
	virtual const Sphere& getBoundingSphere() const;

	/**
	 * [hoEfBOXtBA̎擾
	 * @return [hoEfBOXtBA
	 */
	virtual const Sphere& getWorldBoundingSphere() const{
		return worldBoundingSphere_;
	}

	//--------------------------------------------------------------------------
	// oEfBO{bNX
	//--------------------------------------------------------------------------
	/**
	 * oEfBO{bNX̐ݒ
	 * @param boundingBox ݒ肷oEfBO{bNX
	 */
	virtual void setBoundingBox(const AxisAlignedBox& boundingBox);

	/**
	 * oEfBO{bNX̎擾
	 * @return oEfBO{bNX
	 */
	virtual const AxisAlignedBox& getBoundingBox() const;

	/**
	 * [hoEfBO{bNX̎擾
	 * @return [hoEfBO{bNX
	 */
	virtual const AxisAlignedBox& getWorldBoundingBox() const{
		return worldBoundingBox_;
	}

	//--------------------------------------------------------------------------
	// S
	//--------------------------------------------------------------------------
	/**
	 * S̎擾
	 * @return S
	 */
	virtual const Vector3& getCenter() const;

	/**
	 * [hS̎擾
	 * @return [hS
	 */
	virtual const Vector3& getWorldCenter() const{
		return worldBoundingSphere_.getCenter();
	}

	//--------------------------------------------------------------------------
	/**
	 * LA̐ݒ
	 * @param enabled trueȂLAfalseȂ疳
	 */
	virtual void setEnabled(bool enabled){ enabled_ = enabled; }

	/**
	 * LA̎擾
	 * @return trueȂLAfalseȂ疳
	 */
	virtual bool isEnabled() const{ return enabled_; }

	/**
	 * O[oł̗LA̎擾
	 * @return trueȂLAfalseȂ疳
	 */
	virtual bool isGlobalEnabled() const{ return globalEnabled_; }

	//--------------------------------------------------------------------------
	// bVf[^C^[tF[X
	//--------------------------------------------------------------------------
	/**
	 * bVf[^̐ݒ
	 * @param meshData ݒ肷郁bVf[^
	 */
	virtual void setMeshData(MeshData* meshData);

	/**
	 * bVf[^̎擾
	 * @return bVf[^
	 */
	virtual MeshData* getMeshData() const{ return meshData_; }

	/**
	 * bVf[^̍폜
	 */
	virtual void removeMeshData(){ setMeshData(NULL); }

	//--------------------------------------------------------------------------
	// }eAC^[tF[X
	//--------------------------------------------------------------------------
	/**
	 * }eA̐ݒ
	 * @param material ݒ肷}eA
	 */
	virtual void setMaterial(Material* material);

	/**
	 * }eA̎擾
	 * @return }eA
	 */
	virtual Material* getMaterial() const{ return material_; }

	/**
	 * }eA̍폜
	 */
	virtual void removeMaterial(){ setMaterial(NULL); }

	//--------------------------------------------------------------------------
	// v~eBu^Cv
	//--------------------------------------------------------------------------
	/// v~eBu^Cv
	enum PrimitiveType{
		/// gCAOXg
		triangleList = 0,
		/// CfbNXgCAOXg
		indexedTriangleList,
		/// v~eBu^Cvől
		ptMax,
	};

	/**
	 * v~eBu^CvCfbNXǂ
	 * @param primitiveType v~eBu^Cv
	 * @return v~eBu^CvCfbNXȂtrue
	 */
	static bool primitiveTypeHasIndex(PrimitiveType primitiveType);

	/**
	 * v~eBu^Cv當ւ̕ϊ
	 * @param primitiveType v~eBu^Cv
	 * @return v~eBu^Cv
	 */
	static String primitiveTypeToString(PrimitiveType primitiveType);

	/**
	 * 񂩂v~eBu^Cvւ̕ϊ
	 * @param primitiveTypeString v~eBu^Cv
	 * @return v~eBu^Cv
	 */
	static PrimitiveType primitiveTypeFromString(
		const String& primitiveTypeString);

	//--------------------------------------------------------------------------
	// bVC^[tF[X
	//--------------------------------------------------------------------------
	/**
	 * v~eBu^Cv̐ݒ
	 * @param primitiveType v~eBu^Cv
	 */
	virtual void setPrimitiveType(Mesh::PrimitiveType primitiveType);

	/**
	 * v~eBu^Cv̎擾
	 * @return v~eBu^Cv
	 */
	virtual Mesh::PrimitiveType getPrimitiveType() const;

	/**
	 * v~eBuJEg̎擾
	 * @return v~eBuJEg
	 */
	virtual int getPrimitiveCount() const;

	/**
	 * Op̎擾
	 * @param index v~eBuCfbNX
	 * @return Op
	 */
	virtual Triangle getTriangle(int index) const;

	//--------------------------------------------------------------------------
	/**
	 * _CfbNXǂ
	 * @return _CfbNXȂtrue
	 */
	virtual bool hasVertexIndices() const;

	/**
	 * _CfbNX̐ݒ
	 * @param vertexIndexCount _CfbNX
	 */
	virtual void setVertexIndexCount(int vertexIndexCount);

	/**
	 * _CfbNX̎擾
	 * @return _CfbNX
	 */
	virtual int getVertexIndexCount() const;

	/**
	 * _CfbNX̐ݒ
	 * @param index CfbNX
	 * @param vertexIndex _CfbNX
	 */
	virtual void setVertexIndex(int index, int vertexIndex);

	/**
	 * _CfbNX̎擾
	 * @param index CfbNX
	 * @return _CfbNX
	 */
	virtual int getVertexIndex(int index) const;

	/**
	 * _CfbNXz̎擾
	 * @return _CfbNXz
	 */
	virtual const u_short* getVertexIndexArray();

	//--------------------------------------------------------------------------
	/**
	 * _̐ݒ
	 * @param vertexCount _
	 */
	virtual void setVertexCount(int vertexCount);

	/**
	 * _̎擾
	 * @return _
	 */
	virtual int getVertexCount() const;

	//--------------------------------------------------------------------------
	/**
	 * ʒu̐ݒ
	 * @param index CfbNX
	 * @param position ʒu
	 */
	virtual void setPosition(int index, const Vector3& position);

	/**
	 * ʒu̎擾
	 * @param index CfbNX
	 * @return ʒu
	 */
	virtual const Vector3& getPosition(int index) const;

	/**
	 * ʒuz̎擾
	 * @return ʒuz
	 */
	virtual const Vector3* getPositionArray() const;

	//--------------------------------------------------------------------------
	/**
	 * @Lɂ邩ǂ
	 * @param normalFlag trueȂ@LɂȂ
	 */
	virtual void enableNormal(bool normalFlag);

	/**
	 * @Lǂ
	 * @return @LȂtrue
	 */
	virtual bool hasNormal() const;

	/**
	 * @̐ݒ
	 * @param index CfbNX
	 * @param normal @
	 */
	virtual void setNormal(int index, const Vector3& normal);

	/**
	 * @̎擾
	 * @param index CfbNX
	 * @return @
	 */
	virtual const Vector3& getNormal(int index) const;

	/**
	 * @z̎擾
	 * @return @z
	 */
	virtual const Vector3* getNormalArray() const;

	//--------------------------------------------------------------------------
	/**
	 * J[Lɂ邩ǂ
	 * @param colorFlag trueȂJ[LɂȂ
	 */
	virtual void enableColor(bool colorFlag);

	/**
	 * J[Lǂ
	 * @return J[LȂtrue
	 */
	virtual bool hasColor() const;

	/**
	 * J[̐ݒ
	 * @param index CfbNX
	 * @param color J[
	 */
	virtual void setColor(int index, const Color4c& color);

	/**
	 * J[̎擾
	 * @param index CfbNX
	 * @return J[
	 */
	virtual const Color4c& getColor(int index) const;

	/**
	 * J[z̎擾
	 * @return J[z
	 */
	virtual const Color4c* getColorArray() const;

	//--------------------------------------------------------------------------
	/**
	 * eNX`WZbg̐ݒ
	 * @param texCoordSetCount eNX`WZbg
	 */
	virtual void setTexCoordSetCount(int texCoordSetCount);

	/**
	 * eNX`WZbg̐ݒ
	 * @return eNX`WZbg
	 */
	virtual int getTexCoordSetCount() const;

	//--------------------------------------------------------------------------
	/**
	 * eNX`W^Cv̐ݒ
	 * @param texCoordSet eNX`WZbg
	 * @param texCoordType eNX`W^Cv
	 */
	virtual void setTexCoordType(int texCoordSet, TexCoord::Type texCoordType);

	/**
	 * eNX`W^Cv̎擾
	 * @param texCoordSet eNX`WZbg
	 * @return eNX`W^Cv
	 */
	virtual TexCoord::Type getTexCoordType(int texCoordSet) const;

	/**
	 * eNX`W^Cvz̎擾
	 * @return eNX`W^Cvz
	 */
	virtual const TexCoord::Type* getTexCoordTypeArray() const;

	//--------------------------------------------------------------------------
	/**
	 * eNX`W̐ݒ
	 * @param index CfbNX
	 * @param texCoordSet eNX`WZbg
	 * @param texCoord eNX`W
	 * @param numTexCoord ̃eNX`W
	 */
	virtual void setTexCoord(
		int index, int texCoordSet, const float* texCoord, int numTexCoord);

	/**
	 * eNX`Wz̎擾
	 * @return eNX`Wz
	 */
	virtual const float* const* getTexCoordArray() const;

	/**
	 * eNX`Wz̎擾
	 * @param texCoordSet eNX`WZbg
	 * @return eNX`Wz
	 */
	virtual const float* getTexCoordArray(int texCoordSet) const;

	/**
	 * eNX`WzTCY̎擾
	 * @param texCoordSet eNX`WZbg
	 * @return eNX`WzTCY
	 */
	virtual int getTexCoordArraySize(int texCoordSet) const;

	//--------------------------------------------------------------------------
	/**
	 * ꎟeNX`W̐ݒ
	 * @param index CfbNX
	 * @param texCoordSet eNX`WZbg
	 * @param texCoord ꎟeNX`W
	 */
	virtual void setTexCoord1(
		int index, int texCoordSet, const TexCoord1& texCoord);

	/**
	 * ꎟeNX`W̎擾
	 * @param index CfbNX
	 * @param texCoordSet eNX`WZbg
	 * @return ꎟeNX`W
	 */
	virtual const TexCoord1& getTexCoord1(int index, int texCoordSet) const;

	/**
	 * ꎟeNX`Wz̎擾
	 * @param texCoordSet eNX`WZbg
	 * @return ꎟeNX`Wz
	 */
	virtual const TexCoord1* getTexCoord1Array(int texCoordSet) const;

	//--------------------------------------------------------------------------
	/**
	 * 񎟌eNX`W̐ݒ
	 * @param index CfbNX
	 * @param texCoordSet eNX`WZbg
	 * @param texCoord 񎟌eNX`W
	 */
	virtual void setTexCoord2(
		int index, int texCoordSet, const TexCoord2& texCoord);

	/**
	 * 񎟌eNX`W̎擾
	 * @param index CfbNX
	 * @param texCoordSet eNX`WZbg
	 * @return 񎟌eNX`W
	 */
	virtual const TexCoord2& getTexCoord2(int index, int texCoordSet) const;

	/**
	 * 񎟌eNX`Wz̎擾
	 * @param texCoordSet eNX`WZbg
	 * @return 񎟌eNX`Wz
	 */
	virtual const TexCoord2* getTexCoord2Array(int texCoordSet) const;

	//--------------------------------------------------------------------------
	/**
	 * OeNX`W̐ݒ
	 * @param index CfbNX
	 * @param texCoordSet eNX`WZbg
	 * @param texCoord OeNX`W
	 */
	virtual void setTexCoord3(
		int index, int texCoordSet, const TexCoord3& texCoord);

	/**
	 * OeNX`W̎擾
	 * @param index CfbNX
	 * @param texCoordSet eNX`WZbg
	 * @return OeNX`W
	 */
	virtual const TexCoord3& getTexCoord3(int index, int texCoordSet) const;

	/**
	 * OeNX`Wz̎擾
	 * @param texCoordSet eNX`WZbg
	 * @return OeNX`Wz
	 */
	virtual const TexCoord3* getTexCoord3Array(int texCoordSet) const;

	//--------------------------------------------------------------------------
	/**
	 * leNX`W̐ݒ
	 * @param index CfbNX
	 * @param texCoordSet eNX`WZbg
	 * @param texCoord leNX`W
	 */
	virtual void setTexCoord4(
		int index, int texCoordSet, const TexCoord4& texCoord);

	/**
	 * leNX`W̎擾
	 * @param index CfbNX
	 * @param texCoordSet eNX`WZbg
	 * @return leNX`W
	 */
	virtual const TexCoord4& getTexCoord4(int index, int texCoordSet) const;

	/**
	 * leNX`Wz̎擾
	 * @param texCoordSet eNX`WZbg
	 * @return leNX`Wz
	 */
	virtual const TexCoord4* getTexCoord4Array(int texCoordSet) const;

	//--------------------------------------------------------------------------
	/**
	 * _{[̐ݒ
	 * @param bonesPerVertex _{[
	 */
	virtual void setBonesPerVertex(int bonesPerVertex);

	/**
	 * _{[̎擾
	 * @return _{[
	 */
	virtual int getBonesPerVertex() const;

	/**
	 * {[CfbNXLǂ
	 * @return {[CfbNXLȂtrue
	 */
	virtual bool hasBoneIndex() const;

	/**
	 * {[CfbNX̐ݒ
	 * @param vertexIndex _CfbNX
	 * @param boneNumber {[ԍ
	 * @param boneIndex {[CfbNX
	 */
	virtual void setBoneIndex(
		int vertexIndex, int boneNumber, u_char boneIndex);

	/**
	 * {[CfbNX̐ݒ
	 * @param vertexIndex _CfbNX
	 * @param boneIndex {[CfbNX
	 */
	virtual void setBoneIndex(int vertexIndex, u_char boneIndex);

	/**
	 * {[CfbNX̎擾
	 * @param vertexIndex _CfbNX
	 * @param boneNumber {[ԍ
	 * @return {[CfbNX
	 */
	virtual u_char getBoneIndex(int vertexIndex, int boneNumber) const;

	/**
	 * {[CfbNX̎擾
	 * @param vertexIndex _CfbNX
	 * @return {[CfbNX
	 */
	virtual u_char getBoneIndex(int vertexIndex) const;

	/**
	 * {[CfbNXz̎擾
	 * @return {[CfbNXz
	 */
	virtual const u_char* getBoneIndexArray() const;

	//--------------------------------------------------------------------------
	/**
	 * _EFCg̎擾
	 * @return _EFCg
	 */
	virtual int getWeightsPerVertex() const;

	/**
	 * EFCgLǂ
	 * @return EFCgLȂtrue
	 */
	virtual bool hasWeight() const;

	/**
	 * EFCg̐ݒ
	 * @param vertexIndex _CfbNX
	 * @param boneNumber {[ԍ
	 * @param weight EFCg
	 */
	virtual void setWeight(int vertexIndex, int boneNumber, float weight);

	/**
	 * EFCg̎擾
	 * @param vertexIndex _CfbNX
	 * @param boneNumber {[ԍ
	 * @return EFCg
	 */
	virtual float getWeight(int vertexIndex, int boneNumber) const;

	/**
	 * EFCgz̎擾
	 * @return EFCgz
	 */
	virtual const float* getWeightArray() const;

	//--------------------------------------------------------------------------
	/**
	 * foCXIuWFNg̏
	 * @return trueԂ
	 */
	virtual bool initializeGraphicsDeviceObjects(){ return true; }

	/**
	 * foCXIuWFNg̍폜
	 */
	virtual void deleteGraphicsDeviceObjects(){}

	/**
	 * foCXIuWFNg̃XgA
	 * @return trueԂ
	 */
	virtual bool restoreGraphicsDeviceObjects(){ return true; }

	/**
	 * foCXIuWFNg̖
	 */
	virtual void invalidateGraphicsDeviceObjects(){}

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * bVǂ
	 * @return bVȂtrue
	 */
	virtual bool isMesh() const{ return true; }

	//--------------------------------------------------------------------------
	/**
	 * ̃bVǂ
	 * @return ̃bVȂtrue
	 */
	virtual bool isRigidMesh() const{ return false; }

	/**
	 * ̃bVւ̃LXg
	 * @return ̃bVB^ႦNULLԂB
	 */
	virtual RigidMesh* castRigidMesh() const{
		if(isRigidMesh()){ return (RigidMesh*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * LN^bVǂ
	 * @return LN^bVȂtrue
	 */
	virtual bool isCharacterMesh() const{ return false; }

	/**
	 * LN^bVւ̃LXg
	 * @return LN^bVB^ႦNULLԂB
	 */
	virtual CharacterMesh* castCharacterMesh() const{
		if(isCharacterMesh()){ return (CharacterMesh*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	Mesh(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~Mesh();

	/**
	 * bV̒lRs[
	 * @param destination Rs[惁bV
	 * @param copyMask Rs[}XN
	 */
	virtual void copyMeshValue(Mesh* destination, u_int copyMask) const;

	//--------------------------------------------------------------------------
	// obt@ANZX
	//--------------------------------------------------------------------------
	/**
	 * CfbNXobt@̎擾
	 * @return CfbNXobt@
	 */
	virtual Direct3DIndexBuffer* getIndexBuffer();

	/**
	 * _Lq̎擾
	 * @return _Lq
	 */
	virtual Direct3DVertexDeclaration* getVertexDeclaration();

	/**
	 * _TCY̎擾
	 * @return _TCY
	 */
	virtual int getVertexSize();

	/**
	 * _obt@̍\z
	 * @return _obt@
	 */
	virtual Direct3DVertexBuffer* getVertexBuffer();

	//--------------------------------------------------------------------------
	// LN^ό`
	//--------------------------------------------------------------------------
	/**
	 * LN^ό`
	 * @return LN^ό`strue
	 */
	virtual bool characterDeform(){ return false; }

	//--------------------------------------------------------------------------
	// ό`obt@ANZX
	//--------------------------------------------------------------------------
	/**
	 * ό`_Lq̎擾
	 * @return ό`_Lq
	 */
	virtual Direct3DVertexDeclaration* getDeformedVertexDeclaration(){
		Assert(false);
		return NULL;
	}

	/**
	 * ό`_TCY̎擾
	 * @return ό`_TCY
	 */
	virtual int getDeformedVertexSize(){
		Assert(false);
		return 0;
	}

	/**
	 * ό`_obt@̍\z
	 * @return ό`_obt@
	 */
	virtual Direct3DVertexBuffer* getDeformedVertexBuffer(){
		Assert(false);
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * _Oe|f[^̐ݒ
	 * @param renderingTemporaryData _Oe|f[^
	 */
	virtual void setRenderingTemporaryData(float renderingTemporaryData){
		renderingTemporaryData_ = renderingTemporaryData;
	}

	/**
	 * _Oe|f[^̎擾
	 */
	virtual float getRenderingTemporaryData() const{
		return renderingTemporaryData_;
	}

	//--------------------------------------------------------------------------
	/**
	 * e̐ݒ
	 * @param parent ݒ肷e
	 */
	virtual void setParent(Model* parent){
		Assert(parent != NULL);
		Assert(parent_ == NULL);
		parent_ = parent;
		globalEnabled_ = false;
	}

	/**
	 * e̍폜
	 * @param parent 폜e
	 */
	virtual void removeParent(Model* parent){
		Assert(parent_ != NULL);
		Assert(parent_ == parent);
		parent_ = NULL;
		globalEnabled_ = false;
	}

protected:
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param parentMatrix es
	 * @param parentEnabled eL
	 * @param parentScaled eXP[gpĂ邩
	 * @param parentChanged eɕύX
	 */
	virtual void traverse(const Matrix34& parentMatrix, bool parentEnabled,
		bool parentScaled, bool parentChanged);

private:
	//--------------------------------------------------------------------------
	// e
	Model* parent_;
	// bVf[^
	MeshData* meshData_;
	// }eA
	Material* material_;
	// [hoEfBOXtBA
	Sphere worldBoundingSphere_;
	// [hoEfBO{bNX
	AxisAlignedBox worldBoundingBox_;
	// _Oe|f[^
	float renderingTemporaryData_;
	// LAtO
	bool enabled_;
	// O[oł̗LtO
	bool globalEnabled_;
	// O[oł̃XP[tO
	bool globalScaled_;

	// v~eBu^Cve[u
	static const String primitiveTypeStringTable[];

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of MESH_H_
//------------------------------------------------------------------------------

