//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * LN^bVwb_
 * @author Junpee
 */

#ifndef CHARACTER_MESH_H_
#define CHARACTER_MESH_H_

#include <Graphics/Mesh/Mesh.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * LN^bV
 *
 * ftH[̓\tgEFAōsBR͈ȉɁB
 * MaxVertexBlendMatrixIndex̃n[hEFAΉȂB
 * ̓_VS3ƂōseNX`ɃANZXłΉ邩B
 * }`pX_OiejsۂɕftH[sƂɂȂB
 */
class CharacterMesh : public Mesh{
friend class MeshManager;
public:
	//--------------------------------------------------------------------------
	/// ő咸_EFCg
	static const int maxWeightPerVertex = 4;

	//--------------------------------------------------------------------------
	/**
	 * LN^bVǂ
	 * @return LN^bVȂtrue
	 */
	virtual bool isCharacterMesh() const{ return true; }

	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽbV
	 */
	virtual Mesh* copy(u_int copyMask = 0) const{
		return copyCharacterMesh(copyMask);
	}

	/**
	 * LN^bṼRs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽbV
	 */
	virtual CharacterMesh* copyCharacterMesh(u_int copyMask = 0) const;

	//--------------------------------------------------------------------------
	/**
	 * @̐KKvƂ邩
	 * @return @̐KKvƂȂtrue
	 */
	virtual bool requireNormalize() const{
		// GPUŖ@̐Ks
		return true;
	}

	//--------------------------------------------------------------------------
	/**
	 * foCXIuWFNg̖
	 */
	virtual void invalidateGraphicsDeviceObjects(){
		SafeRelease(vertexBuffer_);
		SafeRelease(vertexDeclaration_);
		vertexSize_ = 0;
	}

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	CharacterMesh(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~CharacterMesh();

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param parentMatrix es
	 * @param parentEnabled eL
	 * @param parentScaled eXP[gpĂ邩
	 * @param parentChanged eɕύX
	 */
	virtual void traverse(const Matrix34& parentMatrix, bool parentEnabled,
		bool parentScaled, bool parentChanged);

	//--------------------------------------------------------------------------
	// LN^ό`
	//--------------------------------------------------------------------------
	/**
	 * LN^ό`
	 * @return LN^ό`strue
	 */
	virtual bool characterDeform();

	//--------------------------------------------------------------------------
	/**
	 * ό`
	 */
	virtual void deform();

	/**
	 * XLjOό`
	 * @param positionDeformMatrixArray ʒuό`sz
	 */
	virtual void skinningDeformP(const Matrix34* positionDeformMatrixArray);

	/**
	 * XLjOό`
	 * @param positionDeformMatrixArray ʒuό`sz
	 */
	virtual void skinningDeformPN(const Matrix34* positionDeformMatrixArray);

	/**
	 * XLjOό`
	 * @param positionDeformMatrixArray ʒuό`sz
	 * @param normalDeformMatrixArray @ό`sz
	 */
	virtual void skinningDeformPN(const Matrix34* positionDeformMatrixArray,
		const Matrix33* normalDeformMatrixArray);

	/**
	 * XeBb`Oό`
	 * @param positionDeformMatrixArray ʒuό`sz
	 */
	virtual void stitchingDeformP(const Matrix34* positionDeformMatrixArray);

	/**
	 * XeBb`Oό`
	 * @param positionDeformMatrixArray ʒuό`sz
	 */
	virtual void stitchingDeformPN(const Matrix34* positionDeformMatrixArray);

	/**
	 * XeBb`Oό`
	 * @param positionDeformMatrixArray ʒuό`sz
	 * @param normalDeformMatrixArray @ό`sz
	 */
	virtual void stitchingDeformPN(const Matrix34* positionDeformMatrixArray,
		const Matrix33* normalDeformMatrixArray);

	/**
	 * _obt@ZbgAbv
	 * @return trueԂ
	 */
	virtual bool setupVertexBuffer();

	//--------------------------------------------------------------------------
	// OtBbNXobt@
	//--------------------------------------------------------------------------
	/**
	 * _Lq̍\z
	 * @return trueԂ
	 */
	virtual bool createVertexDeclaration();


	/**
	 * _obt@̍\z
	 * @return trueԂ
	 */
	virtual bool createVertexBuffer();

	//--------------------------------------------------------------------------
	// ό`obt@ANZX
	//--------------------------------------------------------------------------
	/**
	 * ό`_Lq̎擾
	 * @return ό`_Lq
	 */
	virtual Direct3DVertexDeclaration* getDeformedVertexDeclaration(){
		if(vertexDeclaration_ == NULL){ createVertexDeclaration(); }
		return vertexDeclaration_;
	}

	/**
	 * ό`_TCY̎擾
	 * @return ό`_TCY
	 */
	virtual int getDeformedVertexSize(){
		if(vertexDeclaration_ == NULL){ createVertexDeclaration(); }
		return vertexSize_;
	}

	/**
	 * ό`_obt@̍\z
	 * @return ό`_obt@
	 */
	virtual Direct3DVertexBuffer* getDeformedVertexBuffer(){
		if(vertexBuffer_ == NULL){ createVertexBuffer(); }
		return vertexBuffer_;
	}

	//--------------------------------------------------------------------------
	/// _Lq
	Direct3DVertexDeclaration* vertexDeclaration_;
	/// _obt@
	Direct3DVertexBuffer* vertexBuffer_;
	/// _TCY
	int vertexSize_;

	/// ό`ςݒ_
	int deformedVertexCount_;
	/// ό`ς݈ʒu
	Vector3* deformedPosition_;
	/// ό`ςݖ@
	Vector3* deformedNormal_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of CHARACTER_MESH_H_
//------------------------------------------------------------------------------

