//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * }eAwb_
 * @author Junpee
 */

#ifndef MATERIAL_H_
#define MATERIAL_H_

#include <Graphics/Scene/SceneObject.h>
#include <Graphics/System/GraphicsDeviceObjectHolder.h>
#include <Core/Container/ArrayList.h>

namespace Lamp{

class Mesh;
class Texture;
class DrawRequest;
class BasicMaterial;

//------------------------------------------------------------------------------
/**
 * }eA
 */
class Material : public SceneObject , public GraphicsDeviceObjectHolder{
friend class SceneObjectManagerTemplate<Material>;
friend class MaterialManager;
friend class Mesh;
friend class Renderer;
public:
	//--------------------------------------------------------------------------
	/**
	 * t@XJEg̎擾
	 * @return t@XJEg
	 */
	virtual int getReferenceCount() const{ return parents_.getCount(); }

	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽ}eA
	 */
	virtual Material* copy(u_int copyMask = 0) const = 0;

	/**
	 * ċAIj
	 * @param material j}eA
	 * @return jIuWFNg
	 */
	static int recursiveDestroy(Material* material);

	//--------------------------------------------------------------------------
	/**
	 * Xe[gύXtO𗧂Ă
	 */
	virtual void stateChanged(){ hasStateChanged_ = true; }

	/**
	 * Xe[gύXtO̎擾
	 * @return Xe[gύXtO
	 */
	virtual bool hasStateChanged() const{ return hasStateChanged_; }

	//--------------------------------------------------------------------------
	/**
	 * e̐擾
	 * @return e̐
	 */
	virtual int getParentCount() const{ return parents_.getCount(); }

	/**
	 * e̎擾
	 * @param index ẽCfbNX
	 * @return e
	 */
	virtual Mesh* getParent(int index) const{
		Assert(index >= 0);
		Assert(index < getParentCount());
		return parents_.get(index);
	}

	//--------------------------------------------------------------------------
	/**
	 * Cggp邩
	 * @return CggpȂtrue
	 */
	virtual bool useLight() const{ return true; }

	//--------------------------------------------------------------------------
	/**
	 * Dx̐ݒ
	 * @param priority Dx
	 */
	virtual void setPriority(int priority){
		priority_ = priority;
		stateChanged();
	}

	/**
	 * Dx̎擾
	 * @return Dx
	 */
	virtual int getPriority() const{ return priority_; }

	//--------------------------------------------------------------------------
	// ufBO
	//--------------------------------------------------------------------------
	/// uh[h
	enum BlendMode{
		blendModeDisable = 0,
		blendModeAdd,
		blendModeSubtract,
		blendModeInverseSubtract,
		blendModeMinimum,
		blendModeMaximum,
		blendModeMax,
	};

	/**
	 * uh[h當ւ̕ϊ
	 * @param blendMode uh[h
	 * @return uh[h
	 */
	static const String& blendModeToString(BlendMode blendMode);

	/**
	 * 񂩂uh[hւ̕ϊ
	 * @param blendModeString uh[h
	 * @return uh[h
	 */
	static BlendMode blendModeFromString(const String& blendModeString);

	//--------------------------------------------------------------------------
	/**
	 * uh[h̐ݒ
	 * @param blendMode uh[h
	 */
	virtual void setBlendMode(BlendMode blendMode){
		blendMode_ = blendMode;
		stateChanged();
	}

	/**
	 * uh[h̎擾
	 * @return uh[h
	 */
	virtual BlendMode getBlendMode() const{ return blendMode_; }

	/**
	 * uhL
	 * @return uhLȂtrue
	 */
	virtual bool isBlendEnabled() const{
		return (blendMode_ != blendModeDisable);
	}

	//--------------------------------------------------------------------------
	/**
	 * At@̐ݒ
	 * @param alpha At@
	 */
	virtual void setAlpha(float alpha){
		alpha_ = alpha;
		stateChanged();
	}

	/**
	 * At@̎擾
	 * @return At@
	 */
	virtual float getAlpha() const{ return alpha_; }

	//--------------------------------------------------------------------------
	/// uhXe[g
	enum BlendState{
		blendStateZero = 0,
		blendStateOne,
		blendStateSourceColor,
		blendStateInverseSourceColor,
		blendStateSourceAlpha,
		blendStateInverseSourceAlpha,
		blendStateSourceAlphaSaturate,
		blendStateDestinationColor,
		blendStateInverseDestinationColor,
		blendStateDestinationAlpha,
		blendStateInverseDestinationAlpha,
		blendStateMax,
	};

	/**
	 * uhXe[g當ւ̕ϊ
	 * @param blendState uhXe[g
	 * @return uhXe[g
	 */
	static const String& blendStateToString(BlendState blendState);

	/**
	 * 񂩂uhXe[gւ̕ϊ
	 * @param blendStateString uhXe[g
	 * @return uhXe[g
	 */
	static BlendState blendStateFromString(const String& blendStateString);

	//--------------------------------------------------------------------------
	/**
	 * uh\[X̐ݒ
	 * @param blendSource uh\[X
	 */
	virtual void setBlendSource(BlendState blendSource){
		Assert(blendSource >= 0);
		Assert(blendSource < blendStateMax);
		blendSource_ = blendSource;
		stateChanged();
	}

	/**
	 * uh\[X̎擾
	 * @return uh\[X
	 */
	virtual BlendState getBlendSource() const{ return blendSource_; }

	//--------------------------------------------------------------------------
	/**
	 * uhfXeBl[V̐ݒ
	 * @param blendDestination uhfXeBl[V
	 */
	virtual void setBlendDestination(BlendState blendDestination){
		Assert(blendDestination_ >= 0);
		Assert(blendDestination_ < blendStateMax);
		blendDestination_ = blendDestination;
		stateChanged();
	}

	/**
	 * uhfXeBl[V̎擾
	 * @return uhfXeBl[V
	 */
	virtual BlendState getBlendDestination() const{
		return blendDestination_;
	}

	//--------------------------------------------------------------------------
	// ZeXg
	//--------------------------------------------------------------------------
	/**
	 * Z݂̐ݒ
	 * @param zWrite Z݂sȂtrue
	 */
	virtual void setZWrite(bool zWrite){
		zWrite_ = zWrite;
		stateChanged();
	}

	/**
	 * Z݂̎擾
	 * @return Z݂sȂtrue
	 */
	virtual bool useZWrite() const{ return zWrite_; }

	//--------------------------------------------------------------------------
	/**
	 * ZeXg̐ݒ
	 * @param zTest ZeXgsȂtrue
	 */
	virtual void setZTest(bool zTest){
		zTest_ = zTest;
		stateChanged();
	}

	/**
	 * ZeXg̎擾
	 * @return ZeXgsȂtrue
	 */
	virtual bool useZTest() const{ return zTest_; }

	//--------------------------------------------------------------------------
	// tHOIvV
	//--------------------------------------------------------------------------
	/// tHOIvV
	enum FogOption{
		fogOptionNone = 0,
		fogOptionDisable,
		fogOptionBlack,
		fogOptionMax,
	};

	/**
	 * tHOIvV當ւ̕ϊ
	 * @param fogOption tHOIvV
	 * @return tHOIvV
	 */
	static const String& fogOptionToString(FogOption fogOption);

	/**
	 * 񂩂tHOIvVւ̕ϊ
	 * @param fogOptionString tHOIvV
	 * @return tHOIvV
	 */
	static FogOption fogOptionFromString(const String& fogOptionString);

	//--------------------------------------------------------------------------
	/**
	 * tHOIvV̐ݒ
	 * @param fogOption tHOIvV
	 */
	virtual void setFogOption(FogOption fogOption){
		Assert(fogOption >= 0);
		Assert(fogOption < fogOptionMax);
		fogOption_ = fogOption;
		stateChanged();
	}

	/**
	 * tHOIvV̎擾
	 * @return tHOIvV
	 */
	virtual FogOption getFogOption() const{ return fogOption_; }

	//--------------------------------------------------------------------------
	// Cg}XN
	//--------------------------------------------------------------------------
	/**
	 * Cg}XN̐ݒ
	 * @param lightMask Cg}XN
	 */
	virtual void setLightMask(u_int lightMask){ lightMask_ = lightMask; }

	/**
	 * Cg}XN̎擾
	 * @return Cg}XN
	 */
	virtual u_int getLightMask() const{ return lightMask_; }

	//--------------------------------------------------------------------------
	// pCvC[h
	//--------------------------------------------------------------------------
	/// pCvC[h
	enum PipelineMode{
		pipelineModeNone = 0,
		pipelineModeFixed,
		pipelineModeProgrammableShader2,
	};

	/**
	 * pCvC[h̎擾
	 * @return pCvC[h
	 */
	virtual PipelineMode getPipelineMode() const{
		Assert(pipelineMode_ != pipelineModeNone);
		return pipelineMode_;
	}

	//--------------------------------------------------------------------------
	// foCXIuWFNgǗ
	//--------------------------------------------------------------------------
	/**
	 * foCXIuWFNg̏
	 * @return trueԂ
	 */
	virtual bool initializeGraphicsDeviceObjects(){ return true; }

	/**
	 * foCXIuWFNg̍폜
	 */
	virtual void deleteGraphicsDeviceObjects(){}

	/**
	 * foCXIuWFNg̃XgA
	 * @return trueԂ
	 */
	virtual bool restoreGraphicsDeviceObjects(){
		buildStateBlock(&startStateBlock_, &endStateBlock_);
		return true;
	}

	/**
	 * foCXIuWFNg̖
	 */
	virtual void invalidateGraphicsDeviceObjects(){ releaseStateBlock(); }

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * }eAǂ
	 * @return }eAȂtrue
	 */
	virtual bool isMaterial() const{ return true; }

	//--------------------------------------------------------------------------
	/**
	 * {}eAǂ
	 * @return {}eAȂtrue
	 */
	virtual bool isBasicMaterial() const{ return false; }

	/**
	 * {}eAւ̃LXg
	 * @return {}eAB^ႦNULLԂB
	 */
	virtual BasicMaterial* castBasicMaterial() const{
		if(isBasicMaterial()){ return (BasicMaterial*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	Material(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~Material();

	/**
	 * }eA̒lRs[
	 * @param destination Rs[}eA
	 */
	virtual void copyMaterialValue(Material* destination) const;

	/**
	 * q̔j
	 * @return jIuWFNg
	 */
	virtual int destroyChildren() = 0;

	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * `̃ZbgAbv
	 * @param request `惊NGXg
	 */
	virtual void drawSetup(DrawRequest* request);

	/**
	 * `
	 * @param request `惊NGXg
	 */
	virtual void draw(DrawRequest* request) = 0;

	//--------------------------------------------------------------------------
	/**
	 * Xe[gubN̍\z
	 * @param startBlock [out]JnXe[gubN
	 * @param endBlock [out]IXe[gubN
	 */
	virtual void buildStateBlock(
		Direct3DStateBlock** startBlock, Direct3DStateBlock** endBlock) = 0;

	/**
	 * Xe[gubN̉
	 */
	virtual void releaseStateBlock(){
		SafeRelease(endStateBlock_);
		SafeRelease(startStateBlock_);
	}

	/**
	 * pCvC[h̐ݒ
	 * @param pipelineMode pCvC[h
	 */
	virtual void setPipelineMode(PipelineMode pipelineMode){
		Assert(pipelineMode != pipelineModeNone);
		pipelineMode_ = pipelineMode;
	}

	//--------------------------------------------------------------------------
	/**
	 * QƂ̒ǉ
	 * @param parent e
	 * @return QƃJEg
	 */
	virtual int addReference(Mesh* parent){
		parents_.add(parent);
		return getParentCount();
	}

	/**
	 * QƂ̍폜
	 * @param parent e
	 * @return QƃJEg
	 */
	virtual int removeReference(Mesh* parent){
		parents_.removeByValue(parent);
		return getParentCount();
	}

	//--------------------------------------------------------------------------
	// eNX`t@X
	//--------------------------------------------------------------------------
	/**
	 * eNX`t@X̐ݒ
	 * @param nowTexture ݂̃eNX`
	 * @param newTexture VeNX`
	 * @return VeNX`
	 */
	virtual Texture* setTextureReferense(
		Texture* nowTexture, Texture* newTexture);

private:
	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * `̊Jn
	 */
	virtual void drawStart();

	/**
	 * `̏I
	 */
	virtual void drawEnd();

	//--------------------------------------------------------------------------
	// ez
	ArrayList<Mesh*> parents_;
	// JnXe[gubN
	Direct3DStateBlock* startStateBlock_;
	// IXe[gubN
	Direct3DStateBlock* endStateBlock_;
	// Dx
	int priority_;
	// uh[h
	BlendMode blendMode_;
	// uh\[X
	BlendState blendSource_;
	// uhfXeBl[V
	BlendState blendDestination_;
	// At@
	float alpha_;
	// tHOIvV
	FogOption fogOption_;
	// Cg}XN
	u_int lightMask_;
	// pCvC[h
	PipelineMode pipelineMode_;
	// At@uh
	bool alphaBlend_;
	// Z
	bool zWrite_;
	// ZeXg
	bool zTest_;
	// Xe[gXe[gύXtO
	bool hasStateChanged_;

	// uh[he[u
	static const String blendModeStringTable[];
	// uhXe[ge[u
	static const String blendStateStringTable[];
	// tHOIvVe[u
	static const String fogOptionStringTable[];

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of MATERIAL_H_
//------------------------------------------------------------------------------
