//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * {}eAwb_
 * @author Junpee
 */

#ifndef BASIC_MATERIAL_H_
#define BASIC_MATERIAL_H_

#include <Graphics/Material/Material.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * {}eA
 */
class BasicMaterial : public Material{
friend class MaterialManager;
public:
	/**
	 * {}eAǂ
	 * @return {}eAȂtrue
	 */
	virtual bool isBasicMaterial() const{ return true; }

	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽ}eA
	 */
	virtual Material* copy(u_int copyMask = 0) const{
		return copyBasicMaterial(copyMask);
	}

	/**
	 * {}eÃRs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽ}eA
	 */
	virtual BasicMaterial* copyBasicMaterial(u_int copyMask = 0) const;

	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * `
	 * @param request `惊NGXg
	 */
	virtual void draw(DrawRequest* request);

	//--------------------------------------------------------------------------
	// x[XeNX`C^[tF[X
	//--------------------------------------------------------------------------
	/**
	 * x[XeNX`̐ݒ
	 * @param baseTexture ݒ肷x[XeNX`
	 */
	virtual void setBaseTexture(Texture* baseTexture){
		baseTexture_ = setTextureReferense(baseTexture_, baseTexture);
	}

	/**
	 * x[XeNX`̎擾
	 * @return x[XeNX`
	 */
	virtual Texture* getBaseTexture() const{ return baseTexture_; }

	/**
	 * x[XeNX`̍폜
	 */
	virtual void removeBaseTexture(){ setBaseTexture(NULL); }

	//--------------------------------------------------------------------------
	/**
	 * x[XUVCfbNX̐ݒ
	 * @param baseUVIndex x[XUVCfbNX
	 */
	virtual void setBaseUVIndex(int baseUVIndex){
		Assert((baseUVIndex >= 0) && (baseUVIndex < 8));
		baseUVIndex_ = baseUVIndex;
	}

	/**
	 * x[XUVCfbNX̎擾
	 * @return x[XUVCfbNX
	 */
	virtual int getBaseUVIndex() const{ return baseUVIndex_; }

	//--------------------------------------------------------------------------
	// eNX`C^[tF[X
	//--------------------------------------------------------------------------
	/**
	 * eNX`̐ݒ
	 * @param glossTexture ݒ肷eNX`
	 */
	virtual void setGlossTexture(Texture* glossTexture){
		glossTexture_ = setTextureReferense(glossTexture_, glossTexture);
	}

	/**
	 * eNX`̎擾
	 * @return eNX`
	 */
	virtual Texture* getGlossTexture() const{ return glossTexture_; }

	/**
	 * eNX`̍폜
	 */
	virtual void removeGlossTexture(){ setGlossTexture(NULL); }

	//--------------------------------------------------------------------------
	/**
	 * UVCfbNX̐ݒ
	 * @param glossUVIndex UVCfbNX
	 */
	virtual void setGlossUVIndex(int glossUVIndex){
		Assert((glossUVIndex >= 0) && (glossUVIndex < 8));
		glossUVIndex_ = glossUVIndex;
	}

	/**
	 * UVCfbNX̎擾
	 * @return UVCfbNX
	 */
	virtual int getGlossUVIndex() const{ return glossUVIndex_; }

	//--------------------------------------------------------------------------
	// CgeNX`C^[tF[X
	//--------------------------------------------------------------------------
	/**
	 * CgeNX`̐ݒ
	 * @param lightTexture ݒ肷郉CgeNX`
	 */
	virtual void setLightTexture(Texture* lightTexture){
		lightTexture_ = setTextureReferense(lightTexture_, lightTexture);
	}

	/**
	 * CgeNX`̎擾
	 * @return CgeNX`
	 */
	virtual Texture* getLightTexture() const{ return lightTexture_; }

	/**
	 * CgeNX`̍폜
	 */
	virtual void removeLightTexture(){ setLightTexture(NULL); }

	//--------------------------------------------------------------------------
	/**
	 * CgUVCfbNX̐ݒ
	 * @param lightUVIndex CgUVCfbNX
	 */
	virtual void setLightUVIndex(int lightUVIndex){
		Assert((lightUVIndex >= 0) && (lightUVIndex < 8));
		lightUVIndex_ = lightUVIndex;
	}

	/**
	 * CgUVCfbNX̎擾
	 * @return CgUVCfbNX
	 */
	virtual int getLightUVIndex() const{ return lightUVIndex_; }

	//--------------------------------------------------------------------------
	// eNX`C^[tF[X
	//--------------------------------------------------------------------------
	/**
	 * eNX`̐ݒ
	 * @param stainTexture ݒ肷鉘eNX`
	 */
	virtual void setStainTexture(Texture* stainTexture){
		stainTexture_ = setTextureReferense(stainTexture_, stainTexture);
	}

	/**
	 * eNX`̎擾
	 * @return eNX`
	 */
	virtual Texture* getStainTexture() const{ return stainTexture_; }

	/**
	 * eNX`̍폜
	 */
	virtual void removeStainTexture(){ setStainTexture(NULL); }

	//--------------------------------------------------------------------------
	/**
	 * UVCfbNX̐ݒ
	 * @param stainUVIndex UVCfbNX
	 */
	virtual void setStainUVIndex(int stainUVIndex){
		Assert((stainUVIndex >= 0) && (stainUVIndex < 8));
		stainUVIndex_ = stainUVIndex;
	}

	/**
	 * UVCfbNX̎擾
	 * @return UVCfbNX
	 */
	virtual int getStainUVIndex() const{ return stainUVIndex_; }

	//--------------------------------------------------------------------------
	// fBt[Y
	//--------------------------------------------------------------------------
	/**
	 * fBt[YJ[̐ݒ
	 * @param diffuseColor fBt[YJ[
	 */
	virtual void setDiffuseColor(const Color3f& diffuseColor){
		diffuseColor_ = diffuseColor;
		stateChanged();
	}

	/**
	 * fBt[YJ[̎擾
	 * @return fBt[YJ[
	 */
	virtual const Color3f& getDiffuseColor() const{ return diffuseColor_; }

	//--------------------------------------------------------------------------
	// XyL
	//--------------------------------------------------------------------------
	/**
	 * XyLJ[̐ݒ
	 * @param specularColor XyLJ[
	 */
	virtual void setSpecularColor(const Color3f& specularColor){
		specularColor_ = specularColor;
		stateChanged();
	}

	/**
	 * XyLJ[̎擾
	 * @return XyLJ[
	 */
	virtual const Color3f& getSpecularColor() const{ return specularColor_; }

	//--------------------------------------------------------------------------
	/**
	 * XyLp[̐ݒ
	 * @param specularPower XyLp[
	 */
	virtual void setSpecularPower(float specularPower){
		specularPower_ = specularPower;
		stateChanged();
	}

	/**
	 * XyLp[̎擾
	 * @return XyLp[
	 */
	virtual float getSpecularPower() const{ return specularPower_; }

	//--------------------------------------------------------------------------
	/**
	 * XyLL
	 * @return XyLLȂtrue
	 */
	virtual bool isSpecularEnabled() const{
		return (specularColor_ != Color3f::black);
	}

	//--------------------------------------------------------------------------
	// ArGg
	//--------------------------------------------------------------------------
	/**
	 * ArGgJ[̐ݒ
	 * @param ambientColor ArGgJ[
	 */
	virtual void setAmbientColor(const Color3f& ambientColor){
		ambientColor_ = ambientColor;
		stateChanged();
	}

	/**
	 * ArGgJ[̎擾
	 * @return ArGgJ[
	 */
	virtual const Color3f& getAmbientColor() const{ return ambientColor_; }

	//--------------------------------------------------------------------------
	// G~bVu
	//--------------------------------------------------------------------------
	/**
	 * G~bVuJ[̐ݒ
	 * @param emissiveColor G~bVuJ[
	 */
	virtual void setEmissiveColor(const Color3f& emissiveColor){
		emissiveColor_ = emissiveColor;
		stateChanged();
	}

	/**
	 * G~bVuJ[̎擾
	 * @return G~bVuJ[
	 */
	virtual const Color3f& getEmissiveColor() const{ return emissiveColor_; }

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	BasicMaterial(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~BasicMaterial();

	//--------------------------------------------------------------------------
	/**
	 * q̔j
	 * @return jIuWFNg
	 */
	virtual int destroyChildren();

	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * Xe[gubN̍\z
	 * @param startBlock [out]JnXe[gubN
	 * @param endBlock [out]IXe[gubN
	 */
	virtual void buildStateBlock(
		Direct3DStateBlock** startBlock, Direct3DStateBlock** endBlock);

	//--------------------------------------------------------------------------
private:
	// x[XeNX`
	Texture* baseTexture_;
	// eNX`
	Texture* glossTexture_;
	// CgeNX`
	Texture* lightTexture_;
	// eNX`
	Texture* stainTexture_;
	// fBt[YJ[
	Color3f diffuseColor_;
	// XyLJ[
	Color3f specularColor_;
	// ArGgJ[
	Color3f ambientColor_;
	// G~bVuJ[
	Color3f emissiveColor_;
	// XyLp[
	float specularPower_;
	// x[XUVCfbNX
	int baseUVIndex_;
	// UVCfbNX
	int glossUVIndex_;
	// CgUVCfbNX
	int lightUVIndex_;
	// UVCfbNX
	int stainUVIndex_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of BASIC_MATERIAL_H_
//------------------------------------------------------------------------------
