//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * |CgCgwb_
 * @author Junpee
 */

#ifndef POINT_LIHGT_H_
#define POINT_LIHGT_H_

#include <Graphics/Light/LocalLight.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * |CgCg
 */
class PointLight : public LocalLight{
friend class LightManager;
public:
	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽV[[t
	 */
	virtual SceneLeaf* copy(u_int copyMask = 0) const{
		return copyPointLight();
	}

	/**
	 * Rs[
	 * @return Rs[ꂽCg
	 */
	virtual Light* copyLight() const{ return copyPointLight(); }

	/**
	 * |CgCg̃Rs[
	 * @return Rs[ꂽf
	 */
	virtual PointLight* copyPointLight() const;

	//--------------------------------------------------------------------------
	/**
	 * CgF̐ݒ
	 * @param color CgF
	 */
	virtual void setColor(const Color3f& color){
		diffuseColor_ = specularColor_ = color;
	}

	/**
	 * CgF̎擾
	 * @return CgF
	 */
	virtual Color3f getColor() const{
		Color3f result(Math::maximum(diffuseColor_.r, specularColor_.r),
			Math::maximum(diffuseColor_.g, specularColor_.g),
			Math::maximum(diffuseColor_.b, specularColor_.b));
		return result;
	}

	//--------------------------------------------------------------------------
	/**
	 * fBt[YCgF̐ݒ
	 * @param color fBt[YCgF
	 */
	virtual void setDiffuseColor(const Color3f& color){ diffuseColor_ = color; }

	/**
	 * fBt[YCgF̎擾
	 * @return fBt[YCgF
	 */
	virtual const Color3f& getDiffuseColor() const{ return diffuseColor_; }

	//--------------------------------------------------------------------------
	/**
	 * XyLCgF̐ݒ
	 * @param color XyLCgF
	 */
	virtual void setSpecularColor(const Color3f& color){
		specularColor_ = color;
	}

	/**
	 * XyLCgF̎擾
	 * @return XyLCgF
	 */
	virtual const Color3f& getSpecularColor() const{ return specularColor_; }

	//--------------------------------------------------------------------------
	/**
	 * Cg̈ʒuݒ
	 * @param position Cg̈ʒu
	 */
	virtual void setPosition(const Vector3& position){ position_ = position; }

	/**
	 * Cg̃[hʒu擾
	 * @return Cg̃[hʒu
	 */
	virtual const Vector3& getPosition() const{ return position_; }

	/**
	 * Cg̃[hʒu擾
	 * @return Cg̃[hʒu
	 */
	virtual const Vector3& getWorldPosition() const{
		Assert(getParent() != NULL);
		return worldPosition_;
	}

	//--------------------------------------------------------------------------
	/**
	 * W̐ݒ
	 * @param range W
	 */
	virtual void setRange(float range){ range_ = range; }

	/**
	 * W̎擾
	 * @return W
	 */
	virtual float getRange() const{ return range_; }

	/**
	 * O[oW̎擾
	 * @return O[oW
	 */
	virtual float getGlobalRange() const{ return globalRange_; }

	//--------------------------------------------------------------------------
	/**
	 * W̐ݒ
	 * @param attenuation0 W0
	 * @param attenuation1 W1
	 * @param attenuation2 W2
	 */
	virtual void setAttenuation(
		float attenuation0, float attenuation1, float attenuation2){
		attenuation0_ = attenuation0;
		attenuation1_ = attenuation1;
		attenuation2_ = attenuation2;
	}

	//--------------------------------------------------------------------------
	/**
	 * W0̐ݒ
	 * @param attenuation0 W0
	 */
	virtual void setAttenuation0(float attenuation0){
		attenuation0_ = attenuation0;
	}

	/**
	 * W0̎擾
	 * @return W0
	 */
	virtual float getAttenuation0() const{ return attenuation0_; }

	//--------------------------------------------------------------------------
	/**
	 * W1̐ݒ
	 * @param attenuation1 W1
	 */
	virtual void setAttenuation1(float attenuation1){
		attenuation1_ = attenuation1;
	}

	/**
	 * W1̎擾
	 * @return W1
	 */
	virtual float getAttenuation1() const{ return attenuation1_; }

	//--------------------------------------------------------------------------
	/**
	 * W2̐ݒ
	 * @param attenuation2 W2
	 */
	virtual void setAttenuation2(float attenuation2){
		attenuation2_ = attenuation2;
	}

	/**
	 * W2̎擾
	 * @return W2
	 */
	virtual float getAttenuation2() const{ return attenuation2_; }

	//--------------------------------------------------------------------------
	/**
	 * JƂ̋2̐ݒ
	 * @param squaredCameraDistance JƂ̋2
	 */
	virtual void setSquaredCameraDistance(float squaredCameraDistance){
		squaredCameraDistance_ = squaredCameraDistance;
	}

	/**
	 * JƂ̋2̎擾
	 * @return JƂ̋2
	 */
	virtual float getSquaredCameraDistance() const{
		return squaredCameraDistance_;
	}

	//--------------------------------------------------------------------------
	/**
	 * |CgCgǂ
	 * @return |CgCgȂtrue
	 */
	virtual bool isPointLight() const{ return true; }

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	PointLight(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~PointLight();

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param parentMatrix es
	 * @param parentEnabled eL
	 * @param parentScaled eXP[gpĂ邩
	 * @param parentChanged eɕύX
	 */
	virtual void traverse(const Matrix34& parentMatrix, bool parentEnabled,
		bool parentScaled, bool parentChanged);

	//--------------------------------------------------------------------------
private:
	// fBt[YJ[
	Color3f diffuseColor_;
	// XyLJ[
	Color3f specularColor_;
	// ʒu
	Vector3 position_;
	// [hʒu
	Vector3 worldPosition_;
	// W
	float range_;
	// O[oW
	float globalRange_;
	// W0
	float attenuation0_;
	// W1
	float attenuation1_;
	// W2
	float attenuation2_;
	// JƂ̋2
	float squaredCameraDistance_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of POINT_LIHGT_H_
//------------------------------------------------------------------------------

