//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * [JCgwb_
 * @author Junpee
 */

#ifndef LOCAL_LIGHT_H_
#define LOCAL_LIGHT_H_

#include <Graphics/Light/Light.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * [JCg
 */
class LocalLight : public Light{
friend class SceneObjectManagerTemplate<Light>;
friend class LightManager;
public:

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * [JCgǂ
	 * @return [JCgȂtrue
	 */
	virtual bool isLocalLight() const{ return true; }

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	LocalLight(const String& name, Scene* scene) : Light(name, scene){}

	/**
	 * fXgN^
	 */
	virtual ~LocalLight(){}

	//--------------------------------------------------------------------------
private:

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of LOCAL_LIGHT_H_
//------------------------------------------------------------------------------
