//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Cg}l[Wwb_
 * @author Junpee
 */

#ifndef LIGHT_MANAGER_H_
#define LIGHT_MANAGER_H_

#include <Graphics/Scene/SceneObjectManagerTemplate.h>
#include <Graphics/Light/AmbientLight.h>
#include <Graphics/Light/DirectionalLight.h>
#include <Graphics/Light/PointLight.h>

namespace Lamp{
//------------------------------------------------------------------------------
/**
 * Cg}l[W
 */
class LightManager : public SceneObjectManagerTemplate<Light>{
friend class Scene;
public:
	/**
	 * ArGgCg̍쐬
	 *
	 * łɓCg̃Cg݂ƃG[ɂȂ܂B
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param lightName Cg
	 * @return 쐬ꂽCg
	 */
	virtual AmbientLight* createAmbientLight(const String& lightName);

	/**
	 * fBNViCg̍쐬
	 *
	 * łɓCg̃Cg݂ƃG[ɂȂ܂B
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param lightName Cg
	 * @return 쐬ꂽCg
	 */
	virtual DirectionalLight* createDirectionalLight(const String& lightName);

	/**
	 * |CgCg̍쐬
	 *
	 * łɓCg̃Cg݂ƃG[ɂȂ܂B
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param lightName Cg
	 * @return 쐬ꂽCg
	 */
	virtual PointLight* createPointLight(const String& lightName);

protected:
	/**
	 * RXgN^
	 * @param scene V[
	 */
	LightManager(Scene* scene);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of LIGHT_MANAGER_H_
//------------------------------------------------------------------------------
