//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Cgwb_
 * @author Junpee
 */

#ifndef LIGHT_H_
#define LIGHT_H_

#include <Graphics/SceneNode/SceneLeaf.h>

namespace Lamp{

class GlobalLight;
class LocalLight;
class AmbientLight;
class DirectionalLight;
class PointLight;

//------------------------------------------------------------------------------
/**
 * Cg
 */
class Light : public SceneLeaf{
friend class SceneObjectManagerTemplate<Light>;
friend class LightManager;
public:
	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @return Rs[ꂽCg
	 */
	virtual Light* copyLight() const = 0;

	/**
	 * j
	 * @param light j郉Cg
	 * @return jIuWFNg
	 */
	static int destroy(Light* light);

	//--------------------------------------------------------------------------
	/**
	 * CgF̐ݒ
	 * @param color CgF
	 */
	virtual void setColor(const Color3f& color) = 0;

	/**
	 * CgF̎擾
	 * @return CgF
	 */
	virtual Color3f getColor() const = 0;

	//--------------------------------------------------------------------------
	/**
	 * Px̎擾
	 * @return Px
	 */
	virtual float getLuminance() const{ return getColor().getLuminance(); }

	//--------------------------------------------------------------------------
	/**
	 * Cg}XN̐ݒ
	 * @param lightMask Cg}XN
	 */
	virtual void setLightMask(u_int lightMask){ lightMask_ = lightMask; }

	/**
	 * Cg}XN̎擾
	 * @return Cg}XN
	 */
	virtual u_int getLightMask() const{ return lightMask_; }

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * Cgǂ
	 * @return CgȂtrue
	 */
	virtual bool isLight() const{ return true; }

	//--------------------------------------------------------------------------
	/**
	 * O[oCgǂ
	 * @return O[oCgȂtrue
	 */
	virtual bool isGlobalLight() const{ return false; }

	/**
	 * O[oCgւ̃LXg
	 * @return O[oCgB^ႦNULLԂB
	 */
	virtual GlobalLight* castGlobalLight() const{
		if(isGlobalLight()){ return (GlobalLight*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * [JCgǂ
	 * @return [JCgȂtrue
	 */
	virtual bool isLocalLight() const{ return false; }

	/**
	 * [JCgւ̃LXg
	 * @return [JCgB^ႦNULLԂB
	 */
	virtual LocalLight* castLocalLight() const{
		if(isLocalLight()){ return (LocalLight*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * ArGgCgǂ
	 * @return ArGgCgȂtrue
	 */
	virtual bool isAmbientLight() const{ return false; }

	/**
	 * ArGgCgւ̃LXg
	 * @return ArGgCgB^ႦNULLԂB
	 */
	virtual AmbientLight* castAmbientLight() const{
		if(isAmbientLight()){ return (AmbientLight*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * fBNViCgǂ
	 * @return fBNViCgȂtrue
	 */
	virtual bool isDirectionalLight() const{ return false; }

	/**
	 * fBNViCgւ̃LXg
	 * @return fBNViCgB^ႦNULLԂB
	 */
	virtual DirectionalLight* castDirectionalLight() const{
		if(isDirectionalLight()){ return (DirectionalLight*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * |CgCgǂ
	 * @return |CgCgȂtrue
	 */
	virtual bool isPointLight() const{ return false; }

	/**
	 * |CgCgւ̃LXg
	 * @return |CgCgB^ႦNULLԂB
	 */
	virtual PointLight* castPointLight() const{
		if(isPointLight()){ return (PointLight*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	Light(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~Light();

	/**
	 * Cg̒lRs[
	 * @param destination Rs[惉Cg
	 */
	virtual void copyLightValue(Light* destination) const;

	//--------------------------------------------------------------------------
private:
	// Cg}XN
	u_int lightMask_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of LIGHT_H_
//------------------------------------------------------------------------------

