//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * fBNViCgwb_
 * @author Junpee
 */

#ifndef DIRECTIONAL_LIHGT_H_
#define DIRECTIONAL_LIHGT_H_

#include <Graphics/Light/GlobalLight.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * fBNViCg
 */
class DirectionalLight : public GlobalLight{
friend class LightManager;
public:
	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽV[[t
	 */
	virtual SceneLeaf* copy(u_int copyMask = 0) const{
		return copyDirectionalLight();
	}

	/**
	 * Rs[
	 * @return Rs[ꂽCg
	 */
	virtual Light* copyLight() const{ return copyDirectionalLight(); }

	/**
	 * fBNViCg̃Rs[
	 * @return Rs[ꂽf
	 */
	virtual DirectionalLight* copyDirectionalLight() const;

	//--------------------------------------------------------------------------
	/**
	 * CgF̐ݒ
	 * @param color CgF
	 */
	virtual void setColor(const Color3f& color){
		diffuseColor_ = specularColor_ = color;
	}

	/**
	 * CgF̎擾
	 * @return CgF
	 */
	virtual Color3f getColor() const{
		Color3f result(Math::maximum(diffuseColor_.r, specularColor_.r),
			Math::maximum(diffuseColor_.g, specularColor_.g),
			Math::maximum(diffuseColor_.b, specularColor_.b));
		return result;
	}

	//--------------------------------------------------------------------------
	/**
	 * fBt[YCgF̐ݒ
	 * @param color fBt[YCgF
	 */
	virtual void setDiffuseColor(const Color3f& color){ diffuseColor_ = color; }

	/**
	 * fBt[YCgF̎擾
	 * @return fBt[YCgF
	 */
	virtual const Color3f& getDiffuseColor() const{ return diffuseColor_; }

	//--------------------------------------------------------------------------
	/**
	 * XyLCgF̐ݒ
	 * @param color XyLCgF
	 */
	virtual void setSpecularColor(const Color3f& color){
		specularColor_ = color;
	}

	/**
	 * XyLCgF̎擾
	 * @return XyLCgF
	 */
	virtual const Color3f& getSpecularColor() const{ return specularColor_; }

	//--------------------------------------------------------------------------
	/**
	 * Cg̕ݒ
	 * @param direction Cg̕
	 */
	virtual void setDirection(const Vector3& direction){
		direction_ = direction;
		// KĂ
		direction_.normalize();
	}

	/**
	 * Cg̕擾
	 * @return Cg̕
	 */
	virtual const Vector3& getDirection() const{ return direction_; }

	/**
	 * Cg̃[h擾
	 * @return Cg̃[h
	 */
	virtual const Vector3& getWorldDirection() const{
		Assert(getParent() != NULL);
		return worldDirection_;
	}

	//--------------------------------------------------------------------------
	/**
	 * fBNViCgǂ
	 * @return fBNViCgȂtrue
	 */
	virtual bool isDirectionalLight() const{ return true; }

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	DirectionalLight(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~DirectionalLight();

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param parentMatrix es
	 * @param parentEnabled eL
	 * @param parentScaled eXP[gpĂ邩
	 * @param parentChanged eɕύX
	 */
	virtual void traverse(const Matrix34& parentMatrix, bool parentEnabled,
		bool parentScaled, bool parentChanged);

	//--------------------------------------------------------------------------
private:
	// fBt[YJ[
	Color3f diffuseColor_;
	// XyLJ[
	Color3f specularColor_;
	// 
	Vector3 direction_;
	// [h
	Vector3 worldDirection_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of DIRECTIONAL_LIHGT_H_
//------------------------------------------------------------------------------

