//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ArGgCgwb_
 * @author Junpee
 */

#ifndef AMBIENT_LIHGT_H_
#define AMBIENT_LIHGT_H_

#include <Graphics/Light/GlobalLight.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * ArGgCg
 */
class AmbientLight : public GlobalLight{
friend class LightManager;
public:
	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽV[[t
	 */
	virtual SceneLeaf* copy(u_int copyMask = 0) const{
		return copyAmbientLight();
	}

	/**
	 * Rs[
	 * @return Rs[ꂽCg
	 */
	virtual Light* copyLight() const{ return copyAmbientLight(); }

	/**
	 * ArGgCg̃Rs[
	 * @return Rs[ꂽf
	 */
	virtual AmbientLight* copyAmbientLight() const;

	//--------------------------------------------------------------------------
	/**
	 * CgF̐ݒ
	 * @param color CgF
	 */
	virtual void setColor(const Color3f& color){ color_ = color; }

	/**
	 * CgF̎擾
	 * @return CgF
	 */
	virtual Color3f getColor() const{ return color_; }

	//--------------------------------------------------------------------------
	/**
	 * ArGgCgǂ
	 * @return ArGgCgȂtrue
	 */
	virtual bool isAmbientLight() const{ return true; }

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	AmbientLight(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~AmbientLight();

	//--------------------------------------------------------------------------
private:
	// J[
	Color3f color_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of AMBIENT_LIHGT_H_
//------------------------------------------------------------------------------

