//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eLXgV[Z[owb_
 * @author Junpee
 */

#ifndef TEXT_SCENE_SAVER_H_
#define TEXT_SCENE_SAVER_H_

namespace Lamp{

class TextWriter;
class Scene;
class Fog;
class SceneNodeManager;
class LightManager;
class ModelManager;
class MeshManager;
class MeshDataManager;
class MaterialManager;
class TextureManager;
class PictureManager;

class SceneNode;
class LODSceneNode;
class Light;
class AmbientLight;
class DirectionalLight;
class PointLight;
class Model;
class StandardModel;
class CharacterModel;
class Bone;
class Mesh;
class RigidMesh;
class CharacterMesh;
class MeshData;
class Material;
class BasicMaterial;
class Texture;
class SurfaceTexture;
class Picture;

//------------------------------------------------------------------------------
/**
 * eLXgV[Z[o
 */
class TextSceneSaver{
public:
	/**
	 * RXgN^
	 */
	TextSceneSaver();

	/**
	 * fXgN^
	 */
	virtual ~TextSceneSaver();

	/**
	 * Z[u
	 * @param filePath t@CpX
	 * @param scene Z[uV[
	 */
	virtual void save(const String& filePath, Scene* scene);

	/**
	 * Z[u
	 * @param textWriter eLXgC^
	 * @param scene Z[uV[
	 * @param basePath x[XpX
	 */
	virtual void save(TextWriter* textWriter, Scene* scene,
		const String& basePath = "");

protected:
	/**
	 * wb_̏o
	 */
	virtual void writeHeader();

	/**
	 * IuWFNgXg̏o
	 * @return IuWFNg
	 */
	virtual int writeObjectList();

	/**
	 * N̏o
	 * @param objectCount IuWFNg
	 */
	virtual void writeLink(int objectCount);

	//--------------------------------------------------------------------------
	// tHO
	//--------------------------------------------------------------------------
	/**
	 * tHȌo
	 * @param fog tHO
	 */
	virtual void writeFog(Fog* fog);

	//--------------------------------------------------------------------------
	// V[m[h
	//--------------------------------------------------------------------------
	/**
	 * V[m[hXg̏o
	 */
	virtual void writeSceneNodeList();

	/**
	 * V[m[h̏o
	 * @param sceneNode oV[m[h
	 */
	virtual void writeSceneNode(SceneNode* sceneNode);

	/**
	 * xIufBeB[V[m[h̏o
	 * @param sceneNode oxIufBeB[V[m[h
	 */
	virtual void writeLODSceneNode(LODSceneNode* sceneNode);

	//--------------------------------------------------------------------------
	// Cg
	//--------------------------------------------------------------------------
	/**
	 * CgXg̏o
	 */
	virtual void writeLightList();

	/**
	 * Cg̏o
	 * @param light oCg
	 */
	virtual void writeLight(Light* light);

	/**
	 * ArGgCg̏o
	 * @param light oCg
	 */
	virtual void writeAmbientLight(AmbientLight* light);

	/**
	 * fBNViCg̏o
	 * @param light oCg
	 */
	virtual void writeDirectionalLight(DirectionalLight* light);

	/**
	 * |CgCg̏o
	 * @param light oCg
	 */
	virtual void writePointLight(PointLight* light);

	//--------------------------------------------------------------------------
	// f
	//--------------------------------------------------------------------------
	/**
	 * fXg̏o
	 */
	virtual void writeModelList();

	/**
	 * Wf̏o
	 * @param model of
	 */
	virtual void writeStandardModel(StandardModel* model);

	/**
	 * LN^f̏o
	 * @param model of
	 */
	virtual void writeCharacterModel(CharacterModel* model);

	/**
	 * {[̏o
	 * @param bone o{[
	 */
	virtual void writeBone(Bone* bone);

	/**
	 * {[N̏o
	 * @param bone o{[
	 */
	virtual void writeBoneLink(Bone* bone);

	//--------------------------------------------------------------------------
	// bV
	//--------------------------------------------------------------------------
	/**
	 * bVXg̏o
	 */
	virtual void writeMeshList();

	/**
	 * ̃bV̏o
	 * @param mesh obV
	 */
	virtual void writeRigidMesh(RigidMesh* mesh);

	/**
	 * LN^bV̏o
	 * @param mesh obV
	 */
	virtual void writeCharacterMesh(CharacterMesh* mesh);

	//--------------------------------------------------------------------------
	// bVf[^
	//--------------------------------------------------------------------------
	/**
	 * bVf[^Xg̏o
	 */
	virtual void writeMeshDataList();

	/**
	 * bVf[^̏o
	 * @param meshData obVf[^
	 */
	virtual void writeMeshData(MeshData* meshData);

	//--------------------------------------------------------------------------
	// }eA
	//--------------------------------------------------------------------------
	/**
	 * }eAXg̏o
	 */
	virtual void writeMaterialList();

	/**
	 * }eȀo
	 * @param material o}eA
	 */
	virtual void writeMaterial(const Material* material);

	/**
	 * {}eȀo
	 * @param material o}eA
	 */
	virtual void writeBasicMaterial(const BasicMaterial* material);

	//--------------------------------------------------------------------------
	// eNX`
	//--------------------------------------------------------------------------
	/**
	 * eNX`Xg̏o
	 */
	virtual void writeTextureList();

	/**
	 * T[tF[XeNX`̏o
	 * @param texture oeNX`
	 */
	virtual void writeSurfaceTexture(const SurfaceTexture* texture);

	//--------------------------------------------------------------------------
	// sN`
	//--------------------------------------------------------------------------
	/**
	 * sN`̏o
	 * @param picture osN`
	 */
	virtual void writePicture(const Picture* picture);

	//--------------------------------------------------------------------------
	// N
	//--------------------------------------------------------------------------
	/**
	 * V[m[hN̏o
	 * @param sceneNode oV[m[h
	 */
	virtual void writeSceneNodeLink(SceneNode* sceneNode);

	/**
	 * fN̏o
	 * @param model of
	 */
	virtual void writeModelLink(const Model* model);

	/**
	 * bVN̏o
	 * @param mesh obV
	 */
	virtual void writeMeshLink(const Mesh* mesh);

	/**
	 * }eANXg̏o
	 */
	virtual void writeMaterialLinkList();

	/**
	 * {}eAN̏o
	 * @param material o}eA
	 */
	virtual void writeBasicMaterialLink(const BasicMaterial* material);

	/**
	 * eNX`N̏o
	 * @param texture oeNX`
	 */
	virtual void writeTextureLink(const Texture* texture);

	//--------------------------------------------------------------------------
	// [eBeB
	//--------------------------------------------------------------------------
	/**
	 * bool̏o
	 */
	virtual void writeBool(bool);

	/**
	 * Rg̏o
	 */
	virtual void writeLineComment();

	/**
	 * ubNRg̏o
	 * @param blockName ubN
	 */
	virtual void writeBlockComment(const String& blockName);

	/// C^
	TextWriter* writer_;
	/// x[XpX
	String basePath_;
	/// V[
	Scene* scene_;
	/// V[m[h}l[W
	SceneNodeManager* sceneNodeManager_;
	/// Cg}l[W
	LightManager* lightManager_;
	/// f}l[W
	ModelManager* modelManager_;
	/// bV}l[W
	MeshManager* meshManager_;
	/// bVf[^}l[W
	MeshDataManager* meshDataManager_;
	/// }eA}l[W
	MaterialManager* materialManager_;
	/// eNX`}l[W
	TextureManager* textureManager_;
	/// sN`}l[W
	PictureManager* pictureManager_;

private:
	// Rs[RXgN^̉B
	TextSceneSaver(const TextSceneSaver& copy);

	// Rs[̉B
	void operator =(const TextSceneSaver& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TEXT_SCENE_SAVER_H_
//------------------------------------------------------------------------------
