//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eLXgV[[_wb_
 * @author Junpee
 */

#ifndef TEXT_SCENE_LOADER_H_
#define TEXT_SCENE_LOADER_H_

namespace Lamp{

class TextReader;
class TargaLoader;
class StreamTokenizer;
class Scene;
class SceneNodeManager;
class SceneNode;
class LightManager;
class Light;
class ModelManager;
class CharacterModel;
class MeshManager;
class MeshDataManager;
class MeshData;
class MaterialManager;
class Material;
class TextureManager;
class PictureManager;
class Picture;

//------------------------------------------------------------------------------
/**
 * eLXgV[[_
 */
class TextSceneLoader{
public:
	/**
	 * RXgN^
	 */
	TextSceneLoader();

	/**
	 * fXgN^
	 */
	virtual ~TextSceneLoader();

	/**
	 * [h
	 * @param filePath t@CpX
	 * @param scene [hV[
	 */
	virtual void load(const String& filePath, Scene* scene);

	/**
	 * [h
	 * @param filePath t@CpX
	 * @param scene [hV[
	 * @param rootNode [h惋[gm[h
	 */
	virtual void load(const String& filePath, Scene* scene,
		SceneNode* rootNode);

	/**
	 * [h
	 * @param textReader eLXg[_
	 * @param scene [hV[
	 * @param basePath x[XpX
	 */
	virtual void load(TextReader* textReader, Scene* scene,
		const String& basePath = "");

	/**
	 * [h
	 * @param textReader eLXg[_
	 * @param scene [hV[
	 * @param rootNode [h惋[gm[h
	 * @param basePath x[XpX
	 */
	virtual void load(TextReader* textReader, Scene* scene,
		SceneNode* rootNode, const String& basePath = "");

protected:
	/**
	 * wb_̓ǂݍ
	 */
	virtual void readHeader();

	//--------------------------------------------------------------------------
	// tHO
	//--------------------------------------------------------------------------
	/**
	 * tHO̓ǂݍ
	 */
	virtual void readFog();

	//--------------------------------------------------------------------------
	// V[m[h
	//--------------------------------------------------------------------------
	/**
	 * V[m[hXg̓ǂݍ
	 */
	virtual void readSceneNodeList();

	/**
	 * V[m[h̓ǂݍ
	 * @param name O
	 */
	virtual void readSceneNode(const String& name);

	/**
	 * xIufBeB[V[m[h̓ǂݍ
	 * @param name O
	 */
	virtual void readLODSceneNode(const String& name);

	//--------------------------------------------------------------------------
	// Cg
	//--------------------------------------------------------------------------
	/**
	 * CgXg̓ǂݍ
	 */
	virtual void readLightList();

	/**
	 * Cg̓ǂݍ
	 * @param light Cg
	 */
	virtual void readLight(Light* light);

	/**
	 * ArGgCg̓ǂݍ
	 * @param name O
	 */
	virtual void readAmbientLight(const String& name);

	/**
	 * fBNViCg̓ǂݍ
	 * @param name O
	 */
	virtual void readDirectionalLight(const String& name);

	/**
	 * |CgCg̓ǂݍ
	 * @param name O
	 */
	virtual void readPointLight(const String& name);

	//--------------------------------------------------------------------------
	// f
	//--------------------------------------------------------------------------
	/**
	 * fXg̓ǂݍ
	 */
	virtual void readModelList();

	/**
	 * Wf̓ǂݍ
	 * @param name O
	 */
	virtual void readStandardModel(const String& name);

	/**
	 * LN^f̓ǂݍ
	 * @param name O
	 */
	virtual void readCharacterModel(const String& name);

	/**
	 * {[̓ǂݍ
	 * @param model Ǎ惂f
	 * @param name O
	 */
	virtual void readBone(CharacterModel* model, const String& name);

	//--------------------------------------------------------------------------
	// bV
	//--------------------------------------------------------------------------
	/**
	 * bVXg̓ǂݍ
	 */
	virtual void readMeshList();

	/**
	 * ̃bV̓ǂݍ
	 * @param name O
	 */
	virtual void readRigidMesh(const String& name);

	/**
	 * LN^bV̓ǂݍ
	 * @param name O
	 */
	virtual void readCharacterMesh(const String& name);

	//--------------------------------------------------------------------------
	// bVf[^
	//--------------------------------------------------------------------------
	/**
	 * bVf[^Xg̓ǂݍ
	 */
	virtual void readMeshDataList();

	/**
	 * bVf[^̓ǂݍ
	 * @param name O
	 */
	virtual void readMeshData(const String& name);

	//--------------------------------------------------------------------------
	// }eA
	//--------------------------------------------------------------------------
	/**
	 * }eAXg̓ǂݍ
	 */
	virtual void readMaterialList();

	/**
	 * }eA̓ǂݍ
	 * @param material }eA
	 */
	virtual void readMaterial(Material* material);

	/**
	 * {}eA̓ǂݍ
	 * @param name O
	 */
	virtual void readBasicMaterial(const String& name);

	//--------------------------------------------------------------------------
	// eNX`
	//--------------------------------------------------------------------------
	/**
	 * eNX`Xg̓ǂݍ
	 */
	virtual void readTextureList();

	/**
	 * T[tF[XeNX`̓ǂݍ
	 * @param name O
	 */
	virtual void readSurfaceTexture(const String& name);

	//--------------------------------------------------------------------------
	// sN`
	//--------------------------------------------------------------------------
	/**
	 * sN`Xg̓ǂݍ
	 */
	virtual void readPictureList();

	/**
	 * RGB8rbgsN`̓ǂݍ
	 * @param name O
	 * @param loader Targa[_
	 * @return ǂݍ񂾃sN`
	 */
	virtual Picture* readPictureRGB8(const String& name, TargaLoader& loader);

	/**
	 * RGBA8rbgsN`̓ǂݍ
	 * @param name O
	 * @param loader Targa[_
	 * @return ǂݍ񂾃sN`
	 */
	virtual Picture* readPictureRGBA8(const String& name, TargaLoader& loader);

	//--------------------------------------------------------------------------
	// V[m[hN
	//--------------------------------------------------------------------------
	/**
	 * V[m[hNXg̓ǂݍ
	 */
	virtual void readSceneNodeLinkList();

	/**
	 * V[m[hN̓ǂݍ
	 * @param name O
	 */
	virtual void readSceneNodeLink(const String& name);

	//--------------------------------------------------------------------------
	// fN
	//--------------------------------------------------------------------------
	/**
	 * fNXg̓ǂݍ
	 */
	virtual void readModelLinkList();

	/**
	 * fN̓ǂݍ
	 * @param name O
	 */
	virtual void readModelLink(const String& name);

	//--------------------------------------------------------------------------
	// bVN
	//--------------------------------------------------------------------------
	/**
	 * bVNXg̓ǂݍ
	 */
	virtual void readMeshLinkList();

	/**
	 * bVN̓ǂݍ
	 * @param name O
	 */
	virtual void readMeshLink(const String& name);

	//--------------------------------------------------------------------------
	// }eAN
	//--------------------------------------------------------------------------
	/**
	 * }eANXg̓ǂݍ
	 */
	virtual void readMaterialLinkList();

	/**
	 * {}eAN̓ǂݍ
	 * @param name O
	 */
	virtual void readBasicMaterialLink(const String& name);

	//--------------------------------------------------------------------------
	// eNX`N
	//--------------------------------------------------------------------------
	/**
	 * eNX`NXg̓ǂݍ
	 */
	virtual void readTextureLinkList();

	/**
	 * eNX`N̓ǂݍ
	 * @param name O
	 */
	virtual void readTextureLink(const String& name);

	//--------------------------------------------------------------------------
	// l̓ǂݍ
	//--------------------------------------------------------------------------
	/**
	 * booll̓ǂݍ
	 * @return booll
	 */
	virtual bool readBool();

	/**
	 * u_charl̓ǂݍ
	 * @return u_charl
	 */
	virtual u_char readUChar();

	/**
	 * u_shortl̓ǂݍ
	 * @return u_shortl
	 */
	virtual u_short readUShort();

	/**
	 * intl̓ǂݍ
	 * @return intl
	 */
	virtual int readInt();

	/**
	 * u_intl̓ǂݍ
	 * @return u_intl
	 */
	virtual u_int readUInt();

	/**
	 * floatl̓ǂݍ
	 * @return floatl
	 */
	virtual float readFloat();

	/**
	 * Vector3l̓ǂݍ
	 * @return Vector3l
	 */
	virtual Vector3 readVector3();

	/**
	 * Matrix34l̓ǂݍ
	 * @return Matrix34l
	 */
	virtual Matrix34 readMatrix34();

	/**
	 * OvfJ[l̓ǂݍ
	 * @return OvfJ[l
	 */
	virtual Color3c readColor3c();

	/**
	 * lvfJ[l̓ǂݍ
	 * @return lvfJ[l
	 */
	virtual Color4c readColor4c();

	/**
	 * OvfJ[l̓ǂݍ
	 * @return OvfJ[l
	 */
	virtual Color3f readColor3f();

	/**
	 * lvfJ[l̓ǂݍ
	 * @return lvfJ[l
	 */
	virtual Color4f readColor4f();

	/**
	 * 񎟌eNX`Wl̓ǂݍ
	 * @return 񎟌eNX`Wl
	 */
	virtual TexCoord2 readTexCoord2();

	/**
	 * {bNX̓ǂݍ
	 * @return {bNX
	 */
	virtual AxisAlignedBox readAxisAlignedBox();

	/**
	 * ̓ǂݍ
	 * @return 
	 */
	virtual Sphere readSphere();

	//--------------------------------------------------------------------------
	// [eBeB
	//--------------------------------------------------------------------------
	/**
	 * g[N̓ǂݍ
	 * @param caller Ăяo
	 */
	virtual String readToken(const String& caller);

	/**
	 * w胏[h̓ǂݔ΂
	 * @param word ǂݔ΂[h
	 */
	virtual void skipWord(const String& word);

	/**
	 * `NJ
	 */
	virtual void openChunk(){ skipWord("{"); }

	/**
	 * `N
	 */
	virtual void closeChunk(){ skipWord("}"); }

	/**
	 * `N̓ǂݔ΂
	 */
	virtual void skipChunk();

	//--------------------------------------------------------------------------
	// o
	//--------------------------------------------------------------------------
	/// x[XpX
	String basePath_;
	/// g[NiCU
	StreamTokenizer* tokenizer_;
	/// V[
	Scene* scene_;
	/// [gm[h
	SceneNode* rootNode_;
	/// V[m[h}l[W
	SceneNodeManager* sceneNodeManager_;
	/// Cg}l[W
	LightManager* lightManager_;
	/// f}l[W
	ModelManager* modelManager_;
	/// bV}l[W
	MeshManager* meshManager_;
	/// bVf[^}l[W
	MeshDataManager* meshDataManager_;
	/// }eA}l[W
	MaterialManager* materialManager_;
	/// eNX`}l[W
	TextureManager* textureManager_;
	/// sN`}l[W
	PictureManager* pictureManager_;

private:
	// Rs[RXgN^̉B
	TextSceneLoader(const TextSceneLoader& copy);

	// Rs[̉B
	void operator =(const TextSceneLoader& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TEXT_SCENE_LOADER_H_
//------------------------------------------------------------------------------
