//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * oCiV[[_wb_
 * @author Junpee
 */

#ifndef BINARY_SCENE_LOADER_H_
#define BINARY_SCENE_LOADER_H_

namespace Lamp{

class BinaryReader;
class TargaLoader;
class Scene;
class SceneNodeManager;
class SceneNode;
class LightManager;
class Light;
class ModelManager;
class CharacterModel;
class MeshManager;
class MeshDataManager;
class MeshData;
class MaterialManager;
class Material;
class BasicMaterial;
class TextureManager;
class PictureManager;
class Picture;

//------------------------------------------------------------------------------
/**
 * oCiV[[_
 */
class BinarySceneLoader{
public:
	/**
	 * RXgN^
	 */
	BinarySceneLoader();

	/**
	 * fXgN^
	 */
	virtual ~BinarySceneLoader();

	/**
	 * [h
	 * @param filePath t@CpX
	 * @param scene [hV[
	 */
	virtual void load(const String& filePath, Scene* scene);

	/**
	 * [h
	 * @param filePath t@CpX
	 * @param scene [hV[
	 * @param rootNode [h惋[gm[h
	 */
	virtual void load(const String& filePath, Scene* scene,
		SceneNode* rootNode);

	/**
	 * [h
	 * @param binaryReader oCi[_
	 * @param scene [hV[
	 * @param basePath x[XpX
	 */
	virtual void load(BinaryReader* binaryReader, Scene* scene,
		const String& basePath = "");

	/**
	 * [h
	 * @param binaryReader oCi[_
	 * @param scene [hV[
	 * @param rootNode [h惋[gm[h
	 * @param basePath x[XpX
	 */
	virtual void load(BinaryReader* binaryReader, Scene* scene,
		SceneNode* rootNode, const String& basePath = "");

protected:
	/**
	 * wb_̓ǂݍ
	 */
	virtual void readHeader();

	//--------------------------------------------------------------------------
	// tHO
	//--------------------------------------------------------------------------
	/**
	 * tHO̓ǂݍ
	 */
	virtual void readFog();

	//--------------------------------------------------------------------------
	// V[m[h
	//--------------------------------------------------------------------------
	/**
	 * V[m[hXg̓ǂݍ
	 * @param listSize XgTCY
	 */
	virtual void readSceneNodeList(int listSize);

	/**
	 * V[m[h̓ǂݍ
	 */
	virtual void readSceneNode();

	/**
	 * xIufBeB[V[m[h̓ǂݍ
	 */
	virtual void readLODSceneNode();

	//--------------------------------------------------------------------------
	// Cg
	//--------------------------------------------------------------------------
	/**
	 * CgXg̓ǂݍ
	 * @param listSize XgTCY
	 */
	virtual void readLightList(int listSize);

	/**
	 * Cg̓ǂݍ
	 * @param light Cg
	 */
	virtual void readLight(Light* light);

	/**
	 * ArGgCg̓ǂݍ
	 */
	virtual void readAmbientLight();

	/**
	 * fBNViCg̓ǂݍ
	 */
	virtual void readDirectionalLight();

	/**
	 * |CgCg̓ǂݍ
	 */
	virtual void readPointLight();

	//--------------------------------------------------------------------------
	// f
	//--------------------------------------------------------------------------
	/**
	 * fXg̓ǂݍ
	 * @param listSize XgTCY
	 */
	virtual void readModelList(int listSize);

	/**
	 * Wf̓ǂݍ
	 */
	virtual void readStandardModel();

	/**
	 * LN^f̓ǂݍ
	 */
	virtual void readCharacterModel();

	/**
	 * {[̓ǂݍ
	 * @param model Ǎ惂f
	 */
	virtual void readBone(CharacterModel* model);

	//--------------------------------------------------------------------------
	// bV
	//--------------------------------------------------------------------------
	/**
	 * bVXg̓ǂݍ
	 * @param listSize XgTCY
	 */
	virtual void readMeshList(int listSize);

	/**
	 * ̃bV̓ǂݍ
	 */
	virtual void readRigidMesh();

	/**
	 * LN^bV̓ǂݍ
	 */
	virtual void readCharacterMesh();

	//--------------------------------------------------------------------------
	// bVf[^
	//--------------------------------------------------------------------------
	/**
	 * bVf[^Xg̓ǂݍ
	 * @param listSize XgTCY
	 */
	virtual void readMeshDataList(int listSize);

	/**
	 * bVf[^̓ǂݍ
	 */
	virtual void readMeshData();

	//--------------------------------------------------------------------------
	// }eA
	//--------------------------------------------------------------------------
	/**
	 * }eAXg̓ǂݍ
	 * @param listSize XgTCY
	 */
	virtual void readMaterialList(int listSize);

	/**
	 * }eA̓ǂݍ
	 * @param material }eA
	 */
	virtual void readMaterial(Material* material);

	/**
	 * {}eA̓ǂݍ
	 */
	virtual void readBasicMaterial();

	//--------------------------------------------------------------------------
	// eNX`
	//--------------------------------------------------------------------------
	/**
	 * eNX`Xg̓ǂݍ
	 * @param listSize XgTCY
	 */
	virtual void readTextureList(int listSize);

	/**
	 * T[tF[XeNX`̓ǂݍ
	 */
	virtual void readSurfaceTexture();

	//--------------------------------------------------------------------------
	// sN`
	//--------------------------------------------------------------------------
	/**
	 * sN`Xg̓ǂݍ
	 * @param listSize XgTCY
	 */
	virtual void readPictureList(int listSize);

	/**
	 * RGB8rbgsN`̓ǂݍ
	 * @param name O
	 * @param loader Targa[_
	 * @return ǂݍ񂾃sN`
	 */
	virtual Picture* readPictureRGB8(const String& name, TargaLoader& loader);

	/**
	 * RGBA8rbgsN`̓ǂݍ
	 * @param name O
	 * @param loader Targa[_
	 * @return ǂݍ񂾃sN`
	 */
	virtual Picture* readPictureRGBA8(const String& name, TargaLoader& loader);

	//--------------------------------------------------------------------------
	// V[m[hN
	//--------------------------------------------------------------------------
	/**
	 * V[m[hNXg̓ǂݍ
	 * @param listSize XgTCY
	 */
	virtual void readSceneNodeLinkList(int listSize);

	/**
	 * V[m[hN̓ǂݍ
	 */
	virtual void readSceneNodeLink();

	//--------------------------------------------------------------------------
	// fN
	//--------------------------------------------------------------------------
	/**
	 * fNXg̓ǂݍ
	 * @param listSize XgTCY
	 */
	virtual void readModelLinkList(int listSize);

	/**
	 * fN̓ǂݍ
	 */
	virtual void readModelLink();

	//--------------------------------------------------------------------------
	// bVN
	//--------------------------------------------------------------------------
	/**
	 * bVNXg̓ǂݍ
	 * @param listSize XgTCY
	 */
	virtual void readMeshLinkList(int listSize);

	/**
	 * bVN̓ǂݍ
	 */
	virtual void readMeshLink();

	//--------------------------------------------------------------------------
	// }eAN
	//--------------------------------------------------------------------------
	/**
	 * }eANXg̓ǂݍ
	 * @param listSize XgTCY
	 */
	virtual void readMaterialLinkList(int listSize);

	/**
	 * {}eAN̓ǂݍ
	 */
	virtual void readBasicMaterialLink();

	//--------------------------------------------------------------------------
	// eNX`N
	//--------------------------------------------------------------------------
	/**
	 * eNX`NXg̓ǂݍ
	 * @param listSize XgTCY
	 */
	virtual void readTextureLinkList(int listSize);

	/**
	 * eNX`N̓ǂݍ
	 */
	virtual void readTextureLink();

	//--------------------------------------------------------------------------
	// l̓ǂݍ
	//--------------------------------------------------------------------------
	/**
	 * ̓ǂݍ
	 * @return 
	 */
	virtual String readString();

	/**
	 * OxNg̓ǂݍ
	 * @return OxNg
	 */
	virtual Vector3 readVector3();

	/**
	 * 3~4s̓ǂݍ
	 * @return 3~4s
	 */
	virtual Matrix34 readMatrix34();

	/**
	 * OvfJ[l̓ǂݍ
	 * @return OvfJ[l
	 */
	virtual Color3c readColor3c();

	/**
	 * lvfJ[l̓ǂݍ
	 * @return lvfJ[l
	 */
	virtual Color4c readColor4c();

	/**
	 * OvfJ[l̓ǂݍ
	 * @return OvfJ[l
	 */
	virtual Color3f readColor3f();

	/**
	 * lvfJ[l̓ǂݍ
	 * @return lvfJ[l
	 */
	virtual Color4f readColor4f();

	/**
	 * 񎟌eNX`Wl̓ǂݍ
	 * @return 񎟌eNX`Wl
	 */
	virtual TexCoord2 readTexCoord2();

	/**
	 * {bNX̓ǂݍ
	 * @return {bNX
	 */
	virtual AxisAlignedBox readAxisAlignedBox();

	/**
	 * ̓ǂݍ
	 * @return 
	 */
	virtual Sphere readSphere();

	//--------------------------------------------------------------------------
	// [eBeB
	//--------------------------------------------------------------------------
	/**
	 * ACg
	 */
	virtual void align();

	/**
	 * ID̓ǂݍ
	 * @return ID
	 */
	virtual String readID();

	//--------------------------------------------------------------------------
	// o
	//--------------------------------------------------------------------------
	/// [_
	BinaryReader* reader_;
	/// obt@TCY
	static const int stringBufferSize_ = 256;
	/// obt@
	char stringBuffer_[stringBufferSize_];
	/// x[XpX
	String basePath_;
	/// V[
	Scene* scene_;
	/// [gm[h
	SceneNode* rootNode_;
	/// V[m[h}l[W
	SceneNodeManager* sceneNodeManager_;
	/// Cg}l[W
	LightManager* lightManager_;
	/// f}l[W
	ModelManager* modelManager_;
	/// bV}l[W
	MeshManager* meshManager_;
	/// bVf[^}l[W
	MeshDataManager* meshDataManager_;
	/// }eA}l[W
	MaterialManager* materialManager_;
	/// eNX`}l[W
	TextureManager* textureManager_;
	/// sN`}l[W
	PictureManager* pictureManager_;

private:
	// Rs[RXgN^̉B
	BinarySceneLoader(const BinarySceneLoader& copy);

	// Rs[̉B
	void operator =(const BinarySceneLoader& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of BINARY_SCENE_LOADER_H_
//------------------------------------------------------------------------------
