//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * tHOwb_
 * @author Junpee
 */

#ifndef FOG_H_
#define FOG_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * tHO
 */
class Fog{
friend class Scene;
public:
	/// [h
	enum Mode{
		/// `tHO
		modeLinear = 0,
		/// wtHO
		modeExponent,
		/// ̎wtHO
		modeExponent2
	};

	//--------------------------------------------------------------------------
	/**
	 * El̎擾
	 * @return El
	 */
	virtual float getLimit();

	//--------------------------------------------------------------------------
	/**
	 * LA̐ݒ
	 * @param enabled trueȂLAfalseȂ疳
	 */
	virtual void setEnabled(bool enabled){ enabled_ = enabled; }

	/**
	 * LA̎擾
	 * @return trueȂLAfalseȂ疳
	 */
	virtual bool isEnabled() const{ return enabled_; }

	//--------------------------------------------------------------------------
	/**
	 * F̐ݒ
	 * @param color F
	 */
	virtual void setColor(const Color4c& color){
		Assert(color.a == 0);
		color_ = color;
	}

	/**
	 * F̎擾
	 * @return F
	 */
	virtual const Color4c& getColor() const{ return color_; }

	//--------------------------------------------------------------------------
	/**
	 * [h̐ݒ
	 * @param mode [h
	 */
	virtual void setMode(Mode mode){ mode_ = mode; }

	/**
	 * [h̎擾
	 * @return [h
	 */
	virtual Mode getMode() const{ return mode_; }

	/**
	 * [h̐ݒ
	 * @param mode [h
	 */
	virtual void setModeString(const String& mode){
		if(mode == "linear"){
			mode_ = modeLinear;
		}else if(mode == "exponent"){
			mode_ = modeExponent;
		}else if(mode == "exponent2"){
			mode_ = modeExponent2;
		}else{
			ErrorOut("Fog::setModeString() "
				"Unknown fog mode " + mode);
		}
	}

	/**
	 * [h̎擾
	 * @return [h
	 */
	virtual String getModeString() const{
		if(mode_ == modeLinear){
			return "linear";
		}else if(mode_ == modeExponent){
			return "exponent";
		}else if(mode_ == modeExponent2){
			return "exponent2";
		}
		return "";
	}

	//--------------------------------------------------------------------------
	/**
	 * Zx̐ݒ
	 *
	 * [hmodeExponentAmodeExponent2̎Ɏgp܂
	 * @param density Zx
	 */
	virtual void setDensity(float density){
		Assert(density >= 0.f);
		Assert(density <= 1.f);
		density_ = density;
	}

	/**
	 * Zx̎擾
	 *
	 * [hmodeExponentAmodeExponent2̎Ɏgp܂
	 * @return Zx
	 */
	virtual float getDensity() const{ return density_; }

	//--------------------------------------------------------------------------
	/**
	 * jA̐ݒ
	 *
	 * [hmodeLifogNear̎Ɏgp܂
	 * @param fogNear jA
	 */
	virtual void setNear(float fogNear){
		Assert(fogNear >= 0.f);
		fogNear_ = fogNear;
	}

	/**
	 * jA̎擾
	 *
	 * [hmodeLifogNear̎Ɏgp܂
	 * @return jA
	 */
	virtual float getNear() const{ return fogNear_; }

	//--------------------------------------------------------------------------
	/**
	 * t@[̐ݒ
	 *
	 * [hmodeLifogNear̎Ɏgp܂
	 * @param fogFar t@[
	 */
	virtual void setFar(float fogFar){
		Assert(fogFar >= 0.f);
		fogFar_ = fogFar;
	}

	/**
	 * t@[̎擾
	 *
	 * [hmodeLifogNear̎Ɏgp܂
	 * @return t@[
	 */
	virtual float getFar() const{ return fogFar_; }

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 */
	Fog();

	/**
	 * fXgN^
	 */
	virtual ~Fog();

	//--------------------------------------------------------------------------
private:
	// Rs[RXgN^̉B
	Fog(const Fog& copy);

	// Rs[̉B
	void operator =(const Fog& copy);

	// F
	Color4c color_;
	// [h
	Mode mode_;
	// Zx
	float density_;
	// jA
	float fogNear_;
	// t@[
	float fogFar_;
	// LA
	bool enabled_;
	// ~bgl
	static const float limitValue;
	// whbvIt~bgW
	static const float exponentLimit;
	// ̎whbvIt~bgW
	static const float exponent2Limit;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of FOG_H_
//------------------------------------------------------------------------------
