//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OtBbNXfoCXwb_
 * @author Junpee
 */

#ifndef GRAPHICS_DEVICE_INFORMATION_H_
#define GRAPHICS_DEVICE_INFORMATION_H_

#include <Core/Container/ArrayList.h>

namespace Lamp{

class GraphicsDeviceEnumeration;
class GraphicsAdapterInformation;
class GraphicsDeviceComboInformation;

//------------------------------------------------------------------------------
/**
 * OtBbNXfoCX
 */
class GraphicsDeviceInformation{
friend class GraphicsAdapterInformation;
public:
	//--------------------------------------------------------------------------
	/**
	 * A_v^ԍ̎擾
	 * @return A_v^ԍ
	 */
	virtual int getAdapterOrdinal(){ return adapterOrdinal_; }

	/**
	 * foCX^Cv̎擾
	 * @return foCX^Cv
	 */
	virtual D3DDEVTYPE getDeviceType(){ return deviceType_; }

	//--------------------------------------------------------------------------
	/**
	 * foCX\͂̎擾
	 * @return foCX\
	 */
	virtual const D3DCapacity& getDeviceCapability(){
		return deviceCapability_;
	}

	//--------------------------------------------------------------------------
	/**
	 * foCXR{̎擾
	 * @return foCXR{
	 */
	virtual int getDeviceComboCount() const{ return deviceCombos_.getCount(); }

	/**
	 * foCXR{̎擾
	 * @param index CfbNX
	 * @return foCXR{
	 */
	virtual GraphicsDeviceComboInformation* getDeviceCombo(int index){
		return deviceCombos_.get(index);
	}

	//--------------------------------------------------------------------------
	/**
	 * ւ̕ϊ
	 * @return GraphicsDeviceInformation̕\L
	 */
	virtual String toString();

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 */
	GraphicsDeviceInformation();

	/**
	 * fXgN^
	 */
	virtual ~GraphicsDeviceInformation();

	/**
	 * 
	 * @param enumeration OtBbNXfoCX
	 * @param adapterInformation OtBbNXA_v^
	 * @param deviceType foCX^Cv
	 * @return 񋓂true
	 */
	virtual bool enumerate(GraphicsDeviceEnumeration* enumeration,
		GraphicsAdapterInformation* adapterInformation, D3DDEVTYPE deviceType);

private:
	// Rs[RXgN^̉B
	GraphicsDeviceInformation(const GraphicsDeviceInformation& copy);

	// Rs[̉B
	void operator =(const GraphicsDeviceInformation& copy);

	// A_v^ԍ
	int adapterOrdinal_;
	// foCX^Cv
	D3DDEVTYPE deviceType_;
	// foCX\
	D3DCapacity deviceCapability_;
	// foCXR{
	ArrayList<GraphicsDeviceComboInformation*> deviceCombos_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of GRAPHICS_DEVICE_INFORMATION_H_
//------------------------------------------------------------------------------
